/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.ByteSlicePool;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ByteSliceReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexOptions;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexableField;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ParallelPostingsArray;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ByteBlockPool;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRefHash;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Counter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IntBlockPool;
import java.io.IOException;

abstract class TermsHashPerField
implements Comparable<TermsHashPerField> {
    private static final int HASH_INIT_SIZE = 4;
    private final TermsHashPerField nextPerField;
    private final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    private final ByteSlicePool slicePool;
    private int[] termStreamAddressBuffer;
    private int streamAddressOffset;
    private final int streamCount;
    private final String fieldName;
    final IndexOptions indexOptions;
    private final BytesRefHash bytesHash;
    ParallelPostingsArray postingsArray;
    private int lastDocID;
    private int[] sortedTermIDs;
    private boolean doNextCall;

    TermsHashPerField(int streamCount, IntBlockPool intPool, ByteBlockPool bytePool, ByteBlockPool termBytePool, Counter bytesUsed, TermsHashPerField nextPerField, String fieldName, IndexOptions indexOptions) {
        this.intPool = intPool;
        this.bytePool = bytePool;
        this.slicePool = new ByteSlicePool(bytePool);
        this.streamCount = streamCount;
        this.fieldName = fieldName;
        this.nextPerField = nextPerField;
        assert (indexOptions != IndexOptions.NONE);
        this.indexOptions = indexOptions;
        PostingsBytesStartArray byteStarts = new PostingsBytesStartArray(this, bytesUsed);
        this.bytesHash = new BytesRefHash(termBytePool, 4, byteStarts);
    }

    void reset() {
        this.bytesHash.clear(false);
        this.sortedTermIDs = null;
        if (this.nextPerField != null) {
            this.nextPerField.reset();
        }
    }

    final void initReader(ByteSliceReader reader, int termID, int stream) {
        assert (stream < this.streamCount);
        int streamStartOffset = this.postingsArray.addressOffset[termID];
        int[] streamAddressBuffer = this.intPool.buffers[streamStartOffset >> 13];
        int offsetInAddressBuffer = streamStartOffset & 0x1FFF;
        reader.init(this.bytePool, this.postingsArray.byteStarts[termID] + stream * ByteSlicePool.FIRST_LEVEL_SIZE, streamAddressBuffer[offsetInAddressBuffer + stream]);
    }

    final void sortTerms() {
        assert (this.sortedTermIDs == null);
        this.sortedTermIDs = this.bytesHash.sort();
    }

    final int[] getSortedTermIDs() {
        assert (this.sortedTermIDs != null);
        return this.sortedTermIDs;
    }

    final void reinitHash() {
        this.sortedTermIDs = null;
        this.bytesHash.reinit();
    }

    private void add(int textStart, int docID) throws IOException {
        int termID = this.bytesHash.addByPoolOffset(textStart);
        if (termID >= 0) {
            this.initStreamSlices(termID, docID);
        } else {
            this.positionStreamSlice(termID, docID);
        }
    }

    private void initStreamSlices(int termID, int docID) throws IOException {
        if (this.streamCount + this.intPool.intUpto > 8192) {
            this.intPool.nextBuffer();
        }
        if (32768 - this.bytePool.byteUpto < 2 * this.streamCount * ByteSlicePool.FIRST_LEVEL_SIZE) {
            this.bytePool.nextBuffer();
        }
        this.termStreamAddressBuffer = this.intPool.buffer;
        this.streamAddressOffset = this.intPool.intUpto;
        this.intPool.intUpto += this.streamCount;
        this.postingsArray.addressOffset[termID] = this.streamAddressOffset + this.intPool.intOffset;
        for (int i = 0; i < this.streamCount; ++i) {
            int upto = this.slicePool.newSlice(ByteSlicePool.FIRST_LEVEL_SIZE);
            this.termStreamAddressBuffer[this.streamAddressOffset + i] = upto + this.bytePool.byteOffset;
        }
        this.postingsArray.byteStarts[termID] = this.termStreamAddressBuffer[this.streamAddressOffset];
        this.newTerm(termID, docID);
    }

    private boolean assertDocId(int docId) {
        assert (docId >= this.lastDocID) : "docID must be >= " + this.lastDocID + " but was: " + docId;
        this.lastDocID = docId;
        return true;
    }

    void add(BytesRef termBytes, int docID) throws IOException {
        assert (this.assertDocId(docID));
        int termID = this.bytesHash.add(termBytes);
        if (termID >= 0) {
            this.initStreamSlices(termID, docID);
        } else {
            termID = this.positionStreamSlice(termID, docID);
        }
        if (this.doNextCall) {
            this.nextPerField.add(this.postingsArray.textStarts[termID], docID);
        }
    }

    private int positionStreamSlice(int termID, int docID) throws IOException {
        termID = -termID - 1;
        int intStart = this.postingsArray.addressOffset[termID];
        this.termStreamAddressBuffer = this.intPool.buffers[intStart >> 13];
        this.streamAddressOffset = intStart & 0x1FFF;
        this.addTerm(termID, docID);
        return termID;
    }

    final void writeByte(int stream, byte b) {
        int streamAddress = this.streamAddressOffset + stream;
        int upto = this.termStreamAddressBuffer[streamAddress];
        byte[] bytes = this.bytePool.getBuffer(upto >> 15);
        assert (bytes != null);
        int offset = upto & Short.MAX_VALUE;
        if (bytes[offset] != 0) {
            offset = this.slicePool.allocSlice(bytes, offset);
            bytes = this.bytePool.buffer;
            this.termStreamAddressBuffer[streamAddress] = offset + this.bytePool.byteOffset;
        }
        bytes[offset] = b;
        int n = streamAddress;
        this.termStreamAddressBuffer[n] = this.termStreamAddressBuffer[n] + 1;
    }

    final void writeBytes(int stream, byte[] b, int offset, int len) {
        int end = offset + len;
        int streamAddress = this.streamAddressOffset + stream;
        int upto = this.termStreamAddressBuffer[streamAddress];
        byte[] slice = this.bytePool.getBuffer(upto >> 15);
        assert (slice != null);
        int sliceOffset = upto & Short.MAX_VALUE;
        while (slice[sliceOffset] == 0 && offset < end) {
            slice[sliceOffset++] = b[offset++];
            int n = streamAddress;
            this.termStreamAddressBuffer[n] = this.termStreamAddressBuffer[n] + 1;
        }
        while (offset < end) {
            int offsetAndLength = this.slicePool.allocKnownSizeSlice(slice, sliceOffset);
            sliceOffset = offsetAndLength >> 8;
            int sliceLength = offsetAndLength & 0xFF;
            slice = this.bytePool.buffer;
            int writeLength = Math.min(sliceLength - 1, end - offset);
            System.arraycopy(b, offset, slice, sliceOffset, writeLength);
            offset += writeLength;
            this.termStreamAddressBuffer[streamAddress] = (sliceOffset += writeLength) + this.bytePool.byteOffset;
        }
    }

    final void writeVInt(int stream, int i) {
        assert (stream < this.streamCount);
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(stream, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte(stream, (byte)i);
    }

    final TermsHashPerField getNextPerField() {
        return this.nextPerField;
    }

    final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public final int compareTo(TermsHashPerField other) {
        return this.fieldName.compareTo(other.fieldName);
    }

    void finish() throws IOException {
        if (this.nextPerField != null) {
            this.nextPerField.finish();
        }
    }

    final int getNumTerms() {
        return this.bytesHash.size();
    }

    boolean start(IndexableField field, boolean first) {
        if (this.nextPerField != null) {
            this.doNextCall = this.nextPerField.start(field, first);
        }
        return true;
    }

    abstract void newTerm(int var1, int var2) throws IOException;

    abstract void addTerm(int var1, int var2) throws IOException;

    abstract void newPostingsArray();

    abstract ParallelPostingsArray createPostingsArray(int var1);

    private static final class PostingsBytesStartArray
    extends BytesRefHash.BytesStartArray {
        private final TermsHashPerField perField;
        private final Counter bytesUsed;

        private PostingsBytesStartArray(TermsHashPerField perField, Counter bytesUsed) {
            this.perField = perField;
            this.bytesUsed = bytesUsed;
        }

        @Override
        public int[] init() {
            if (this.perField.postingsArray == null) {
                this.perField.postingsArray = this.perField.createPostingsArray(2);
                this.perField.newPostingsArray();
                this.bytesUsed.addAndGet((long)this.perField.postingsArray.size * (long)this.perField.postingsArray.bytesPerPosting());
            }
            return this.perField.postingsArray.textStarts;
        }

        @Override
        public int[] grow() {
            ParallelPostingsArray postingsArray = this.perField.postingsArray;
            int oldSize = this.perField.postingsArray.size;
            postingsArray = this.perField.postingsArray = postingsArray.grow();
            this.perField.newPostingsArray();
            this.bytesUsed.addAndGet((long)postingsArray.bytesPerPosting() * (long)(postingsArray.size - oldSize));
            return postingsArray.textStarts;
        }

        @Override
        public int[] clear() {
            if (this.perField.postingsArray != null) {
                this.bytesUsed.addAndGet(-(this.perField.postingsArray.size * this.perField.postingsArray.bytesPerPosting()));
                this.perField.postingsArray = null;
                this.perField.newPostingsArray();
            }
            return null;
        }

        @Override
        public Counter bytesUsed() {
            return this.bytesUsed;
        }
    }
}

