/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.QueryVisitor;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;

public final class BoostQuery
extends Query {
    private final Query query;
    private final float boost;

    public BoostQuery(Query query, float boost) {
        this.query = Objects.requireNonNull(query);
        if (!Float.isFinite(boost) || Float.compare(boost, 0.0f) < 0) {
            throw new IllegalArgumentException("boost must be a positive float, got " + boost);
        }
        this.boost = boost;
    }

    public Query getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BoostQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(BoostQuery other) {
        return this.query.equals(other.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.query.hashCode();
        h2 = 31 * h2 + Float.floatToIntBits(this.boost);
        return h2;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (this.boost == 1.0f) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            BoostQuery in = (BoostQuery)rewritten;
            return new BoostQuery(in.query, this.boost * in.boost);
        }
        if (rewritten.getClass() == MatchNoDocsQuery.class) {
            return rewritten;
        }
        if (this.boost == 0.0f && rewritten.getClass() != ConstantScoreQuery.class) {
            return new BoostQuery(new ConstantScoreQuery(rewritten), 0.0f);
        }
        if (this.query != rewritten) {
            return new BoostQuery(rewritten, this.boost);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")");
        builder.append("^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.query.createWeight(searcher, scoreMode, this.boost * boost);
    }
}

