/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.filter2.recordlevel;

import com.dataiku.dss.shadelib.org.apache.parquet.filter2.recordlevel.FilteringGroupConverter;
import com.dataiku.dss.shadelib.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import com.dataiku.dss.shadelib.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateEvaluator;
import com.dataiku.dss.shadelib.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateResetter;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.ColumnPath;
import com.dataiku.dss.shadelib.org.apache.parquet.io.PrimitiveColumnIO;
import com.dataiku.dss.shadelib.org.apache.parquet.io.api.GroupConverter;
import com.dataiku.dss.shadelib.org.apache.parquet.io.api.RecordMaterializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilteringRecordMaterializer<T>
extends RecordMaterializer<T> {
    private final RecordMaterializer<T> delegate;
    private final FilteringGroupConverter rootConverter;
    private final IncrementallyUpdatedFilterPredicate filterPredicate;

    public FilteringRecordMaterializer(RecordMaterializer<T> delegate, List<PrimitiveColumnIO> columnIOs, Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn, IncrementallyUpdatedFilterPredicate filterPredicate) {
        Objects.requireNonNull(columnIOs, "columnIOs cannot be null");
        Objects.requireNonNull(valueInspectorsByColumn, "valueInspectorsByColumn cannot be null");
        this.filterPredicate = Objects.requireNonNull(filterPredicate, "filterPredicate cannot be null");
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        HashMap<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath = new HashMap<List<Integer>, PrimitiveColumnIO>();
        for (PrimitiveColumnIO c : columnIOs) {
            List indexFieldPath = Arrays.stream(c.getIndexFieldPath()).boxed().collect(Collectors.toList());
            columnIOsByIndexFieldPath.put(indexFieldPath, c);
        }
        this.rootConverter = new FilteringGroupConverter(delegate.getRootConverter(), Collections.emptyList(), valueInspectorsByColumn, columnIOsByIndexFieldPath);
    }

    @Override
    public T getCurrentRecord() {
        boolean keep = IncrementallyUpdatedFilterPredicateEvaluator.evaluate(this.filterPredicate);
        IncrementallyUpdatedFilterPredicateResetter.reset(this.filterPredicate);
        return keep ? (T)this.delegate.getCurrentRecord() : null;
    }

    @Override
    public void skipCurrentRecord() {
        this.delegate.skipCurrentRecord();
    }

    @Override
    public GroupConverter getRootConverter() {
        return this.rootConverter;
    }

    @Deprecated
    public static List<Integer> getIndexFieldPathList(PrimitiveColumnIO c) {
        return FilteringRecordMaterializer.intArrayToList(c.getIndexFieldPath());
    }

    @Deprecated
    public static List<Integer> intArrayToList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>(arr.length);
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }
}

