/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.Descriptor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.MetaData;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.MultipartConfig;

public class MultiPartConfigAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public MultiPartConfigAnnotationHandler(WebAppContext context) {
        super(false, context);
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        MultipartConfig multi = clazz.getAnnotation(MultipartConfig.class);
        if (multi == null) {
            return;
        }
        MetaData metaData = this._context.getMetaData();
        for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
            Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.multipart-config");
            if (d != null) continue;
            metaData.setOrigin(holder.getName() + ".servlet.multipart-config", multi, clazz);
            holder.getRegistration().setMultipartConfig(new MultipartConfigElement(multi));
        }
    }
}

