/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.FileID;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.ResourceFactory;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiReleaseJarFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiReleaseJarFile.class);
    private final Path jarFile;
    private final Resource jarResource;
    private final ResourceFactory.Closeable resourceFactory;

    public MultiReleaseJarFile(Path jarFile) {
        Objects.requireNonNull(jarFile, "Jar File");
        if (!Files.exists(jarFile, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + String.valueOf(jarFile));
        }
        if (!Files.isRegularFile(jarFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a file: " + String.valueOf(jarFile));
        }
        if (!FileID.isJavaArchive(jarFile)) {
            throw new IllegalArgumentException("Not a Jar: " + String.valueOf(jarFile));
        }
        if (!Files.isReadable(jarFile)) {
            throw new IllegalArgumentException("Unable to read Jar file: " + String.valueOf(jarFile));
        }
        this.jarFile = jarFile;
        this.resourceFactory = ResourceFactory.closeable();
        this.jarResource = this.resourceFactory.newJarFileResource(jarFile.toUri());
        if (LOG.isDebugEnabled()) {
            LOG.debug("mounting {}", (Object)this.jarResource);
        }
    }

    public Stream<Path> stream() throws IOException {
        Path rootPath = this.jarResource.getPath();
        return Files.walk(rootPath, new FileVisitOption[0]).filter(FileID::isNotMetaInfVersions);
    }

    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing {}", (Object)this.jarResource);
        }
        this.resourceFactory.close();
    }

    public String toString() {
        return this.jarFile.toString();
    }
}

