/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ImmutableTypedToken;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.Token;
import java.net.URI;
import org.immutables.value.Value;

@Value.Immutable
public interface TypedToken
extends Token {
    public static final URI URN_ACCESS_TOKEN = URI.create("urn:ietf:params:oauth:token-type:access_token");
    public static final URI URN_REFRESH_TOKEN = URI.create("urn:ietf:params:oauth:token-type:refresh_token");
    public static final URI URN_ID_TOKEN = URI.create("urn:ietf:params:oauth:token-type:id_token");
    public static final URI URN_SAML1 = URI.create("urn:ietf:params:oauth:token-type:saml1");
    public static final URI URN_SAML2 = URI.create("urn:ietf:params:oauth:token-type:saml2");
    public static final URI URN_JWT = URI.create("urn:ietf:params:oauth:token-type:jwt");

    public URI getTokenType();

    public static TypedToken of(String payload, URI type) {
        return ImmutableTypedToken.builder().payload(payload).tokenType(type).build();
    }

    public static TypedToken of(Token token, URI type) {
        return ImmutableTypedToken.builder().from(token).tokenType(type).build();
    }

    public static TypedToken of(AccessToken accessToken) {
        return TypedToken.of(accessToken, URN_ACCESS_TOKEN);
    }
}

