/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.http.impl;

import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.RequestContext;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.ResponseContext;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.impl.HttpHeaders;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

public class RequestContextImpl
implements RequestContext {
    private final HttpHeaders headers;
    private final URI uri;
    private final HttpClient.Method method;
    private final Object body;
    private List<BiConsumer<ResponseContext, Exception>> responseCallbacks;

    public RequestContextImpl(HttpHeaders headers, URI uri, HttpClient.Method method, Object body) {
        this.headers = headers;
        this.uri = uri;
        this.method = method;
        this.body = body;
    }

    @Override
    public void putHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    @Override
    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public HttpClient.Method getMethod() {
        return this.method;
    }

    @Override
    public Optional<String> getContentType() {
        return this.headers.getFirstValue("Content-Type");
    }

    @Override
    public Optional<Object> getBody() {
        return Optional.ofNullable(this.body);
    }

    @Override
    public boolean isFormEncoded() {
        return this.getMethod() == HttpClient.Method.POST && this.getContentType().filter(ct -> ct.equals("application/x-www-form-urlencoded")).isPresent();
    }

    @Override
    public void addResponseCallback(BiConsumer<ResponseContext, Exception> responseCallback) {
        if (this.responseCallbacks == null) {
            this.responseCallbacks = new ArrayList<BiConsumer<ResponseContext, Exception>>();
        }
        this.responseCallbacks.add(responseCallback);
    }

    @Override
    public List<BiConsumer<ResponseContext, Exception>> getResponseCallbacks() {
        return this.responseCallbacks;
    }

    public String toString() {
        return this.method.toString() + " " + String.valueOf(this.uri);
    }
}

