/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.deployer.common.infra.DeploymentInfrasDAO;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasDAO;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.nodeclients.AbstractDeployerClientProxyUser;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIDeployerControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/project-deployer"})
public class PublicAPIProjectDeployerController
extends PublicAPIDeployerControllerBase {
    @Autowired
    private ProjectDeploymentsService deploymentsService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private AutomationNodeInfrasService infrasService;
    @Autowired
    private AutomationNodeInfrasDAO automationNodeInfrasDAO;
    private static final String DEPLOYMENT_TYPE = "Project";
    private static final String PUBLISHED_ITEM_ID = "Project";

    ProjectDeploymentsService getDeploymentsService() {
        return this.deploymentsService;
    }

    PublishedProjectsService getPublishedItemsService() {
        return this.publishedProjectsService;
    }

    AutomationNodeInfrasService getInfrasService() {
        return this.infrasService;
    }

    protected DeploymentInfrasDAO<AbstractProjectDeploymentInfra> getInfrasDAO() {
        return this.automationNodeInfrasDAO;
    }

    @Override
    protected boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures) {
        return licenseFeatures.bundlesAllowed;
    }

    public PublicAPIProjectDeployerController() {
        super("Project", "Project");
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployments-list"})
    @RequestMapping(value={"/deployments"}, method={RequestMethod.GET})
    public void listDeployments(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeployments(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}"}, method={RequestMethod.GET})
    public void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        super.getDeploymentLightStatus(req, resp, deploymentId);
    }

    @AuditInline
    @RequestMapping(value={"/deployments"}, method={RequestMethod.POST})
    public void createDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean ignoreWarnings) throws Exception {
        AbstractDeployment depl;
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx authCtx;
        DeploymentCreationSettings creationSettings = (DeploymentCreationSettings)this.getRequestBodyAs(req, DeploymentCreationSettings.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.getDeploymentsService().checkDeployPermissions(creationSettings.infraId, creationSettings.publishedProjectKey, authCtx);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)creationSettings.infraId, (AuthCtx)authCtx).infraBasicInfo;
        }
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, creationSettings.publishedProjectKey, Collections.singletonList(creationSettings.bundleId), ignoreWarnings);
        try {
            t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                String deplId = this.getDeploymentsService().create_Check(authCtx, creationSettings.deploymentId, creationSettings.publishedProjectKey, creationSettings.infraId, creationSettings.bundleId, creationSettings.deployedProjectKey, creationSettings.projectFolderId);
                depl = this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deplId, authCtx);
                t.commitV("Created Project deployment: %s", new Object[]{depl.id});
                this.auditTrailService.generic("projectdeployer-deployment-create").with("deploymentId", creationSettings.deploymentId).with("infraId", creationSettings.infraId).with("publishedProjectKey", creationSettings.publishedProjectKey).emit();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-deployment-create", (Throwable)e).with("deploymentId", creationSettings.deploymentId).with("infraId", creationSettings.infraId).with("publishedProjectKey", creationSettings.publishedProjectKey).emit();
            throw e;
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)depl);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-delete", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}"}, method={RequestMethod.DELETE})
    public void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        super.deleteDeployment(req, resp, deploymentId, false);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/settings"}, method={RequestMethod.GET})
    public void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        super.getDeploymentSettings(req, resp, deploymentId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-save", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/settings"}, method={RequestMethod.PUT})
    public void saveDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false, defaultValue="false") boolean ignoreWarnings) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractProjectDeployment d = (AbstractProjectDeployment)this.getRequestBodyAs(req, AbstractProjectDeployment.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.getDeploymentsService().checkDeployPermissions(deploymentId, authCtx);
            String infraId = ((AbstractProjectDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check((String)deploymentId, (AuthCtx)authCtx)).infraId;
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)authCtx).infraBasicInfo;
        }
        this.deploymentsService.doGovernanceCheck_NT(infraBasicInfo, d.publishedProjectKey, Collections.singletonList(d.bundleId), ignoreWarnings);
        t = this.transactionService.beginWriteForAPI(req);
        try {
            this.deploymentsService.save_Check((AbstractDeployment)d, t.getUser(), false);
            t.commitV("Updated settings of project deployment %s", new Object[]{deploymentId});
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/status"}, method={RequestMethod.GET})
    public void getDeploymentHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.deploymentsService.getHeavyStatus_Unsafe_NT_Check(authCtx, deploymentId));
    }

    @AuditInline
    @RequestMapping(value={"/deployments/{deploymentId}/governance-status"}, method={RequestMethod.GET})
    public void getGovernanceStatusForDeploymentId(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @RequestParam(required=false) String bundleId) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            AbstractProjectDeployment deployment;
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getTicketOrKey(req);
                deployment = (AbstractProjectDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)user).infraBasicInfo;
            }
            ArrayList<String> bundleIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)bundleId)) {
                bundleIds.add(bundleId);
            } else {
                bundleIds.add(deployment.bundleId);
            }
            InfoMessage.InfoMessages governanceMessages = this.deploymentsService.getGovernanceMessages_NT(infraBasicInfo, deployment.getPublishedItemId(), bundleIds);
            PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
            this.auditTrailService.generic("projectdeployer-deployment-governance-status-get").with("deploymentId", deployment.id).with("publishedServiceId", deployment.getPublishedItemId()).with("infraId", deployment.infraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-sync", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/actions/update"}, method={RequestMethod.POST})
    public void updateDeployment(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        AbstractDeployerClientProxyUser.DeploymentUpdateRequest dur = (AbstractDeployerClientProxyUser.DeploymentUpdateRequest)this.getRequestBodyAsOrNull(req, AbstractDeployerClientProxyUser.DeploymentUpdateRequest.class);
        if (dur == null) {
            dur = new AbstractDeployerClientProxyUser.DeploymentUpdateRequest();
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FutureResponse futureResponse = this.deploymentsService.executeOneStepSync_NT_Check(authCtx, deploymentId);
        if (dur.synchronous) {
            PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.waitForFinalResponse(futureResponse));
        } else {
            PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)futureResponse);
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-list-update-heads", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/update"}, method={RequestMethod.GET})
    public void listDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        List duiList = this.getDeploymentsService().listDeploymentUpdateHeads_Check_NT(deploymentId, authCtx);
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)duiList);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-update", "deploymentId", "${deploymentId}", "timestamp", "${timestamp}"})
    @RequestMapping(value={"/deployments/{deploymentId}/update/{timestamp}"}, method={RequestMethod.GET})
    public void getDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId, @PathVariable String timestamp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        FullDeploymentUpdate dui = this.getDeploymentsService().getDeploymentUpdate_Check_NT(deploymentId, timestamp, authCtx);
        if (dui == null) {
            PublicAPIProjectDeployerController.send404((String)("Deployment update " + timestamp + " does not exist"), (HttpServletResponse)resp);
            return;
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)dui);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-last-update", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/last-update"}, method={RequestMethod.GET})
    public void getLastDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String deploymentId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        DeploymentUpdate dui = this.getDeploymentsService().getLastDeploymentUpdate_Check_NT(deploymentId, authCtx);
        if (dui == null) {
            PublicAPIProjectDeployerController.send404((String)"There is no update for this deployment", (HttpServletResponse)resp);
            return;
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)dui);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-testing-status", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/testing-status"}, method={RequestMethod.GET})
    @ResponseBody
    public TestingStatus getTestingStatus(HttpServletRequest req, @PathVariable String deploymentId, @RequestParam(required=false) String bundleId, @RequestParam(required=false) String automationNodeId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        return this.deploymentsService.getTestingStatus(authCtx, deploymentId, bundleId, automationNodeId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-run-test-scenarios", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/deployments/{deploymentId}/run-test-scenarios"}, method={RequestMethod.POST})
    @ResponseBody
    public TestingStatus runTestScenarios(HttpServletRequest req, @PathVariable String deploymentId, @RequestParam(required=false) String automationNodeId) throws CodedException, DKUSecurityException, IOException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        return this.deploymentsService.runTestScenarios(authCtx, deploymentId, automationNodeId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-projects-list"})
    @RequestMapping(value={"/projects"}, method={RequestMethod.GET})
    public void listProjects(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listItems(req, resp);
    }

    @AuditInline
    @RequestMapping(value={"/projects"}, method={RequestMethod.POST})
    public void createProject(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ProjectCreationSettings creationSettings = (ProjectCreationSettings)this.getRequestBodyAs(req, ProjectCreationSettings.class);
        super.createItem(req, resp, creationSettings.publishedProjectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/projects/{projectKey}"}, method={RequestMethod.DELETE})
    public void deleteProject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        super.deleteItem(authCtx, projectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/projects/{projectKey}"}, method={RequestMethod.GET})
    public void getProjectLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        super.getItemLightStatus(req, resp, projectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/projects/{projectKey}/settings"}, method={RequestMethod.GET})
    public void getProjectSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        super.getItemSettings(req, resp, projectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/projects/{projectKey}/settings"}, method={RequestMethod.PUT})
    public void saveProjectSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        super.saveItemSettings(req, resp, projectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-upload"})
    @RequestMapping(value={"/projects/bundles"}, method={RequestMethod.POST})
    public void uploadBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        this.checkLicense();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.publishedProjectsService.publishBundleFromStream_NT_Check(authCtx, projectKey, filePart.getInputStream()));
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/projects/{projectKey}/bundles/{bundleId}"}, method={RequestMethod.DELETE})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        this.publishedProjectsService.deletePackage_NT_Check(projectKey, bundleId, authCtx);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-download", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/projects/{projectKey}/bundles/{bundleId}"}, method={RequestMethod.GET})
    public void downloadBundleArchive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        File f = this.publishedProjectsService.getPublishedPackageFileMandatory_Check(projectKey, bundleId, authCtx);
        HTTPClientUtils.sendArchiveDownload((File)f, (HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-get-project-standards-report", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/projects/{projectKey}/bundles/{bundleId}/project-standards-report"}, method={RequestMethod.GET})
    public void getProjectStandardsReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.publishedProjectsService.getBundleDetails_NT((String)projectKey, (String)bundleId, (AuthCtx)authCtx).projectStandardsRunReport);
    }

    @AuditedCall(value={"msgType", "projectdeployer-stages-list"})
    @RequestMapping(value={"/stages"}, method={RequestMethod.GET})
    public void listStages(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.getTicketOrKey_NT(req);
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().projectDeployerServerSettings.stages);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infras-list"})
    @RequestMapping(value={"/infras"}, method={RequestMethod.GET})
    public void listInfras(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfras(req, resp);
    }

    @AuditInline
    @RequestMapping(value={"/infras"}, method={RequestMethod.POST})
    public void createInfra(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.checkLicense();
        InfraCreationSettings creationSettings = (InfraCreationSettings)this.getRequestBodyAs(req, InfraCreationSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AbstractDeploymentInfra.InfraType infraType = AbstractDeploymentInfra.InfraType.valueOf((String)creationSettings.infraType);
            this.infrasService.create_Check((AbstractDeploymentInfra)(switch (infraType) {
                case AbstractDeploymentInfra.InfraType.AUTOMATION_NODE -> new SingleAutomationNodeInfra(creationSettings.id, creationSettings.stage, t.getUser().getIdentifier(), creationSettings.automationNodeUrl, creationSettings.apiKey, AbstractDeploymentInfra.GovernCheckPolicy.valueOf((String)creationSettings.governCheckPolicy));
                case AbstractDeploymentInfra.InfraType.MULTI_AUTOMATION_NODE -> new MultiAutomationNodeInfra(creationSettings.id, creationSettings.stage, t.getUser().getIdentifier(), AbstractDeploymentInfra.GovernCheckPolicy.valueOf((String)creationSettings.governCheckPolicy));
                default -> throw ErrorContext.iae((String)("Unsupported infra type: " + String.valueOf(infraType)));
            }), t.getUser());
            PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.infrasService.getSettingsMandatoryUnsafe_CheckAdmin(creationSettings.id, t.getUser()));
            t.commitV("Created %s infra: %s", new Object[]{infraType.name(), creationSettings.id});
            this.auditTrailService.generic("projectdeployer-infra-create").with("infraId", creationSettings.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-infra-create", (Throwable)e).with("infraId", creationSettings.id).emit();
            throw e;
        }
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-get", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/settings"}, method={RequestMethod.GET})
    public void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.getInfraSettings(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-check-read-permission", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/check-read-permission"}, method={RequestMethod.GET})
    public void checkInfraReadPermission(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.checkInfraReadPermission(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-get", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}"}, method={RequestMethod.GET})
    public void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.getInfraLightStatus(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-save", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/settings"}, method={RequestMethod.PUT})
    public void saveInfraSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        AbstractProjectDeploymentInfra infra = (AbstractProjectDeploymentInfra)this.getRequestBodyAs(req, AbstractProjectDeploymentInfra.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.getInfrasService().save_Check((AbstractDeploymentInfra)infra, t.getUser(), false);
            t.commitV("Updated settings of %s infra %s", new Object[]{JSON.getType((Object)infra), infraId});
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-delete", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}"}, method={RequestMethod.DELETE})
    public void deleteInfra(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId) throws Exception {
        super.deleteInfra(req, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-generate-personal-api-key", "infraId", "${infraId}"})
    @RequestMapping(value={"/infras/{infraId}/generate-personal-api-key"}, method={RequestMethod.POST})
    public void generatePersonalAPIKey(HttpServletRequest req, HttpServletResponse resp, @PathVariable String infraId, @RequestParam String label, @RequestParam String description, @RequestParam(required=false) String forUser) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.infrasService.generatePersonalAPIKey_Check(authCtx, infraId, label, description, forUser));
    }

    private static class DeploymentCreationSettings {
        String deploymentId;
        String publishedProjectKey;
        String infraId;
        String bundleId;
        String deployedProjectKey;
        String projectFolderId;

        private DeploymentCreationSettings() {
        }
    }

    private static class ProjectCreationSettings {
        String publishedProjectKey;

        private ProjectCreationSettings() {
        }
    }

    private static class InfraCreationSettings {
        String id;
        String stage;
        String automationNodeUrl;
        String apiKey;
        String governCheckPolicy = AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK.name();
        String infraType = AbstractDeploymentInfra.InfraType.AUTOMATION_NODE.name();

        private InfraCreationSettings() {
        }
    }
}

