/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.activity.GlobalUsageSummaryBuilder;
import com.dataiku.dip.deployer.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIMonitoringController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;

    @AuditedCall(value={"msgType", "monitoring-global-usage"})
    @RequestMapping(value={"/publicapi/admin/monitoring/global-usage-summary"}, method={RequestMethod.GET})
    public void getGlobalUsageSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean withPerProject) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        try {
            PublicAPIMonitoringController.writeJSON((HttpServletResponse)resp, (Object)new GlobalUsageSummaryBuilder().buildGlobalSummary(withPerProject));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to build global report", (Throwable)e);
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "monitoring-activity-metrics"})
    @RequestMapping(value={"/publicapi/admin/monitoring/activity-metrics"}, method={RequestMethod.POST})
    @ResponseBody
    public void receiveActivity(HttpServletRequest req, @RequestParam String graphitePayload) throws DKUSecurityException {
        AuthCtx user;
        Preconditions.checkNotNull((Object)graphitePayload);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(user);
        }
        this.apiEndpointActivityMonitoringService.saveGraphitePayloadFromPush_NT(user, graphitePayload);
    }
}

