/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.sql.ExternalSQLDatasetTestHandler;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.hive.massimport.MetastoreTableToDatasetResyncer;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.metrics.MetricUtils;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetsTestController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets"})
public class PublicAPIDatasetsActionsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private DataQualityRulesLaunchService dataQualityRulesLaunchService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.datasets");

    @AuditedCall(value={"msgType", "dataset-sync-to-hive", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/synchronizeHiveMetastore"}, method={RequestMethod.POST})
    public void synchronizeMetastore(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        InfoMessage.InfoMessages messages;
        AuthCtx authCtx;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        try (HiveMetastoreSynchronizer hms = HiveMetastoreSynchronizerFactory.getSynchronizer((AuthCtx)authCtx);){
            messages = hms.synchronizeOneDataset(dataset, false, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
        }
        messages.summarize();
        PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "dataset-sync-from-hive", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/updateFromHive"}, method={RequestMethod.POST})
    public void updateFromHive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        MetastoreTableToDatasetResyncer htd;
        String fullName;
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            fullName = dataset.getFullName();
            htd = new MetastoreTableToDatasetResyncer();
        }
        HiveImportabilityChecker.HiveTableImportCandidate htic = htd.prepareResyncTable_NT(authCtx, dataset);
        t = this.transactionService.beginWriteForAPI(req);
        try {
            htd.saveResyncTable(t.getUser(), dataset, htic);
            t.commit("Resynchronized dataset " + dataset.getFullName() + " from its Hive definition");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        this.writeMessage(resp, "Updated dataset %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/computeMetrics"}, method={RequestMethod.POST})
    public void computeMetrics(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="") String partition) throws Exception {
        MetricsComputationService.MetricsComputationEnvironment environment;
        ProbesSet probesToCompute;
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            logger.info((Object)"Start to compute");
            String body = IOUtils.toString((InputStream)req.getInputStream());
            if (body != null && body.length() > 0) {
                probesToCompute = (ProbesSet)JSON.parse((String)body, ProbesSet.class);
            } else {
                logger.info((Object)"Probes to compute not specified, using the ones from the dataset config");
                probesToCompute = dataset.getModel().getMetrics();
            }
            environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            logger.info((Object)("Will compute: " + JSON.log((Object)probesToCompute)));
        }
        this.compute(resp, authCtx, dataset, partition, probesToCompute, environment);
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/computeMetricsFromIds"}, method={RequestMethod.POST})
    public void computeMetricsFromIds(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="") String partition) throws Exception {
        MetricsComputationService.MetricsComputationEnvironment environment;
        ProbesSet probesToCompute;
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            logger.info((Object)"Start to compute");
            MetricUtils.CustomMetricsSet cms = (MetricUtils.CustomMetricsSet)this.getRequestBodyAs(req, MetricUtils.CustomMetricsSet.class);
            ProbesSet datasetProbes = dataset.getModel().getMetrics();
            probesToCompute = MetricUtils.probesSetFromMetricIds((ProbesSet)datasetProbes, (List)cms.metricIds);
            environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            logger.info((Object)("Will compute: " + JSON.log((Object)probesToCompute)));
        }
        this.compute(resp, authCtx, dataset, partition, probesToCompute, environment);
    }

    private void compute(HttpServletResponse resp, AuthCtx authCtx, Dataset dataset, String partition, ProbesSet probesToCompute, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition);
        FutureResponse fr = this.metricsLaunchService.launchComputeMetrics(authCtx, dataset, p, probesToCompute, new MetricsEngineDesc.MetricsEngineContext(authCtx), environment);
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/runChecks"}, method={RequestMethod.POST})
    public void runChecks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="") String partition) throws Exception {
        DataQualityRuleSet ruleSet;
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            String body = IOUtils.toString((InputStream)req.getInputStream());
            if (body != null && !body.isEmpty()) {
                ruleSet = (DataQualityRuleSet)JSON.parse((String)body, DataQualityRuleSet.class);
                ruleSet.ensureRulesIdsUsingCheckLegacyIds(true);
                ruleSet.checks.forEach(DataQualityRule::updateDisplayName);
            } else {
                logger.info((Object)"Rule set not specified, using the dataset's own rule set");
                ruleSet = dataset.getModel().getDataQualityRuleSet();
            }
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        }
        Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition);
        FutureResponse fr = this.dataQualityRulesLaunchService.computeRulesOnSinglePartition(authCtx, dataset, ruleSet.checks, p.id(), new DataQualityRulesLaunchService.RunOptions((DataQualityRunOrigin)new DataQualityRunOrigin.PublicAPI(), true, false, true, true, true, false));
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "dataset-detect-settings", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/testAndDetectSettings/fsLike"}, method={RequestMethod.POST})
    public void detectFSLikeSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        FSLikeTestSettings settings = (FSLikeTestSettings)this.getRequestBodyAs(req, FSLikeTestSettings.class);
        DatasetsTestController.TestAndDetectFormatFutureThread ft = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ft = new DatasetsTestController.TestAndDetectFormatFutureThread(authCtx, dataset, settings.detectPossibleFormats, StringUtils.isNotBlank((String)settings.restrictToFormat), settings.restrictToFormat, settings.inferStorageTypes);
        }
        PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runFuture((FutureThreadBase)ft, 0L, (TypeToken)new TypeToken<FutureResponse<FSLikeDatasetTestHandler.FSLikeDatasetTestResult>>(){}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-detect-settings", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/testAndDetectSettings/externalSQL"}, method={RequestMethod.POST})
    public void detectExternalSQLSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        ExternalSQLDatasetTestHandler testHandler;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            testHandler = (ExternalSQLDatasetTestHandler)DatasetHandlerFactory.buildTestHandlerAs((AuthCtx)authCtx, (Dataset)dataset, ExternalSQLDatasetTestHandler.class);
        }
        try {
            PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(false, true, authCtx));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "dataset-detect-settings", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/testAndDetectSettings/elasticsearch"}, method={RequestMethod.POST})
    public void detectElasticSearchSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        ElasticSearchDatasetTestHandler testHandler;
        Dataset dataset;
        boolean connectionOnly = false;
        boolean forConsistencyCheck = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            testHandler = (ElasticSearchDatasetTestHandler)DatasetHandlerFactory.buildTestHandlerAs((AuthCtx)authCtx, (Dataset)dataset, ElasticSearchDatasetTestHandler.class);
        }
        try {
            PublicAPIDatasetsActionsController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(projectKey, dataset, connectionOnly, forConsistencyCheck));
        }
        finally {
            testHandler.close();
        }
    }

    static class FSLikeTestSettings {
        boolean detectPossibleFormats;
        String restrictToFormat;
        boolean inferStorageTypes;

        FSLikeTestSettings() {
        }
    }
}

