/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.ml;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.ClusteringService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationService;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesService;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuessPolicy;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuessPolicy;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringScatterplotSample;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.DecisionTreeSummary;
import com.dataiku.dip.analysis.model.prediction.EnsembleParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.TimeseriesPredictionPermutationImportance;
import com.dataiku.dip.analysis.model.prediction.TimeseriesResiduals;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PreprocessingParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.DatabricksUtilsKernelProtocol;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.scoring.exports.ExportAndRegisterMLflowModelInFutureThread;
import com.dataiku.dip.scoring.exports.JarScoring;
import com.dataiku.dip.scoring.exports.MLflowScoring;
import com.dataiku.dip.scoring.exports.PMMLScoring;
import com.dataiku.dip.scoring.exports.PythonScoring;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/models"})
public class PublicAPIMLLabController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private PredictionRecipesService predictionRecipesService;
    @Autowired
    private ClusteringRecipesService clusteringRecipesService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ModelDocumentGenerationService modelDocumentGenerationService;
    @Autowired
    private FutureService futureService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.api.ml.controller");

    @AuditInline
    @RequestMapping(value={"/lab/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        MLSparkParams sparkParams;
        AnalysisCoreParams acp;
        String analysisId;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        AnalysisAndMLTaskCreationInfo creationInfo = (AnalysisAndMLTaskCreationInfo)this.getRequestBodyAs(req, AnalysisAndMLTaskCreationInfo.class);
        PublicAPIMLLabController.getAndCheckMLTaskCreation(creationInfo);
        this.checkArgument(StringUtils.isNotBlank((String)creationInfo.analysisId) || StringUtils.isNotBlank((String)creationInfo.inputDataset), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Either analysisId or inputDataset must be provided", new Object[0]);
        if (StringUtils.isNotBlank((String)creationInfo.analysisId)) {
            analysisId = creationInfo.analysisId;
        } else {
            Transaction t;
            if (StringUtils.isBlank((String)creationInfo.analysisName)) {
                if ("PREDICTION".equals(creationInfo.taskType)) {
                    t = this.transactionService.beginRead();
                    try {
                        Dataset ds = this.datasetAccessService.getMandatoryUnsafe(projectKey, creationInfo.inputDataset);
                        if (ds.getSchema().getColumn(creationInfo.targetVariable) == null) {
                            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Invalid target variable '" + creationInfo.targetVariable + "', not present in dataset " + creationInfo.inputDataset);
                        }
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                    creationInfo.analysisName = "API-created prediction model for " + creationInfo.targetVariable + " on " + creationInfo.inputDataset;
                } else {
                    creationInfo.analysisName = "API-created clustering model on " + creationInfo.inputDataset;
                }
            }
            if (creationInfo.backendType == MLTask.BackendType.KERAS) {
                authCtx.failIfNoSafeCode("use a custom Keras architecture");
            }
            t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                analysisId = this.analysisCRUDService.create(projectKey, creationInfo.inputDataset, creationInfo.analysisName);
                t.commit("Created analysis for API-created model on " + creationInfo.inputDataset);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            this.auditTrailService.generic("analysis-create").with("projectKey", projectKey).with("datasetRef", creationInfo.inputDataset).with("analysisId", analysisId).emit();
        }
        try (Transaction t = this.transactionService.beginRead();){
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (creationInfo.backendType == null) {
                throw ErrorContext.iae((String)"Invalid ML Backend type");
            }
            if (creationInfo.backendType.isSparkBased()) {
                SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
                if (StringUtils.isBlank((String)creationInfo.sparkConfig)) {
                    creationInfo.sparkConfig = sparkSettings.getDefault().name;
                }
                sparkSettings.getByName(creationInfo.sparkConfig);
                sparkParams = RecipeCreationUtils.setupMLSparkParams((AuthCtx)authCtx, (String)projectKey, (String)creationInfo.sparkConfig, (Boolean)creationInfo.useGlobalMetastore);
            } else {
                sparkParams = null;
            }
        }
        if ("PREDICTION".equals(creationInfo.taskType)) {
            MemScriptRunner.TableWithReport dataTable = this.dataService.getCachedUnfiltered_NOTRANSACTION(acp, authCtx);
            if (!dataTable.table.columns.containsKey(creationInfo.targetVariable)) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Invalid target variable '" + creationInfo.targetVariable + "', not present in analysis");
            }
        }
        String mlTaskId = null;
        if ("PREDICTION".equals(creationInfo.taskType)) {
            pgp = PredictionGuessPolicy.valueOf((String)creationInfo.guessPolicy);
            mlTaskId = this.predictionService.createAndGuess_NT(authCtx, acp, creationInfo.targetVariable, null, creationInfo.backendType, sparkParams, pgp, PublicAPIMLLabController.getAndCheckPredictionType(creationInfo.predictionType), creationInfo.timeVariable, creationInfo.timeseriesIdentifiers, creationInfo.treatmentVariable);
            this.auditTrailService.generic("analysis-prediction-task-create").with("projectKey", projectKey).with("analysisId", analysisId).with("inputDatasetRef", creationInfo.inputDataset).with("mlTaskId", mlTaskId).with("targetVariable", creationInfo.targetVariable).emit();
        } else {
            pgp = ClusteringGuessPolicy.valueOf((String)creationInfo.guessPolicy);
            mlTaskId = this.clusteringService.createAndGuess_NT(authCtx, acp, creationInfo.backendType, sparkParams, (ClusteringGuessPolicy)pgp);
            this.auditTrailService.generic("analysis-clustering-task-create").with("projectKey", projectKey).with("analysisId", analysisId).with("inputDatasetRef", creationInfo.inputDataset).with("mlTaskId", mlTaskId).emit();
        }
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)new LabRef(analysisId, mlTaskId));
    }

    public static void getAndCheckMLTaskCreation(AnalysisAndMLTaskCreationInfo creationInfo) {
        if (StringUtils.isBlank((String)creationInfo.taskType)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Task type not specified (must be PREDICTION or CLUSTERING)");
        }
        if (creationInfo.backendType == null) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Backend type not specified or invalid. Valid backend are: " + JSON.log((Object)ArrayUtils.removeElement((Object[])MLTask.BackendType.values(), (Object)MLTask.BackendType.VERTICA)));
        }
        if (creationInfo.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot create ML task: Vertica ML backend is no longer supported");
        }
        if (StringUtils.isBlank((String)creationInfo.guessPolicy)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Guess policy not specified");
        }
        if ("PREDICTION".equals(creationInfo.taskType)) {
            if (StringUtils.isBlank((String)creationInfo.targetVariable)) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Target variable not specified");
            }
            PublicAPIMLLabController.getAndCheckPredictionType(creationInfo.predictionType);
            if (PredictionMLTask.PredictionType.TIMESERIES_FORECAST.name().equals(creationInfo.predictionType) && StringUtils.isBlank((String)creationInfo.timeVariable)) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Time variable not specified");
            }
            try {
                PredictionGuessPolicy.valueOf((String)creationInfo.guessPolicy);
            }
            catch (IllegalArgumentException e) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Guess policy is invalid. Valid policies are: " + JSON.log((Object)PredictionGuessPolicy.values()));
            }
        } else if ("CLUSTERING".equals(creationInfo.taskType)) {
            if (StringUtils.isNotBlank((String)creationInfo.predictionType)) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot specify a prediction type for a non-prediction problem");
            }
            try {
                ClusteringGuessPolicy.valueOf((String)creationInfo.guessPolicy);
            }
            catch (IllegalArgumentException e) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Guess policy is invalid. Valid policies are: " + JSON.log((Object)ClusteringGuessPolicy.values()));
            }
        } else {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Task type is invalid. Valid task types are PREDICTION and CLUSTERING");
        }
    }

    @AuditedCall(value={"msgType", "analysis-mltask-guess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/guess"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseBody
    public MLTask guessMLTaskSettings(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @RequestParam(required=false) String predictionType, @RequestParam(required=false) String targetVariable, @RequestParam(required=false) String timeVariable, @RequestParam(required=false) List<String> timeseriesIdentifiers, @RequestParam(required=false, defaultValue="true") boolean fullReguess) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc;
        AnalysisCoreParams acp;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (this.mlBaseService.isGuessing(loc)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "ML Task is already in guessing state. Wait for guessing to finish");
        }
        if (mlTask.taskType.equals((Object)MLTask.MLTaskType.PREDICTION)) {
            PredictionMLTask pml = (PredictionMLTask)mlTask;
            if (StringUtils.isNotBlank((String)targetVariable)) {
                if (StringUtils.isNotBlank((String)predictionType)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "predictionType cannot be specified when targetVariable is provided");
                }
                if (StringUtils.isNotBlank((String)timeVariable)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "timeVariable cannot be specified when targetVariable is provided");
                }
                if (timeseriesIdentifiers != null) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "timeseriesIdentifiers cannot be specified when targetVariable is provided");
                }
                return this.predictionService.reguessWithTarget_NT(authCtx, acp, loc, pml, targetVariable, fullReguess);
            }
            if (StringUtils.isNotBlank((String)timeVariable)) {
                if (StringUtils.isNotBlank((String)predictionType)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "predictionType cannot be specified when timeVariable is provided");
                }
                if (timeseriesIdentifiers != null) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "timeseriesIdentifiers cannot be specified when timeVariable is provided");
                }
                if (!(pml instanceof PredictionMLTask.TimeseriesForecastingMLTask)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Guessing with time variable is only available for time series forecast ML tasks");
                }
                return this.predictionService.reguessWithTimeVariable_NT(authCtx, acp, loc, (PredictionMLTask.TimeseriesForecastingMLTask)pml, timeVariable, fullReguess);
            }
            if (timeseriesIdentifiers != null) {
                if (StringUtils.isNotBlank((String)predictionType)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "predictionType cannot be specified when timeseriesIdentifiers is provided");
                }
                if (!(pml instanceof PredictionMLTask.TimeseriesForecastingMLTask)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Guessing with time series identifiers is only available for time series forecast ML tasks");
                }
                return this.predictionService.reguessWithTimeseriesIdentifiers_NT(authCtx, acp, loc, (PredictionMLTask.TimeseriesForecastingMLTask)pml, timeseriesIdentifiers, fullReguess);
            }
            if (StringUtils.isNotBlank((String)predictionType)) {
                return this.predictionService.reguessWithType_NT(authCtx, acp, loc, pml, PublicAPIMLLabController.getAndCheckPredictionType(predictionType), fullReguess);
            }
            return this.predictionService.reguess_NT(authCtx, acp, loc, pml);
        }
        if (mlTask.taskType.equals((Object)MLTask.MLTaskType.CLUSTERING)) {
            return this.clusteringService.reguess_NT(authCtx, acp, loc, (ClusteringMLTask)mlTask);
        }
        throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "Wrong task type: " + String.valueOf(mlTask.taskType));
    }

    @AuditedCall(value={"msgType", "analysis-mltask-reguess-with-forecasting-params", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @ResponseBody
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/reguess-with-forecasting-params"}, method={RequestMethod.POST})
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithForecastingParams(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @RequestBody ForecastingParams forecastingParams) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc;
        AnalysisCoreParams acp;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (this.mlBaseService.isGuessing(loc)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "ML Task is already in guessing state. Wait for guessing to finish");
        }
        if (!(mlTask instanceof PredictionMLTask.TimeseriesForecastingMLTask)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "ML Task is not a time series forecasting ML task");
        }
        return this.predictionService.reguessWithTimestepParams_NT(authCtx, acp, loc, (PredictionMLTask.TimeseriesForecastingMLTask)mlTask, forecastingParams.timestepParams, forecastingParams.forecastHorizon, forecastingParams.updateAlgorithmSettings, forecastingParams.validationHorizons);
    }

    @Nullable
    public static PredictionMLTask.PredictionType getAndCheckPredictionType(String predictionType) throws APIIllegalArgumentException {
        if (StringUtils.isNotBlank((String)predictionType)) {
            try {
                return PredictionMLTask.PredictionType.valueOf((String)predictionType);
            }
            catch (IllegalArgumentException e) {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Prediction type is invalid. Valid types are: " + JSON.log((Object)PredictionMLTask.PredictionType.values()) + ", got '" + predictionType + "'", (Throwable)e);
            }
        }
        return null;
    }

    @AuditedCall(value={"msgType", "analysis-mltasks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/lab/"}, method={RequestMethod.GET})
    public void listMLLabTasks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LabRefList ret = new LabRefList();
            for (AnalysisCoreParams.AnalysisListItem ali : this.analysisCRUDService.listHeadsUnsafe(projectKey, null, true)) {
                for (AnalysisCRUDService.MLTaskHead mth : ali.mlTasks) {
                    NamedLabRef nlr = new NamedLabRef();
                    nlr.analysisId = ali.id;
                    nlr.analysisName = ali.name;
                    nlr.mlTaskId = mth.mlTaskId;
                    nlr.mlTaskName = mth.name;
                    nlr.taskType = mth.taskType.toString();
                    nlr.inputDataset = ali.inputDatasetSmartName;
                    ret.mlTasks.add(nlr);
                }
            }
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/settings"}, method={RequestMethod.GET})
    public void getMLTaskSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            MLTask mlTask = this.analysisCRUDService.getMLTask(loc);
            this.cleanupFeatureStateFromMLTask(mlTask);
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)mlTask);
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-save-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/settings"}, method={RequestMethod.POST})
    public void saveMLTaskSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        AuthCtx authCtx = null;
        MLTask task = (MLTask)this.getRequestBodyAs(req, MLTask.class);
        if (task.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot modify ML task settings: Vertica ML backend is no longer supported");
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            this.mergeFeatureStateFromMLTask(task, this.analysisCRUDService.getMLTask(loc));
            this.analysisCRUDService.saveMLTask(loc, task, false);
            t.commit("Saved ML Task settings for " + projectKey + " " + analysisId + " " + mlTaskId);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    private void mergeFeatureStateFromMLTask(MLTask task, MLTask original) {
        Map newFeatures = task.getPreprocessingParams().per_feature;
        Map oldFeatures = original.getPreprocessingParams().per_feature;
        for (Map.Entry e : newFeatures.entrySet()) {
            FeaturePreprocessingParams newFeature = (FeaturePreprocessingParams)e.getValue();
            if (oldFeatures.containsKey(e.getKey())) {
                FeaturePreprocessingParams oldFeature = (FeaturePreprocessingParams)oldFeatures.get(e.getKey());
                if (this.featureIsDifferent(newFeature, oldFeature)) {
                    logger.info((Object)("Flagging feature " + (String)e.getKey() + " as userModified because it changed"));
                    newFeature.state = new FeaturePreprocessingParams.FeatureState();
                    newFeature.state.userModified = true;
                    newFeature.state.recordedMeaning = oldFeature.state != null ? oldFeature.state.recordedMeaning : null;
                    continue;
                }
                newFeature.autoReason = oldFeature.autoReason;
                newFeature.state = oldFeature.state;
                continue;
            }
            logger.info((Object)("Flagging feature " + (String)e.getKey() + " as userModified because it doesn't exist yet"));
            newFeature.state = new FeaturePreprocessingParams.FeatureState();
            newFeature.state.userModified = true;
        }
    }

    private boolean featureIsDifferent(FeaturePreprocessingParams a, FeaturePreprocessingParams b) {
        a = (FeaturePreprocessingParams)JSON.deepCopy((Object)a);
        b = (FeaturePreprocessingParams)JSON.deepCopy((Object)b);
        a.state = null;
        b.state = null;
        a.autoReason = null;
        b.autoReason = null;
        return !JSON.jsonEquals((Object)a, (Object)b);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/status"}, method={RequestMethod.GET})
    public void getMLTaskStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        MLTask mlTask = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getMLTaskStatus_NT(loc));
        } else {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.getMLTaskStatus_NT(loc));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/train-check"}, method={RequestMethod.GET})
    public void checkTrain(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        AnalysisCoreParams coreParams;
        AuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        MLTask mlTask = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
            coreParams = this.analysisCRUDService.getCoreMandatory(loc.analysisProjectKey, loc.analysisId);
        }
        if (mlTask.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot train ML task: Vertica ML backend is no longer supported");
        }
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getPreTrainStatus_NT(loc, authCtx, coreParams, (PredictionMLTask)mlTask));
        } else {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.getPreTrainStatus_NT(loc, authCtx));
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-train", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/train"}, method={RequestMethod.POST})
    public void train(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTask mlTask;
        AnalysisCoreParams acp;
        AuthCtx authCtx;
        TrainParams trainParams = (TrainParams)this.getRequestBodyAsOrNull(req, TrainParams.class);
        if (trainParams == null) {
            trainParams = new TrainParams();
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        SessionRet ret = new SessionRet();
        ret.analysisId = analysisId;
        ret.mlTaskId = mlTaskId;
        if (mlTask.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot train ML task: Vertica ML backend is no longer supported");
        }
        if (this.mlBaseService.isGuessing(loc)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "ML Task is in guessing state, cannot start training. Wait for guessing to finish");
        }
        if (this.mlBaseService.isTraining(loc)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "ML Task still training, cannot start new training. Wait for guessing to finish");
        }
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            ret.sessionId = this.predictionService.trainStart_NT(authCtx, acp, loc, (PredictionMLTask)mlTask, trainParams.sessionName, trainParams.sessionDescription, trainParams.runQueue);
        } else if (mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
            ret.sessionId = this.clusteringService.trainStart_NT(authCtx, acp, loc, (ClusteringMLTask)mlTask, trainParams.sessionName, trainParams.sessionDescription, trainParams.runQueue);
        }
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "analysis-task-get-details", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models-snippets"}, method={RequestMethod.GET})
    public void getModelsSnippets(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        List<FullModelId> fullModelIdList;
        MLTask mlTask;
        ModelsSnippetsRequest request = (ModelsSnippetsRequest)this.getRequestBodyAs(req, ModelsSnippetsRequest.class);
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (request.modelsIds.size() > 0) {
            fullModelIdList = new ArrayList();
            for (String modelId : request.modelsIds) {
                FullModelId fmi = FullModelId.parse((String)modelId);
                fmi.checkIdsValidity(projectKey);
                fullModelIdList.add(fmi);
            }
        } else {
            fullModelIdList = this.predictionService.listTaskModelIds(loc);
        }
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getSnippets_NT((PredictionMLTask)mlTask, fullModelIdList));
        } else if (mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.clusteringService.getSnippets_NT(fullModelIdList));
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-train-queue", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/actions/train-queue"}, method={RequestMethod.POST})
    public void trainQueue(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTask mlTask;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        SessionRet ret = new SessionRet();
        ret.analysisId = analysisId;
        ret.mlTaskId = mlTaskId;
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            ret.sessionId = this.predictionService.trainQueue(acp, loc);
        } else if (mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
            ret.sessionId = this.clusteringService.trainQueue(acp, loc);
        }
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "ml-get-queues", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/labs/mltask-queues"}, method={RequestMethod.GET})
    public void getQueues(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        MLTaskQueueList queueList = new MLTaskQueueList();
        queueList.queues = new ArrayList<MLTaskQueueListItem>();
        Map queues = this.mlBaseService.getQueues();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        for (Map.Entry queue : queues.entrySet()) {
            int queueLength;
            MLTaskLoc loc = (MLTaskLoc)queue.getKey();
            if (!loc.analysisProjectKey.equals(projectKey) || (queueLength = this.mlBaseService.getQueueLength(loc)) <= 0) continue;
            MLTaskQueueListItem listItem = new MLTaskQueueListItem();
            listItem.mlTaskLoc = loc;
            listItem.status = (MLBaseService.MLTaskQueueStatus)queue.getValue();
            listItem.length = queueLength;
            queueList.queues.add(listItem);
        }
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)queueList);
    }

    @AuditedCall(value={"msgType", "analysis-task-get-details", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/details"}, method={RequestMethod.GET})
    public void getModelDetails(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeModelDetails((FullModelId)fmi));
                break;
            }
            case CLUSTERING: {
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ClusteringResultsReader.makeDetails((FullModelId)fmi));
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-per-timeseries-metrics", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "modelFullId", "${modelFullId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/per-timeseries-metrics"}, method={RequestMethod.GET})
    public void getPerTimeseriesMetrics(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series metrics for time series forecasting models");
        }
        if (fmi.isPartitionedBaseModel()) {
            modelPerf = fmi.getPartitionedTimeseriesForecastingPerfs();
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, Map.of("perPartition", modelPerf));
        } else {
            modelPerf = fmi.getTimeseriesForecastingPerf(true);
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, Map.of("perTimeseries", ((TimeseriesForecastingModelPerf)modelPerf).perTimeseriesMetrics));
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-per-timeseries-metrics", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "modelFullId", "${modelFullId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/per-timeseries-evaluation-forecasts"}, method={RequestMethod.GET})
    public void getPerTimeseriesEvaluationForecasts(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        if (fmi.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series evaluation forecasts for time series forecasting models");
        }
        if (fmi.isPartitionedBaseModel()) {
            Map modelEvaluationForecasts = fmi.getPartitionedTimeseriesEvaluationForecasts();
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, Map.of("perPartition", modelEvaluationForecasts));
        } else {
            TimeseriesEvaluationForecasts modelPerf = fmi.getTimeseriesEvaluationForecasts();
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, Map.of("perTimeseries", modelPerf.perTimeseries));
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-compute-shapley-feature-importance", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/shapley-feature-importance"}, method={RequestMethod.POST})
    public void computeShapleyFeatureImportance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTask mlTask;
        DSSAuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.globalExplanationsComputationStart(authCtx, (ModelLikeId)fmi));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot compute Shapley feature importance for clustering models");
            }
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot compute Shapley feature importance for LLM models");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-compute-subpop", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/subpopulation-analyses"}, method={RequestMethod.POST})
    public void computeSubpopulationAnalyses(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTask mlTask;
        DSSAuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PosttrainComputationWithFeaturesReq computationReq = (PosttrainComputationWithFeaturesReq)this.getRequestBodyAs(req, PosttrainComputationWithFeaturesReq.class);
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.subpopulationComputationStart(authCtx, fmi, computationReq.features, computationReq.computationParams, true));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run subpopulation analysis computation for clustering models");
            }
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run subpopulation analysis computation for LLM models");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-subpop", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/subpopulation-analyses"}, method={RequestMethod.GET})
    public void getSubpopulationAnalyses(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makeSubpopulationResults((FullModelId)fmi));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get subpopulation analysis results for clustering models");
            }
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get subpopulation analysis results for LLM models");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-compute-pdp", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/partial-dependencies"}, method={RequestMethod.POST})
    public void computePartialDependencies(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTask mlTask;
        DSSAuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PosttrainComputationWithFeaturesReq computationReq = (PosttrainComputationWithFeaturesReq)this.getRequestBodyAs(req, PosttrainComputationWithFeaturesReq.class);
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.pdpComputationStart(authCtx, (ModelLikeId)fmi, computationReq.features, computationReq.computationParams));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run partial dependency computation for clutering models");
            }
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot run partial dependency computation for LLM models");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-pdp", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/partial-dependencies"}, method={RequestMethod.GET})
    public void getPartialDependencies(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)PredictionResultsReader.makePartialDependenceResults((File)fmi.getModelFolder()));
                break;
            }
            case CLUSTERING: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get partial dependencies results for clustering models");
            }
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot get partial dependencies results for LLM models");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-compute-timeseries-permutation-importance", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/timeseries-permutation-importance"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<TimeseriesPredictionPermutationImportance> computeTimeseriesPermutationImportance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId, @RequestParam JsonObject computationParams) throws Exception {
        DSSAuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            MLTask mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot run permutation importance computation.");
        }
        return this.predictionService.permutationImportanceComputationStart(authCtx, (ModelLikeId)fmi, computationParams);
    }

    @AuditedCall(value={"msgType", "analysis-task-get-timeseries-permutation-importance", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/timeseries-permutation-importance"}, method={RequestMethod.GET})
    @ResponseBody
    public TimeseriesPredictionPermutationImportance getTimeseriesPermutationImportance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            MLTask mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot fetch permutation importance.");
        }
        Optional permutationImportance = fmi.getPermutationImportance();
        if (permutationImportance.isEmpty()) {
            resp.setStatus(404);
            resp.getWriter().write("Permutation importance not found");
            return null;
        }
        return (TimeseriesPredictionPermutationImportance)permutationImportance.get();
    }

    @AuditedCall(value={"msgType", "analysis-task-compute-timeseries-residuals", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/timeseries-residuals"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Map<String, TimeseriesResiduals>> computeTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        DSSAuthCtx authCtx;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            MLTask mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        fmi.checkIdsValidity(projectKey);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot run residuals computation.");
        }
        return this.predictionService.computePerTimeseriesResiduals(authCtx, (ModelLikeId)fmi);
    }

    @AuditedCall(value={"msgType", "analysis-task-get-timeseries-residuals", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{fullModelId}/timeseries-residuals"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, TimeseriesResiduals> getTimeseriesResiduals(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String fullModelId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            MLTask mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)fullModelId);
        if (!fmi.getPredictionType().equals((Object)PredictionMLTask.PredictionType.TIMESERIES_FORECAST)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Model is not a timeseries forecasting model. Cannot fetch residuals.");
        }
        Optional residuals = fmi.parseTimeseriesResiduals((List)Lists.newArrayList());
        if (residuals.isEmpty()) {
            resp.setStatus(404);
            resp.getWriter().write("Residuals not found");
            return null;
        }
        return (Map)residuals.get();
    }

    @AuditedCall(value={"msgType", "analysis-task-delete-model", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}"}, method={RequestMethod.DELETE})
    public void deleteModel(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        this.mlBaseService.deleteModels((List)Lists.newArrayList((Object[])new String[]{modelFullId}));
    }

    @AuditedCall(value={"msgType", "analysis-task-delete", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.analysisCRUDService.getMLTask(loc);
        }
        String commitMessage = "Deleted ML task " + mlTaskId + " in analysis " + analysisId + " in " + projectKey;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.analysisCRUDService.deleteMLTask(projectKey, analysisId, mlTaskId);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "analysis-task-save-meta", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/user-meta"}, method={RequestMethod.PUT})
    public void saveModelUserMeta(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        ModelUserMeta meta = (ModelUserMeta)this.getRequestBodyAs(req, ModelUserMeta.class);
        this.checkNotBlank(meta.name, "Missing name", new Object[0]);
        if (meta.clusterMetas != null) {
            for (ModelUserMeta.ClusterMeta clusterMeta : meta.clusterMetas.values()) {
                this.checkNotBlank(clusterMeta.name, "Missing cluster name", new Object[0]);
            }
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        this.mlBaseService.saveModelUserMeta(fmi, meta);
    }

    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/actions/deployToFlow"}, method={RequestMethod.POST})
    public void deployToFlow(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTask mlTask;
        AuthCtx authCtx;
        DeployOptions options = (DeployOptions)((Object)this.getRequestBodyAs(req, DeployOptions.class));
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (mlTask.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot deploy model: Vertica ML backend is no longer supported");
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        DatasetLocUtils.DatasetLoc trainLoc = DatasetLocUtils.resolveSmart((String)projectKey, (String)options.trainDatasetRef);
        DatasetLocUtils.DatasetLoc testLoc = null;
        if (!StringUtils.isBlank((String)options.testDatasetRef)) {
            testLoc = DatasetLocUtils.resolveSmart((String)projectKey, (String)options.testDatasetRef);
        }
        AnyLoc managedFolderLoc = null;
        if (!StringUtils.isBlank((String)options.managedFolderRef)) {
            managedFolderLoc = AnyLoc.resolveSmart((String)projectKey, (String)options.managedFolderRef);
        }
        switch (mlTask.taskType) {
            case PREDICTION: {
                Pair p = this.predictionRecipesService.createTrainingRecipePrep_NT(authCtx, fmi, (AnyLoc)trainLoc, (AnyLoc)testLoc, (PredictionRecipesService.TrainingRecipeCreationOptions)options, options.modelName, managedFolderLoc);
                DeployRet ret = new DeployRet();
                ret.savedModelId = (String)p.second;
                ret.trainRecipeName = (String)p.first;
                AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.generic("analysis-prediction-task-deploy").with("projectKey", projectKey).with("analysisModelId", modelFullId).with("savedModelId", ret.savedModelId).with("trainDatasetRef", options.trainDatasetRef);
                if (options.testDatasetRef != null) {
                    auditObj = auditObj.with("testDatasetRef", options.testDatasetRef);
                }
                if (options.managedFolderRef != null) {
                    auditObj = auditObj.with("managedFolderRef", options.managedFolderRef);
                }
                auditObj.emit();
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
                break;
            }
            case CLUSTERING: {
                Pair p = this.clusteringRecipesService.createTrainingRecipePrep_NT(authCtx, fmi, trainLoc, options.modelName);
                DeployRet ret = new DeployRet();
                ret.savedModelId = (String)p.second;
                ret.trainRecipeName = (String)p.first;
                this.auditTrailService.generic("analysis-clustering-task-deploy").with("projectKey", projectKey).with("analysisModelId", modelFullId).with("savedModelId", ret.savedModelId).with("trainDatasetRef", options.trainDatasetRef).emit();
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
                break;
            }
        }
    }

    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/actions/redeployToFlow"}, method={RequestMethod.POST})
    public void redeployToFlow(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        SerializedRecipe recipe;
        MLTask mlTask;
        AuthCtx authCtx;
        RedeployOptions options = (RedeployOptions)((Object)this.getRequestBodyAs(req, RedeployOptions.class));
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        HashSet trainingRecipeTypes = Sets.newHashSet((Object[])new String[]{PredictionRecipesMeta.TRAINING_META.getType(), ClusteringRecipesMeta.TRAINING_META.getType()});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
            if (StringUtils.isBlank((String)options.recipeName)) {
                if (StringUtils.isBlank((String)options.savedModelId)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Neither saved model id nor training recipe name are specified");
                }
                for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                    if (!trainingRecipeTypes.contains(sr.getType()) || !options.savedModelId.equals(sr.getSingleOutput((String)"main").ref)) continue;
                    options.recipeName = sr.name;
                    break;
                }
                if (StringUtils.isBlank((String)options.recipeName)) {
                    throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Saved model is not built by a recipe of this project");
                }
            }
            recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, options.recipeName);
        }
        if (mlTask.backendType == MLTask.BackendType.VERTICA) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot redeploy model: Vertica ML backend is no longer supported");
        }
        options.savedModelId = recipe.getSingleOutput((String)"main").ref;
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        if (fmi.isPartitionedBaseModel() && !options.redoOptimization) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot redeploy model: redoOptimization must be true when deploying a partitioned model");
        }
        if (fmi.isPartitionedBaseModel() && !options.redoThresholdOptimization) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Cannot redeploy model: redoThresholdOptimization must be true when deploying a partitioned model");
        }
        switch (mlTask.taskType) {
            case PREDICTION: {
                RedeployRet ret = new RedeployRet();
                ret.impactsDownstream = this.predictionRecipesService.updateTrainingRecipePrep_NT(authCtx, fmi, recipe, options.activate, (PredictionRecipesService.TrainingRecipeCreationOptions)options);
                this.auditTrailService.generic("analysis-prediction-task-redeploy").with("projectKey", projectKey).with("analysisModelId", modelFullId).with("savedModelId", options.savedModelId).emit();
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
                break;
            }
            case CLUSTERING: {
                RedeployRet ret = new RedeployRet();
                ret.impactsDownstream = this.clusteringRecipesService.updateTrainingRecipePrep_NT(authCtx, fmi, recipe, options.activate);
                this.auditTrailService.generic("analysis-clustering-task-deploy").with("projectKey", projectKey).with("analysisModelId", modelFullId).with("savedModelId", options.savedModelId).emit();
                PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)ret);
                break;
            }
        }
    }

    private void cleanupFeatureStateFromMLTask(MLTask task) {
        PreprocessingParams preProcParams = task.getPreprocessingParams();
        if (preProcParams != null && preProcParams.per_feature != null) {
            for (FeaturePreprocessingParams feature : preProcParams.per_feature.values()) {
                feature.state = null;
                feature.autoReason = null;
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-create-ensemble", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/ensemble"}, method={RequestMethod.POST})
    public void createEnsemble(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTask mlTask;
        AnalysisCoreParams acp;
        AuthCtx authCtx;
        EnsembleRequest request = (EnsembleRequest)this.getRequestBodyAs(req, EnsembleRequest.class);
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        if (request.modelsIds.isEmpty()) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "The list of models to ensemble must not be empty");
        }
        ArrayList<FullModelId> list = new ArrayList<FullModelId>();
        for (String modelId : request.modelsIds) {
            FullModelId fmi = FullModelId.parse((String)modelId);
            fmi.checkIdsValidity(projectKey);
            list.add(fmi);
        }
        if (mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
            PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.predictionService.createEnsemble(authCtx, loc, acp, list, request.method).toString()));
        } else if (mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_STATE, "Cannot ensemble cluster models");
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-details", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/trees"}, method={RequestMethod.GET})
    public void getModelTrees(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                if (fmi.getModelFile("tree.json").exists()) {
                    DecisionTreeSummary tree = (DecisionTreeSummary)fmi.parseModelFile("tree.json", DecisionTreeSummary.class);
                    DecisionTreeSummary.TreeEnsembleSummary trees = new DecisionTreeSummary.TreeEnsembleSummary();
                    trees.featureNames = tree.featureNames;
                    trees.classes = tree.classes;
                    trees.trees = Lists.newArrayList((Object[])new DecisionTreeSummary.TreeDescription[]{tree.tree});
                    PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)trees);
                    break;
                }
                if (fmi.getModelFile("trees.json").exists()) {
                    try (FileInputStream fis = new FileInputStream(fmi.getModelFile("trees.json"));){
                        resp.setStatus(200);
                        resp.setContentType("application/json; charset=UTF-8");
                        IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
                        break;
                    }
                }
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Not implemented for this type of model");
            }
            case CLUSTERING: 
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Not implemented for this type of model");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-details", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/coef-paths"}, method={RequestMethod.GET})
    public void getModelCoefPaths(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: {
                if (fmi.getModelFile("coef_path.json").exists()) {
                    try (FileInputStream fis = new FileInputStream(fmi.getModelFile("coef_path.json"));){
                        resp.setStatus(200);
                        resp.setContentType("application/json; charset=UTF-8");
                        IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
                        break;
                    }
                }
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Not implemented for this type of model");
            }
            case CLUSTERING: 
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Not implemented for this type of model");
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-get-details", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/scatter-plots"}, method={RequestMethod.GET})
    public void getModelScatterPlot(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        MLTask mlTask;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mlTask = this.analysisCRUDService.getMLTask(loc);
        }
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        switch (mlTask.taskType) {
            case PREDICTION: 
            case LLM_CLASSIFICATION: 
            case LLM_GENERIC_PROMPTABLE_COMPLETION: 
            case LLM_GENERIC_RAW: {
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "Not implemented for this type of model");
            }
            case CLUSTERING: {
                resp.setStatus(200);
                resp.setContentType("application/json");
                try (PrintWriter writer = new PrintWriter(new BufferedOutputStream((OutputStream)resp.getOutputStream()));){
                    ClusteringScatterplotSample.streamAsJson((String)fmi.getModelFolder().getAbsolutePath(), (Writer)writer);
                    break;
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to send scatter plot data", (Throwable)e);
                    resp.setStatus(404);
                    resp.getWriter().write("Failed to send scatter plot data of clustering model");
                }
            }
        }
    }

    @AuditedCall(value={"msgType", "analysis-task-cleanup", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/actions/removeUnusedSplits"}, method={RequestMethod.POST})
    public void removeUnusedSplits(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.mlBaseService.keepOnlyUsedSplits(loc);
    }

    @AuditedCall(value={"msgType", "analysis-task-cleanup", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/actions/removeAllSplits"}, method={RequestMethod.POST})
    public void removeAllSplits(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId) throws Exception {
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.mlBaseService.deleteAllSplits(loc);
    }

    @AuditInline
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/scoring-pmml"}, method={RequestMethod.GET})
    public void getModelPmml(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        try {
            ScoringExporter.checkExportLicenced();
            FullModelId fmi = FullModelId.parse((String)modelFullId);
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)new PMMLScoring(fmi));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", "pmml").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", "pmml").emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/scoring-jar"}, method={RequestMethod.GET})
    public void getModelJar(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId, @RequestParam(required=false, defaultValue="model.Model") String fullClassName, @RequestParam(required=false, defaultValue="false") Boolean includeLibs) throws Exception {
        try {
            ScoringExporter.checkExportLicenced();
            FullModelId fmi = FullModelId.parse((String)modelFullId);
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)new JarScoring(includeLibs.booleanValue(), fmi, fullClassName));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", "jar").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", "jar").emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/scoring-python"}, method={RequestMethod.GET})
    public void getModelPython(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId, @RequestParam(required=false, defaultValue="false") boolean mlflowExport, @RequestParam(required=false, defaultValue="false") boolean useOriginalMLflowModel) throws Exception {
        try {
            ScoringExporter.checkExportLicenced();
            FullModelId fmi = FullModelId.parse((String)modelFullId);
            fmi.checkIdsValidity(projectKey);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            ScoringExporter exporter = new ScoringExporter((ScoringExporter.ScoringWriter)(mlflowExport ? new MLflowScoring(fmi, useOriginalMLflowModel) : new PythonScoring(fmi)));
            exporter.exportTo(resp);
            this.auditTrailService.generic("ml-prediction-model-export").with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", mlflowExport ? "mlflow" : "python").with("exportId", exporter.exportId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("ml-prediction-model-export", (Throwable)e).with("projectKey", projectKey).with("fullModelId", modelFullId).with("format", mlflowExport ? "mlflow" : "python").emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "ml-model-export-to-databricks-registry", "projectKey", "${projectKey}", "modelFullId", "${modelFullId}", "connectionName", "${connectionName}", "useUnityCatalog", "${useUnityCatalog}", "modelName", "${modelName}", "experimentName", "${experimentName}"})
    @ResponseBody
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/export-to-databricks-registry"})
    public FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse> exportToDatabricksRegistry(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId, @RequestParam String connectionName, @RequestParam(defaultValue="false") boolean useUnityCatalog, @RequestParam String modelName, @RequestParam String experimentName) throws Exception {
        DSSAuthCtx authCtx;
        ScoringExporter.checkExportLicenced();
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable((AuthCtx)authCtx, (String)connectionName);
        return this.futureService.runFuture((FutureThreadBase)new ExportAndRegisterMLflowModelInFutureThread((AuthCtx)authCtx, fmi, connection, useUnityCatalog, modelName, experimentName, List.of()), 0L, (TypeToken)new TypeToken<FutureResponse<DatabricksUtilsKernelProtocol.RequestModelRegistrationResponse>>(){});
    }

    @AuditedCall(value={"msgType", "model-document-generation", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "${modelFullId}", "modelFullId"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/generate-documentation-from-custom-template"}, method={RequestMethod.POST})
    public void generateDocumentationFromCustomTemplate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId, @RequestParam(value="file") MultipartFile customTemplate) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, customTemplate.getInputStream(), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-generation", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "${modelFullId}", "modelFullId"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/generate-documentation-from-template-in-folder"}, method={RequestMethod.POST})
    public void generateDocumentationFromTemplateInFolder(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId, @RequestParam String folderId, @RequestParam String path) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        String fullModelId = fmi.toString();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.modelDocumentGenerationService.getTemplate(false, fullModelId, (AuthCtx)authCtx, projectKey, folderId, path);
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, (InputStream)new FileInputStream(template), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-generate", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "${modelFullId}", "modelFullId"})
    @RequestMapping(value={"/lab/{analysisId}/{mlTaskId}/models/{modelFullId}/generate-documentation-from-default-template"}, method={RequestMethod.POST})
    public void generateDocumentationFromDefaultTemplate(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String analysisId, @PathVariable String mlTaskId, @PathVariable String modelFullId) throws Exception {
        DSSAuthCtx authCtx;
        FullModelId fmi = FullModelId.parse((String)modelFullId);
        fmi.checkIdsValidity(projectKey);
        String fullModelId = fmi.toString();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, fmi.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.modelDocumentGenerationService.getDefaultTemplate(fullModelId);
        PublicAPIMLLabController.writeJSON((HttpServletResponse)resp, (Object)this.modelDocumentGenerationService.generateDocument(authCtx, projectKey, (InputStream)new FileInputStream(template), fmi));
    }

    @AuditedCall(value={"msgType", "model-document-download", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/lab/documentations/{exportId}"}, method={RequestMethod.GET})
    public void downloadModelDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
        }
        File modelDocumentation = this.modelDocumentGenerationService.getMdgFile(exportId);
        if (modelDocumentation == null) {
            throw new NotFoundException("Model Documentation with id '" + exportId + "' doesn't exist or hasn't finished exporting");
        }
        MDGFileUtil.sendDocxDownload((File)modelDocumentation, (HttpServletResponse)resp);
    }

    static class AnalysisAndMLTaskCreationInfo {
        public String analysisId;
        public String analysisName;
        public String inputDataset;
        public String taskType;
        public String targetVariable;
        public MLTask.BackendType backendType;
        public String sparkConfig = "default";
        public Boolean useGlobalMetastore;
        public String guessPolicy;
        public String predictionType;
        public String timeVariable;
        public List<String> timeseriesIdentifiers;
        public String treatmentVariable;

        AnalysisAndMLTaskCreationInfo() {
        }
    }

    public static class LabRef {
        public String analysisId;
        public String mlTaskId;

        LabRef() {
        }

        LabRef(String analysisId, String mlTaskId) {
            this.analysisId = analysisId;
            this.mlTaskId = mlTaskId;
        }
    }

    public static class ForecastingParams {
        @Nullable
        TimestepParams timestepParams;
        @Nullable
        Long forecastHorizon;
        @Nullable
        Long validationHorizons;
        boolean updateAlgorithmSettings = true;
    }

    static class LabRefList {
        List<NamedLabRef> mlTasks = new ArrayList<NamedLabRef>();

        LabRefList() {
        }
    }

    static class NamedLabRef
    extends LabRef {
        String analysisName;
        String mlTaskName;
        String taskType;
        String inputDataset;

        NamedLabRef() {
        }
    }

    static class TrainParams {
        String sessionName;
        String sessionDescription;
        boolean runQueue;

        TrainParams() {
        }
    }

    static class SessionRet
    extends LabRef {
        String sessionId;

        SessionRet() {
        }
    }

    static class ModelsSnippetsRequest {
        public List<String> modelsIds = new ArrayList<String>();

        ModelsSnippetsRequest() {
        }
    }

    static class MLTaskQueueList {
        List<MLTaskQueueListItem> queues;

        MLTaskQueueList() {
        }
    }

    static class MLTaskQueueListItem {
        MLTaskLoc mlTaskLoc;
        MLBaseService.MLTaskQueueStatus status;
        int length;

        MLTaskQueueListItem() {
        }
    }

    static class PosttrainComputationWithFeaturesReq {
        List<String> features;
        JsonObject computationParams;

        PosttrainComputationWithFeaturesReq() {
        }
    }

    static class DeployOptions
    extends PredictionRecipesService.TrainingRecipeCreationOptions {
        public String modelName;
        public String trainDatasetRef;
        public String testDatasetRef;
        public String managedFolderRef;

        DeployOptions() {
        }
    }

    static class DeployRet {
        String savedModelId;
        String trainRecipeName;

        DeployRet() {
        }
    }

    static class RedeployOptions
    extends PredictionRecipesService.TrainingRecipeCreationOptions {
        public String recipeName;
        public String savedModelId;
        public boolean activate;

        RedeployOptions() {
        }
    }

    static class RedeployRet {
        boolean impactsDownstream;

        RedeployRet() {
        }
    }

    static class EnsembleRequest {
        public EnsembleParams.EnsembleMethod method;
        public List<String> modelsIds = new ArrayList<String>();

        EnsembleRequest() {
        }
    }
}

