/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/bundles"})
public class PublicAPIBundlesExportController
extends PublicAPIControllerBase {
    @Autowired
    private DesignBundlesService designBundlesService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ProjectStandardsService projectStandardsService;

    @AuditedCall(value={"msgType", "design-bundles-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/exported"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
        }
        PublicAPIBundlesExportController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.listAvailable(projectKey));
    }

    @AuditedCall(value={"msgType", "design-bundle-get", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/exported/{bundleId:.+}"}, method={RequestMethod.GET})
    public void getBundleDetails(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
        }
        PublicAPIBundlesExportController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.getBundleDetails(projectKey, bundleId));
    }

    @AuditedCall(value={"msgType", "design-bundle-create", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/exported/{bundleId:.+}"}, method={RequestMethod.PUT})
    public void createBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId, @RequestParam(required=false) @Nullable String releaseNotes, @RequestParam(defaultValue="true") boolean evaluateProjectStandardsChecks) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
        }
        ExportedProject.ExportUserInfo userInfo = new ExportedProject.ExportUserInfo();
        if (StringUtils.isNotBlank((String)releaseNotes)) {
            VariablesContext variablesContext = this.variablesService.getForProject(projectKey);
            userInfo.releaseNotes = variablesContext.expandAllowUnresolved(releaseNotes).trim();
        }
        if (!evaluateProjectStandardsChecks && !this.projectStandardsService.getGeneralParametersUnsafe().canSkipProjectStandardsChecks) {
            throw new IllegalArgumentException("Creating a bundle without evaluating Project Standards Checks is not allowed by configuration");
        }
        FutureResponse fr = this.designBundlesService.startExportBundle_NT(projectKey, bundleId, DKUApp.getInstallId(), DKUApp.getNodeId(), ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl, userInfo, evaluateProjectStandardsChecks, authCtx);
        fr = this.futureService.waitForFinalResponse(fr);
        this.writeMessage(resp, "Created Bundle", new Object[0]);
    }

    @AuditedCall(value={"msgType", "design-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/exported/{bundleId:.+}"}, method={RequestMethod.DELETE})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
        }
        this.designBundlesService.deleteBundle(projectKey, bundleId);
        this.writeMessage(resp, "Deleted Bundle", new Object[0]);
    }

    @AuditedCall(value={"msgType", "design-bundle-download", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/exported/{bundleId}/archive"}, method={RequestMethod.GET})
    public void downloadBundleArchive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
        }
        File f = this.designBundlesService.getBundleArchive(projectKey, bundleId);
        HTTPClientUtils.sendArchiveDownload((File)f, (HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "publish-to-deployer", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/{bundleId}/publish"}, method={RequestMethod.POST})
    public void publishBundleToProjectDeployer(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId, @RequestParam(required=false) String publishedProjectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkCanExportAndManageBundles(authCtx, projectKey);
            this.publishedProjectsService.checkCreatePermission(authCtx);
        }
        PublicAPIBundlesExportController.writeJSON((HttpServletResponse)resp, (Object)this.designBundlesService.publishBundle(projectKey, publishedProjectKey, bundleId, authCtx));
    }
}

