/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.connections.ConnectionsDumpService;
import com.dataiku.dip.server.services.ConnectionMetadataService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionsIndexingService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ExternalDataCatalogService externalCatalogService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ConnectionsDumpService dumpService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private ConnectionMetadataService connectionMetadataService;
    private Map<String, ConnectionMetadataState> volatileState = new HashMap<String, ConnectionMetadataState>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionMetadataDAO.ConnectionMetadataWithState getMetadataWithState(String connectionName) throws IOException {
        ConnectionMetadataDAO.ConnectionMetadata cm = this.connectionMetadataService.getConnectionMetadata(connectionName);
        if (cm == null) {
            return null;
        }
        ConnectionMetadataDAO.ConnectionMetadataWithState ret = (ConnectionMetadataDAO.ConnectionMetadataWithState)JSON.parse((String)JSON.json((Object)cm), ConnectionMetadataDAO.ConnectionMetadataWithState.class);
        ConnectionsIndexingService connectionsIndexingService = this;
        synchronized (connectionsIndexingService) {
            ConnectionMetadataState state = this.volatileState.get(connectionName);
            if (state != null) {
                ret.currentJobId = state.currentJobId;
                ret.processingStep = state.processingStep;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ConnectionMetadataDAO.ConnectionMetadataWithState> getAllMetadataWithState() throws IOException {
        HashMap<String, ConnectionMetadataDAO.ConnectionMetadataWithState> ret = new HashMap<String, ConnectionMetadataDAO.ConnectionMetadataWithState>();
        Map allCM = this.connectionMetadataService.getAllConnectionsMetadata();
        ConnectionsIndexingService connectionsIndexingService = this;
        synchronized (connectionsIndexingService) {
            for (Map.Entry e : allCM.entrySet()) {
                ConnectionMetadataDAO.ConnectionMetadataWithState cmws = (ConnectionMetadataDAO.ConnectionMetadataWithState)JSON.parse((String)JSON.json(e.getValue()), ConnectionMetadataDAO.ConnectionMetadataWithState.class);
                ConnectionMetadataState state = this.volatileState.get(e.getKey());
                if (state != null) {
                    cmws.currentJobId = state.currentJobId;
                    cmws.processingStep = state.processingStep;
                }
                ret.put((String)e.getKey(), cmws);
            }
        }
        return ret;
    }

    public synchronized FutureResponse<InfoMessage.InfoMessages> startIndex(Set<String> connections, AuthCtx user) throws Exception {
        if (!this.externalCatalogService.isInitialized()) {
            throw new IllegalStateException("Initial indexing not complete yet, please wait");
        }
        Set<String> validConnections = this.filterProcessableConnections(user, connections);
        Sets.SetView scannedNotCurrentlyProcessedConnections = Sets.intersection(validConnections, (Set)this.dumpService.getScannedConnections());
        Map map = this.connectionMetadataService.getAllConnectionsMetadata();
        for (String c : scannedNotCurrentlyProcessedConnections) {
            if (map.containsKey(c)) continue;
            ConnectionMetadataDAO.ConnectionMetadata mc = new ConnectionMetadataDAO.ConnectionMetadata();
            mc.dssConnectionName = c;
            this.connectionMetadataService.save(mc);
        }
        IndexConnectionsThread ft = new IndexConnectionsThread(user, (Collection<String>)scannedNotCurrentlyProcessedConnections);
        return this.futureService.runFuture((FutureThreadBase)ft, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public synchronized FutureResponse<InfoMessage.InfoMessages> startScanAndIndex(Set<String> connections, AuthCtx user) throws Exception {
        if (!this.externalCatalogService.isInitialized()) {
            throw new IllegalStateException("Initial indexing not complete yet, please wait");
        }
        Set<String> validConnections = this.filterProcessableConnections(user, connections);
        Map map = this.connectionMetadataService.getAllConnectionsMetadata();
        for (String c : validConnections) {
            if (map.containsKey(c)) continue;
            ConnectionMetadataDAO.ConnectionMetadata mc = new ConnectionMetadataDAO.ConnectionMetadata();
            mc.dssConnectionName = c;
            this.connectionMetadataService.save(mc);
        }
        ScanConnectionsThread ft = new ScanConnectionsThread(user, validConnections);
        return this.futureService.runFuture((FutureThreadBase)ft, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> filterProcessableConnections(AuthCtx authCtx, Set<String> connections) throws DKUSecurityException {
        HashSet<String> result = new HashSet<String>();
        for (String connection : connections) {
            try {
                DSSConnection conn = this.connectionsDAO.getConnection(authCtx, connection);
                if (!(conn instanceof AbstractSQLConnection) && !(conn instanceof IcebergConnection)) continue;
                ConnectionsIndexingService connectionsIndexingService = this;
                synchronized (connectionsIndexingService) {
                    ConnectionMetadataState cs = this.volatileState.get(connection);
                    if (cs != null && cs.currentJobId != null) {
                        logger.info((Object)("Skipping connection " + connection + ": already processing"));
                        continue;
                    }
                }
                result.add(connection);
            }
            catch (IOException e) {
                logger.errorV("Couldn't read connection %s", new Object[]{connection});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAllIndexation(AuthCtx liu) throws IOException {
        HashSet<String> indexingJobsToAbort = new HashSet<String>();
        ConnectionsIndexingService connectionsIndexingService = this;
        synchronized (connectionsIndexingService) {
            for (Map.Entry<String, ConnectionMetadataState> e : this.volatileState.entrySet()) {
                if (e.getValue().currentJobId == null) continue;
                indexingJobsToAbort.add(e.getValue().currentJobId);
            }
        }
        logger.info((Object)("Abort all indexing: will abort jobs: " + JSON.log(indexingJobsToAbort)));
        for (String s : indexingJobsToAbort) {
            this.futureService.abort(s, liu);
        }
    }

    private synchronized void clearState(Collection<String> connections) {
        for (String connection : connections) {
            ConnectionMetadataState cs = this.volatileState.get(connection);
            if (cs == null) continue;
            cs.processingStep = null;
            cs.currentJobId = null;
        }
    }

    public IndexedAndUnindexed countIndexedAndUnindexed_NT(AuthCtx authCtx) throws Exception {
        IndexedAndUnindexed ret = new IndexedAndUnindexed();
        ret.possiblyUnscannedHive = HadoopLoader.hadoopEnabled();
        try (Transaction t = this.transactionService.beginRead();){
            Map allConnections = this.connectionsDAO.listUnsafe();
            Set scanned = this.dumpService.getScannedConnections();
            ret.indexedConnections = scanned.size();
            for (Map.Entry e : allConnections.entrySet()) {
                if (!(e.getValue() instanceof AbstractSQLConnection) && !(e.getValue() instanceof IcebergConnection) || scanned.contains(e.getKey())) continue;
                ++ret.unindexedButIndexableConnections;
            }
        }
        return ret;
    }

    public ListIndexableConnectionsResponse getIndexableConnections_NT(AuthCtx authCtx) throws Exception {
        ListIndexableConnectionsResponse ret = new ListIndexableConnectionsResponse();
        Set<String> hiveDatabases = null;
        try {
            hiveDatabases = this.getHiveDatabases_NT(authCtx);
        }
        catch (Throwable t) {
            logger.errorV(t, "Failed to list indexable Hive connections", new Object[0]);
            ret.messages.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_LIST_HIVE_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)t));
        }
        try (Transaction t = this.transactionService.beginRead();){
            Map allConnections = this.connectionsDAO.listUnsafe();
            Set scanned = this.dumpService.getScannedConnections();
            for (Map.Entry e : allConnections.entrySet()) {
                if (!(e.getValue() instanceof AbstractSQLConnection) && !(e.getValue() instanceof IcebergConnection)) continue;
                ret.scannableConnections.add((String)e.getKey());
                if (!scanned.contains(e.getKey())) continue;
                ret.indexableConnections.add((String)e.getKey());
            }
            if (hiveDatabases != null) {
                for (String hiveDB : hiveDatabases) {
                    String connName = "@virtual(hive-jdbc):" + hiveDB;
                    ret.scannableConnections.add(connName);
                    if (!scanned.contains(connName)) continue;
                    ret.indexableConnections.add(connName);
                }
            }
        }
        return ret;
    }

    public Set<String> getHiveDatabases_NT(AuthCtx authCtx) throws Exception {
        MetastoreInspectionService.MetastoreKind metastoreKind;
        HashSet<String> hiveConnections = new HashSet<String>();
        boolean usableHDFSConnectionsExists = false;
        try (Transaction t = this.transactionService.beginRead();){
            for (DSSConnection connection : this.connectionsDAO.listUnsafe().values()) {
                if (!connection.isFreelyUsableBy(authCtx) || !(connection instanceof HDFSConnection)) continue;
                usableHDFSConnectionsExists = true;
                break;
            }
        }
        if ((metastoreKind = this.metastoreInspectionService.getMetastoreKind(authCtx, null)) != null && usableHDFSConnectionsExists) {
            hiveConnections.addAll(this.metastoreInspectionService.newInspector(metastoreKind).listHiveDatabase(null, "default", authCtx, "__DKU_ANY_PROJECT__"));
        }
        return hiveConnections;
    }

    private static class ConnectionMetadataState {
        public transient ConnectionMetadataDAO.ConnectionProcessingStep processingStep;
        public transient String currentJobId;

        private ConnectionMetadataState() {
        }
    }

    private class IndexConnectionsThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final Collection<String> connections;

        IndexConnectionsThread(AuthCtx owner, Collection<String> connections) {
            super(owner, String.format("INDEX_CONNECTIONS_%s", Joiner.on((String)"|").join(connections)));
            this.connections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Indexing connections", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                try {
                    FutureProgress.updateState((double)0.0);
                    ConnectionsIndexingService connectionsIndexingService = ConnectionsIndexingService.this;
                    synchronized (connectionsIndexingService) {
                        for (String connection : this.connections) {
                            ConnectionMetadataState state = ConnectionsIndexingService.this.volatileState.get(connection);
                            if (state == null) {
                                state = new ConnectionMetadataState();
                                ConnectionsIndexingService.this.volatileState.put(connection, state);
                            }
                            state.currentJobId = this.jobId;
                            state.processingStep = ConnectionMetadataDAO.ConnectionProcessingStep.INDEX;
                        }
                    }
                    ret.mergeFrom(ConnectionsIndexingService.this.externalCatalogService.indexConnections(this.connections, new HashMap<String, InfoMessage.InfoMessages>()));
                    FutureProgress.updateState((double)1.0);
                }
                finally {
                    ConnectionsIndexingService.this.clearState(this.connections);
                }
            }
            return ret;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.displayName = "Index connections";
            return fp;
        }
    }

    private class ScanConnectionsThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final Collection<String> connections;
        private final AuthCtx user;

        ScanConnectionsThread(AuthCtx owner, Collection<String> connections) {
            super(owner, String.format("SCAN_CONNECTIONS_%s", Joiner.on((String)"|").join(connections)));
            this.connections = connections;
            this.user = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
            try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Indexing connections", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                FutureProgress.updateState((double)0.0);
                ConnectionsIndexingService connectionsIndexingService = ConnectionsIndexingService.this;
                synchronized (connectionsIndexingService) {
                    for (String connection : this.connections) {
                        ConnectionMetadataState state = ConnectionsIndexingService.this.volatileState.get(connection);
                        if (state == null) {
                            state = new ConnectionMetadataState();
                            ConnectionsIndexingService.this.volatileState.put(connection, state);
                        }
                        state.currentJobId = this.jobId;
                        state.processingStep = ConnectionMetadataDAO.ConnectionProcessingStep.SCAN;
                    }
                }
                Map messagesPerConnection = ConnectionsIndexingService.this.dumpService.scanConnectionsByName(this.connections, this.user);
                ConnectionsIndexingService.this.connectionMetadataService.saveMessages(messagesPerConnection);
                FutureProgress.updateState((double)1.0);
                ConnectionsIndexingService connectionsIndexingService2 = ConnectionsIndexingService.this;
                synchronized (connectionsIndexingService2) {
                    for (String connection : this.connections) {
                        ConnectionMetadataState cs = ConnectionsIndexingService.this.volatileState.get(connection);
                        assert (cs != null);
                        cs.processingStep = ConnectionMetadataDAO.ConnectionProcessingStep.INDEX;
                    }
                }
                result.mergeFrom(ConnectionsIndexingService.this.externalCatalogService.indexConnections((Collection<String>)Sets.intersection(new HashSet<String>(this.connections), (Set)ConnectionsIndexingService.this.dumpService.getScannedConnections()), messagesPerConnection));
            }
            finally {
                ConnectionsIndexingService.this.clearState(this.connections);
            }
            return result;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.displayName = "Scan and index connections : " + JSON.json(this.connections);
            return fp;
        }
    }

    @UIModel
    public static class IndexedAndUnindexed {
        public int indexedConnections;
        public int unindexedButIndexableConnections;
        public boolean possiblyUnscannedHive;
    }

    public static class ListIndexableConnectionsResponse {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public Set<String> scannableConnections = new HashSet<String>();
        public Set<String> indexableConnections = new HashSet<String>();
    }
}

