/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTransactionWriteExpression;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;

@SdkInternalApi
public class VersionAttributeConditionExpressionGenerator {
    private static final String VERSION_ATTRIBUTE_NAME_BASE_TOKEN = "#versionAttributeName";
    private static final String VERSION_ATTRIBUTE_VALUE_BASE_TOKEN = ":versionAttributeValue";
    private final DynamoDBTransactionWriteExpression versionAttributeConditionExpression = new DynamoDBTransactionWriteExpression();
    private Long versionAttributeCounterValue = 0L;

    public void appendVersionAttributeToConditionExpression(DynamoDBMapperFieldModel<Object, Object> field, Object fieldValue) {
        this.versionAttributeCounterValue = this.versionAttributeCounterValue + 1L;
        String versionAttributeNameToken = VERSION_ATTRIBUTE_NAME_BASE_TOKEN + this.versionAttributeCounterValue;
        String versionAttributeValueToken = VERSION_ATTRIBUTE_VALUE_BASE_TOKEN + this.versionAttributeCounterValue;
        HashMap<String, String> currentVersionedAttributeConditionExpressionNames = new HashMap<String, String>();
        currentVersionedAttributeConditionExpressionNames.put(versionAttributeNameToken, field.name());
        HashMap<String, AttributeValue> currentVersionedAttributeConditionExpressionValues = null;
        String currentVersionConditionExpression = null;
        if (fieldValue == null) {
            currentVersionConditionExpression = String.format("attribute_not_exists(%s)", versionAttributeNameToken);
        } else {
            currentVersionedAttributeConditionExpressionValues = new HashMap<String, AttributeValue>();
            currentVersionedAttributeConditionExpressionValues.put(versionAttributeValueToken, (AttributeValue)field.convert(fieldValue));
            currentVersionConditionExpression = String.format("attribute_exists(%s) AND %s = %s", versionAttributeNameToken, versionAttributeNameToken, versionAttributeValueToken);
        }
        if (this.versionAttributeConditionExpression.getConditionExpression() != null) {
            String currentConditionExpression = this.versionAttributeConditionExpression.getConditionExpression();
            if (this.versionAttributeCounterValue == 2L) {
                currentConditionExpression = "(" + currentConditionExpression + ")";
            }
            this.versionAttributeConditionExpression.withConditionExpression(currentConditionExpression + " AND (" + currentVersionConditionExpression + ")");
        } else {
            this.versionAttributeConditionExpression.withConditionExpression(currentVersionConditionExpression);
        }
        if (this.versionAttributeConditionExpression.getExpressionAttributeNames() != null) {
            this.versionAttributeConditionExpression.getExpressionAttributeNames().putAll(currentVersionedAttributeConditionExpressionNames);
        } else {
            this.versionAttributeConditionExpression.withExpressionAttributeNames(currentVersionedAttributeConditionExpressionNames);
        }
        if (currentVersionedAttributeConditionExpressionValues != null) {
            if (this.versionAttributeConditionExpression.getExpressionAttributeValues() != null) {
                this.versionAttributeConditionExpression.getExpressionAttributeValues().putAll(currentVersionedAttributeConditionExpressionValues);
            } else {
                this.versionAttributeConditionExpression.withExpressionAttributeValues(currentVersionedAttributeConditionExpressionValues);
            }
        }
    }

    public DynamoDBTransactionWriteExpression getVersionAttributeConditionExpression() {
        return this.versionAttributeConditionExpression;
    }
}

