/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.CleanRoomAsset;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.CleanRoomAssetAssetType;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.CleanRoomAssetsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.CleanRoomAssetsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.CreateCleanRoomAssetRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.DeleteCleanRoomAssetRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.GetCleanRoomAssetRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.ListCleanRoomAssetsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.ListCleanRoomAssetsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.cleanrooms.UpdateCleanRoomAssetRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CleanRoomAssetsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomAssetsAPI.class);
    private final CleanRoomAssetsService impl;

    public CleanRoomAssetsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomAssetsImpl(apiClient);
    }

    public CleanRoomAssetsAPI(CleanRoomAssetsService mock) {
        this.impl = mock;
    }

    public CleanRoomAsset create(String cleanRoomName) {
        return this.create(new CreateCleanRoomAssetRequest().setCleanRoomName(cleanRoomName));
    }

    public CleanRoomAsset create(CreateCleanRoomAssetRequest request) {
        return this.impl.create(request);
    }

    public void delete(String cleanRoomName, CleanRoomAssetAssetType assetType, String assetFullName) {
        this.delete(new DeleteCleanRoomAssetRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setAssetFullName(assetFullName));
    }

    public void delete(DeleteCleanRoomAssetRequest request) {
        this.impl.delete(request);
    }

    public CleanRoomAsset get(String cleanRoomName, CleanRoomAssetAssetType assetType, String assetFullName) {
        return this.get(new GetCleanRoomAssetRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setAssetFullName(assetFullName));
    }

    public CleanRoomAsset get(GetCleanRoomAssetRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CleanRoomAsset> list(String cleanRoomName) {
        return this.list(new ListCleanRoomAssetsRequest().setCleanRoomName(cleanRoomName));
    }

    public Iterable<CleanRoomAsset> list(ListCleanRoomAssetsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomAssetsResponse::getAssets, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoomAsset update(String cleanRoomName, CleanRoomAssetAssetType assetType, String name) {
        return this.update(new UpdateCleanRoomAssetRequest().setCleanRoomName(cleanRoomName).setAssetType(assetType).setName(name));
    }

    public CleanRoomAsset update(UpdateCleanRoomAssetRequest request) {
        return this.impl.update(request);
    }

    public CleanRoomAssetsService impl() {
        return this.impl;
    }
}

