/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.io.opencensus.contrib.http.util;

import com.dataiku.dss.shadelibdatabricks.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelibdatabricks.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.contrib.http.util.HttpViewConstants;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.stats.Stats;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.stats.View;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.stats.ViewManager;

public final class HttpViews {
    @VisibleForTesting
    static final ImmutableSet<View> HTTP_SERVER_VIEWS_SET = ImmutableSet.of(HttpViewConstants.HTTP_SERVER_COMPLETED_COUNT_VIEW, HttpViewConstants.HTTP_SERVER_SENT_BYTES_VIEW, HttpViewConstants.HTTP_SERVER_RECEIVED_BYTES_VIEW, HttpViewConstants.HTTP_SERVER_LATENCY_VIEW);
    @VisibleForTesting
    static final ImmutableSet<View> HTTP_CLIENT_VIEWS_SET = ImmutableSet.of(HttpViewConstants.HTTP_CLIENT_COMPLETED_COUNT_VIEW, HttpViewConstants.HTTP_CLIENT_RECEIVED_BYTES_VIEW, HttpViewConstants.HTTP_CLIENT_SENT_BYTES_VIEW, HttpViewConstants.HTTP_CLIENT_ROUNDTRIP_LATENCY_VIEW);

    private HttpViews() {
    }

    public static final void registerAllClientViews() {
        HttpViews.registerAllClientViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllClientViews(ViewManager viewManager) {
        for (View view : HTTP_CLIENT_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    public static final void registerAllServerViews() {
        HttpViews.registerAllServerViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllServerViews(ViewManager viewManager) {
        for (View view : HTTP_SERVER_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    public static final void registerAllViews() {
        HttpViews.registerAllViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllViews(ViewManager viewManager) {
        HttpViews.registerAllClientViews(viewManager);
        HttpViews.registerAllServerViews(viewManager);
    }
}

