/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonCreator;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonValue;

public enum TransportProtocol {
    JSONRPC("JSONRPC"),
    GRPC("GRPC"),
    HTTP_JSON("HTTP+JSON");

    private final String transport;

    private TransportProtocol(String transport) {
        this.transport = transport;
    }

    @JsonValue
    public String asString() {
        return this.transport;
    }

    @JsonCreator
    public static TransportProtocol fromString(String transport) {
        return switch (transport) {
            case "JSONRPC" -> JSONRPC;
            case "GRPC" -> GRPC;
            case "HTTP+JSON" -> HTTP_JSON;
            default -> throw new IllegalArgumentException("Invalid transport: " + transport);
        };
    }
}

