/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.jakarta.el;

import com.dataiku.dss.shadeliba2a.jakarta.el.ELClass;
import com.dataiku.dss.shadeliba2a.jakarta.el.ELContext;
import com.dataiku.dss.shadeliba2a.jakarta.el.ELResolver;
import com.dataiku.dss.shadeliba2a.jakarta.el.ELUtil;
import com.dataiku.dss.shadeliba2a.jakarta.el.PropertyNotFoundException;
import com.dataiku.dss.shadeliba2a.jakarta.el.PropertyNotWritableException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class StaticFieldELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            Class<?> klass = ((ELClass)base).getKlass();
            String fieldName = (String)property;
            try {
                context.setPropertyResolved(base, property);
                Field field = klass.getField(fieldName);
                int mod = field.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod)) {
                    return field.get(null);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "staticFieldReadError", new Object[]{klass.getName(), fieldName}));
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            Class<?> klass = ((ELClass)base).getKlass();
            String fieldName = (String)property;
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "staticFieldWriteError", new Object[]{klass.getName(), fieldName}));
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object methodName, Class<?>[] paramTypes, Object[] params) {
        Object ret;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!(base instanceof ELClass) || !(methodName instanceof String)) {
            return null;
        }
        Class<?> klass = ((ELClass)base).getKlass();
        String name = (String)methodName;
        if ("<init>".equals(name)) {
            Constructor<?> constructor = ELUtil.findConstructor(klass, paramTypes, params);
            ret = ELUtil.invokeConstructor(context, constructor, params);
        } else {
            Method method = ELUtil.findMethod(klass, base, name, paramTypes, params, true);
            ret = ELUtil.invokeMethod(context, method, null, params);
        }
        context.setPropertyResolved(base, methodName);
        return ret;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            Class<?> klass = ((ELClass)base).getKlass();
            String fieldName = (String)property;
            try {
                context.setPropertyResolved(true);
                Field field = klass.getField(fieldName);
                int mod = field.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod)) {
                    return null;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "staticFieldReadError", new Object[]{klass.getName(), fieldName}));
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ELClass && property instanceof String) {
            ((ELClass)base).getKlass();
            context.setPropertyResolved(true);
        }
        return true;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

