/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.krb;

import com.dataiku.common.krb.Krb5KeytabLoginContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Krb5KeytabLoginContextCache {
    private static final Krb5KeytabLoginContextCache INSTANCE = new Krb5KeytabLoginContextCache();
    private Cache<String, Krb5KeytabLoginContext> contexts = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new Krb5KeytabLoginContextCloser()).build();
    private static Logger logger = Logger.getLogger((String)"dip.krb.login.cache");

    private Krb5KeytabLoginContextCache() {
        Timer cacheExpirationTimer = new Timer("Kerberos logins cache timer", true);
        long delay = 300000L;
        cacheExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info((Object)("Perform routine cleanup on Kerberos logins cache (" + Krb5KeytabLoginContextCache.this.contexts.size() + " logins active)"));
                Krb5KeytabLoginContextCache.this.contexts.cleanUp();
            }
        }, delay, delay);
    }

    private static String makeKey(String principal, String keytab) {
        return StringUtils.defaultIfBlank((String)principal, (String)"") + "/" + StringUtils.defaultIfBlank((String)keytab, (String)"");
    }

    public static Krb5KeytabLoginContext get(final String principal, final String keytab) throws Exception {
        return (Krb5KeytabLoginContext)Krb5KeytabLoginContextCache.INSTANCE.contexts.get((Object)Krb5KeytabLoginContextCache.makeKey(principal, keytab), (Callable)new Callable<Krb5KeytabLoginContext>(){

            @Override
            public Krb5KeytabLoginContext call() throws Exception {
                return new Krb5KeytabLoginContext(principal, keytab);
            }
        });
    }

    private class Krb5KeytabLoginContextCloser
    implements RemovalListener<String, Krb5KeytabLoginContext> {
        private Krb5KeytabLoginContextCloser() {
        }

        public void onRemoval(RemovalNotification<String, Krb5KeytabLoginContext> removed) {
            Krb5KeytabLoginContext context = (Krb5KeytabLoginContext)removed.getValue();
            try {
                context.close();
            }
            catch (LoginException e) {
                logger.warn((Object)"Failed to logout from kerberos", (Throwable)e);
            }
        }
    }
}

