/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewsDAO;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FileBasedAgentReviewsDAO
extends AbstractStandardDAO<AgentReview>
implements AgentReviewsDAO {
    @Override
    protected AgentReview getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        AgentReview lt = unsafe ? (AgentReview)tr.readObjectUnsafe(rf, AgentReview.class) : (AgentReview)tr.readObject(rf, AgentReview.class);
        lt.id = id;
        lt.projectKey = projectKey;
        return lt;
    }

    @Override
    protected List<AgentReview> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile agentReviewFolder = this.agentReviewsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<AgentReview> ret = new ArrayList<AgentReview>();
        if (tr.isDirectory(agentReviewFolder)) {
            for (RelFile f : tr.listFiles(agentReviewFolder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    AgentReview task = (AgentReview)this.getMandatory(projectKey, id, unsafe);
                    ret.add(task);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to agent review file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Agent review id is not specified");
        return new RelFile(this.agentReviewsFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.AGENT_REVIEW.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile agentReviewFile = this.getDAOFile(projectKey, id);
        t.deleteFile(agentReviewFile);
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile agentReviewsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(agentReviewsFolder = this.agentReviewsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(agentReviewsFolder).size();
    }

    private RelFile agentReviewsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key cannot be blank");
        return new RelFile(new String[]{"projects", projectKey, "agent_reviews"});
    }
}

