/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.agents.tools.utils.JsonSchemaElement;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.integrations.IntegrationDirectUseEvent;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.shaker.processors.typespecific.JSONPathExtractor;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.JSONRedactor;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ReporterAgentTool {
    public static final AgentToolMeta META = new AgentToolMeta(true){

        @Override
        public String getType() {
            return "DataikuReporter";
        }

        @Override
        public Class<? extends AgentToolParams> paramsClass() {
            return Params.class;
        }

        @Override
        public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) {
            Params p = tool.getParamsCopyAs(Params.class);
            return new ArrayList<SavedModel.AgentDependency>();
        }

        private String integrationTypeDescription(String integrationType) {
            if ("slack-direct".equals(integrationType)) {
                return "Slack";
            }
            if ("mail-direct".equals(integrationType)) {
                return "email";
            }
            if ("msft-teams-direct".equals(integrationType)) {
                return "Microsoft Teams";
            }
            return integrationType;
        }

        @Override
        public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) {
            TransactionContext.assertNoAttachedTransaction();
            Params p = tool.getParamsCopyAs(Params.class);
            AgentToolMeta.ToolDescriptor td = new AgentToolMeta.ToolDescriptor(tool.name);
            if (p.integration.type == null) {
                td.description = "Sends a message (error: no integration type selected).";
                return td;
            }
            td.description = "Sends a message through " + this.integrationTypeDescription(p.integration.type) + "\n\n";
            td.description = td.description + "Provide the inputs required to generate and send the message.\n";
            if (StringUtils.isNotBlank((String)tool.additionalDescriptionForLLM)) {
                td.description = td.description + "\n\n" + tool.additionalDescriptionForLLM;
            }
            td.inputSchema = JsonSchema.newObject("https://dataiku.com/agents/tools/reporters/send", "Send a message through " + this.integrationTypeDescription(p.integration.type));
            JsonSchemaElement parameters = JsonSchemaElement.object("Parameters");
            for (Params.ToolVariable variable : p.variables) {
                if (variable.sourceType != Params.ToolVariableSource.TOOL_INPUT) continue;
                parameters.properties.put(variable.id, JsonSchemaElement.string(variable.toolInputDescription));
            }
            td.inputSchema.properties.put("parameters", parameters);
            return td;
        }

        @Override
        public AgentToolMeta.ToolCallDescription getToolCallDescription_NT(AuthCtx authCtx, String projectKey, AgentTool tool, LLMClient.FunctionTool descriptor, AgentToolRunner.AgentToolInput input) {
            TransactionContext.assertNoAttachedTransaction();
            Params p = tool.getParamsCopyAs(Params.class);
            Object description = String.format("I'm about to send the following message through %s with the following parameters.%n", this.integrationTypeDescription(p.integration.type));
            description = (String)description + "\n";
            description = (String)description + "Do you want to proceed?";
            return new AgentToolMeta.ToolCallDescription((String)description);
        }

        @Override
        public JsonObject loadSampleQuery(AuthCtx authCtx, String projectKey, AgentTool tool) {
            Params p = tool.getParamsCopyAs(Params.class);
            if (p.integration.type == null) {
                throw new IllegalArgumentException("No integration type selected.");
            }
            JsonObject parameters = new JsonObject();
            for (Params.ToolVariable variable : p.variables) {
                if (variable.sourceType != Params.ToolVariableSource.TOOL_INPUT) continue;
                parameters.addProperty(variable.id, variable.toolInputDescription);
            }
            JsonObject sampleInput = new JsonObject();
            sampleInput.add("parameters", (JsonElement)parameters);
            return sampleInput;
        }

        @Override
        public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws CodedException {
            return new Runner(authCtx, projectKey, tool.getParamsCopyAs(Params.class));
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.report");

    public static class Runner
    implements AgentToolRunner {
        private final Params params;
        private final String projectKey;
        private final AuthCtx authCtx;

        public Runner(AuthCtx authCtx, String projectKey, Params p) {
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.params = p;
        }

        @Override
        public void init() throws IOException {
            SpringUtils.getInstance().autowire((Object)this);
        }

        @Override
        public AgentToolRunner.AgentToolOutput run(AgentToolRunner.AgentToolInput input) throws Exception {
            if (logger.isDebugEnabled()) {
                JsonObject loggableInput = JSONRedactor.redactObject((Object)input, (JSONRedactor.RedactionConfig)LLMClient.inputRedactionConfig());
                logger.debug((Object)("Reporter tool reporting with input " + JSON.log((Object)loggableInput)));
            }
            IntegrationDirectUseEvent idue = new IntegrationDirectUseEvent();
            idue.projectKey = this.projectKey;
            VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProjectAndUserLogin(this.projectKey, this.authCtx);
            idue.lookup = new VariableLookup();
            if (this.safeHasArgument(input, "message")) {
                idue.lookup.addVariable("message", this.safeReadStringArgument(input, "message"));
            }
            JsonObject parameters = this.safeHasArgument(input, "parameters") ? this.safeReadObjectArgument(input, "parameters") : null;
            Schema schema = new Schema();
            MemTable table = new MemTable();
            MemRow row = new MemRow(table);
            Runner.addColumnToFormulaContext(schema, table, row, "context", Type.STRING, input.context.toString());
            for (Params.ToolVariable variable : this.params.variables) {
                String resolvedValue = null;
                if (variable.sourceType == Params.ToolVariableSource.TOOL_INPUT && parameters != null) {
                    JsonElement value = parameters.get(variable.id);
                    if (value != null) {
                        resolvedValue = value.getAsString();
                    }
                } else if (variable.sourceType == Params.ToolVariableSource.QUERY_CONTEXT) {
                    Object out;
                    JsonPath compiled = JsonPath.compile((String)variable.contextPath, (Predicate[])new Predicate[0]);
                    ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().mappingProvider((MappingProvider)new JsonSmartMappingProvider()).jsonProvider((JsonProvider)new JsonSmartJsonProvider()).build());
                    if (input.context != null && (out = parseContext.parse(input.context.toString()).read(compiled)) != null) {
                        resolvedValue = JSONPathExtractor.printJSONValue(out);
                    }
                } else if (variable.sourceType == Params.ToolVariableSource.FORMULA) {
                    Expression expression = new Expression(vc.expandAllowUnresolved(variable.expression), schema);
                    expression.setColumnFactory(table);
                    expression.setVariablesContext(vc);
                    Object evaluate = expression.evaluate(row);
                    if (evaluate != null) {
                        resolvedValue = evaluate.toString();
                    }
                } else if (variable.sourceType == Params.ToolVariableSource.DSS_VARIABLE && !Strings.isNullOrEmpty((String)variable.dssVariableName)) {
                    resolvedValue = vc.getAsString("${" + variable.dssVariableName + "}");
                }
                if (resolvedValue == null) continue;
                idue.lookup.addVariable(variable.id, resolvedValue);
                Runner.addColumnToFormulaContext(schema, table, row, variable.id, Type.STRING, resolvedValue);
            }
            IntegrationHooksRegistry.buildSender(this.authCtx, this.params.integration, new IntegrationMeta.PermissionCheckContext(true)).handleEvent(idue, new InfoMessage.InfoMessages());
            logger.debug((Object)"Reporter tool done");
            AgentToolRunner.AgentToolOutput ret = new AgentToolRunner.AgentToolOutput();
            ret.output = JF.obj().with("status", "ok").get();
            return ret;
        }

        private static void addColumnToFormulaContext(Schema schema, MemTable table, MemRow row, String columnName, Type columnType, Object value) {
            schema.addColumn(new SchemaColumn(columnName, columnType));
            MemColumn column = table.column(columnName);
            if (columnType.isInteger() && value instanceof Integer) {
                row.put((Column)column, (Integer)value);
            } else if (columnType.isInteger() && value instanceof Long) {
                row.put((Column)column, (Long)value);
            } else if (columnType.isFloatingPoint() && value instanceof Float) {
                row.put((Column)column, ((Float)value).floatValue());
            } else if (columnType.isFloatingPoint() && value instanceof Double) {
                row.put((Column)column, (Double)value);
            } else if (columnType == Type.BOOLEAN && value instanceof Boolean) {
                row.put((Column)column, (Boolean)value);
            } else {
                row.put((Column)column, value.toString());
            }
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static class Params
    implements AgentToolParams {
        public IntegrationHook integration = new IntegrationHook();
        public List<ToolVariable> variables = new ArrayList<ToolVariable>();

        public Params() {
            ToolVariable defaultPlaceholder = new ToolVariable();
            defaultPlaceholder.id = "message";
            defaultPlaceholder.sourceType = ToolVariableSource.TOOL_INPUT;
            defaultPlaceholder.toolInputDescription = "The message to send";
            this.variables.add(defaultPlaceholder);
        }

        public static class ToolVariable {
            public String id;
            public ToolVariableSource sourceType;
            public String toolInputDescription;
            public String contextPath;
            public String expression;
            public String dssVariableName;
        }

        public static enum ToolVariableSource {
            TOOL_INPUT,
            QUERY_CONTEXT,
            FORMULA,
            DSS_VARIABLE;

        }
    }
}

