/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aiexplanations.chart;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIChartExplanationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AIChartExplanationService.class);

    public FutureResponse<AIExplainChartFrontendResponse> startExplain(DSSAuthCtx authCtx, JsonObject data) throws Exception {
        AIExplainChartBackendQuery query = new AIExplainChartBackendQuery();
        query.data = data;
        AIExplainChartFutureThread futureThread = new AIExplainChartFutureThread(authCtx, query);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIExplainChartFrontendResponse>>(){});
    }

    public static class AIExplainChartBackendQuery {
        String licenseId;
        JsonObject data;
        boolean telemetryEnabled;
    }

    private class AIExplainChartFutureThread
    extends SimpleFutureThread<AIExplainChartFrontendResponse> {
        private final AIExplainChartBackendQuery query;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public AIExplainChartFutureThread(DSSAuthCtx owner, AIExplainChartBackendQuery query) {
            super((AuthCtx)owner);
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.query = query;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_explain_chart", (String)"AI Explain Chart");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AIExplainChartFrontendResponse compute() throws Exception {
            NDC.push((String)("ai-explainchart: " + this.query.data.toString()));
            try {
                AIExplainChartFrontendResponse aIExplainChartFrontendResponse;
                block17: {
                    if (!(this.generalSettings.aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.STORIES_ASSISTANT) && this.generalSettings.aiDrivenAnalyticsSettings.sendSampleValues && this.generalSettings.dataikuStoriesSettings.enabled)) {
                        throw new IllegalStateException("Stories AI Explain Chart is not enabled");
                    }
                    LicenseStatusService.LicensingStatus ls = AIChartExplanationService.this.licenseStatusService.getLicensingStatus();
                    if (ls.community) {
                        throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
                    }
                    this.query.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
                    this.query.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
                    InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                    try {
                        AIExplainChartBackendResponse resp = (AIExplainChartBackendResponse)apiClient.postObject("/explain-stuff/explain-chart", AIExplainChartBackendResponse.class, (Object)this.query);
                        logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                        AIExplainChartFrontendResponse finalResp = new AIExplainChartFrontendResponse();
                        finalResp.requestId = resp.request_id;
                        if (!resp.ok) {
                            logger.warn((Object)"AI was not able to explain that chart");
                            finalResp.reason = "AI was not able to explain that chart";
                            if (resp.error != null) {
                                finalResp.reason = finalResp.reason + ": " + resp.error;
                            }
                            finalResp.ok = false;
                        } else {
                            finalResp.ok = true;
                            finalResp.insights = resp.insights;
                        }
                        aIExplainChartFrontendResponse = finalResp;
                        if (apiClient == null) break block17;
                    }
                    catch (Throwable resp) {
                        try {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable throwable) {
                                    resp.addSuppressed(throwable);
                                }
                            }
                            throw resp;
                        }
                        catch (IOException e) {
                            logger.error((Object)"IO exception while getting AI explain chart", (Throwable)e);
                            AIExplainChartFrontendResponse finalResp = new AIExplainChartFrontendResponse();
                            finalResp.ok = false;
                            finalResp.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                            AIExplainChartFrontendResponse aIExplainChartFrontendResponse2 = finalResp;
                            NDC.pop();
                            return aIExplainChartFrontendResponse2;
                        }
                    }
                    apiClient.close();
                }
                return aIExplainChartFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class AIExplainChartFrontendResponse {
        boolean ok;
        String reason;
        String insights;
        String requestId;
    }

    public static class AIExplainChartBackendResponse {
        boolean ok;
        String error;
        String insights;
        String request_id;
    }
}

