/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.semanticsearch.ItemFacets;
import com.dataiku.dip.semanticsearch.ItemMetadata;
import com.dataiku.dip.semanticsearch.SemanticSearchService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.common.base.Stopwatch;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AISemanticSearchResultRerankingService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AISemanticSearchResultRerankingService.class);

    public RerankResultsResponse rerankResults(AuthCtx user, String userQuery, List<ItemMetadata.DatasetMetadata> datasetsMetadata, List<ItemMetadata.IndexedTableMetadata> indexedTableMetadata, String conversationId) throws Exception {
        LicenseStatusService.LicensingStatus licensingStatus = this.licenseStatusService.getLicensingStatus();
        SemanticSearchService.checkAllowedToUse(licensingStatus);
        RerankResultsFutureThread futureThread = new RerankResultsFutureThread(user, licensingStatus, userQuery, datasetsMetadata, indexedTableMetadata, conversationId);
        return (RerankResultsResponse)this.futureService.runAndWait(futureThread, (TypeToken)new TypeToken<FutureResponse<RerankResultsResponse>>(){});
    }

    private static class RerankResultsFutureThread
    extends SimpleFutureThread<RerankResultsResponse> {
        private final LicenseStatusService.LicensingStatus licensingStatus;
        private final GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;
        private final String userQuery;
        private final List<ItemMetadata.DatasetMetadata> datasetsMetadata;
        private final List<ItemMetadata.IndexedTableMetadata> indexedTableMetadata;
        private final String conversationId;

        public RerankResultsFutureThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String userQuery, List<ItemMetadata.DatasetMetadata> datasetsMetadata, List<ItemMetadata.IndexedTableMetadata> indexedTableMetadata, String conversationId) {
            super(owner);
            this.licensingStatus = licensingStatus;
            this.aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.userQuery = userQuery;
            this.datasetsMetadata = datasetsMetadata;
            this.indexedTableMetadata = indexedTableMetadata;
            this.conversationId = conversationId;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_semantic_search_rerank_results", (String)"AI Search rerank results");
        }

        @Override
        protected RerankResultsResponse compute() {
            NDC.push((String)"ai-semantic-search-rerank-results");
            Stopwatch stopwatch = Stopwatch.createStarted();
            logger.infoV("Starting reranking for ConvId: [%s]. Candidates - Datasets: [%d], Tables: [%d]", new Object[]{this.conversationId, this.datasetsMetadata.size(), this.indexedTableMetadata.size()});
            String effectiveUserQuery = this.userQuery;
            if (effectiveUserQuery != null && effectiveUserQuery.length() > AIFeaturesUtil.SEMANTIC_SEARCH_MAX_QUERY_CHARS) {
                logger.infoV("Truncating user query for ConvId: [%s] (Length: %d > Max: %d)", new Object[]{this.conversationId, effectiveUserQuery.length(), AIFeaturesUtil.SEMANTIC_SEARCH_MAX_QUERY_CHARS});
                effectiveUserQuery = effectiveUserQuery.substring(0, AIFeaturesUtil.SEMANTIC_SEARCH_MAX_QUERY_CHARS);
            }
            RerankResultsRequest request = new RerankResultsRequest(this.licensingStatus != null && this.licensingStatus.licenseContent != null ? this.licensingStatus.licenseContent.licenseId : null, this.aiDrivenAnalyticsSettings.telemetryEnabled, effectiveUserQuery, this.datasetsMetadata, this.indexedTableMetadata, this.conversationId);
            try {
                RerankResultsResponse rerankResultsResponse;
                block16: {
                    InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT * 4, AIFeaturesUtil.SOCKET_TIMEOUT * 4);
                    try {
                        RerankResultsResponse response = (RerankResultsResponse)apiClient.postObject("/semantic-search/rerank-results", RerankResultsResponse.class, (Object)request);
                        if (response != null && response.ok) {
                            logger.infoV("Reranking successful for ConvId: [%s]. Reranked results returned: [%d]. AI-server call took %d milliseconds", new Object[]{this.conversationId, response.results == null ? 0 : response.results.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                        } else {
                            String error = response == null ? "Null response" : response.error;
                            logger.errorV("AI Server reranking returned error for ConvId: [%s]. Error: %s. AI-server call took %d milliseconds", new Object[]{this.conversationId, error, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                        }
                        rerankResultsResponse = response;
                        if (apiClient == null) break block16;
                    }
                    catch (Throwable response) {
                        try {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable throwable) {
                                    response.addSuppressed(throwable);
                                }
                            }
                            throw response;
                        }
                        catch (APIError.APIErrorException e) {
                            RerankResultsResponse response2 = new RerankResultsResponse();
                            response2.ok = false;
                            response2.error = "Failed to rerank AI Search results: " + e.getMessage();
                            logger.errorV("AI Server reranking returned error for ConvId: [%s]. Error: %s. AI-server call took %d milliseconds", new Object[]{this.conversationId, e.getMessage(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                            RerankResultsResponse rerankResultsResponse2 = response2;
                            return rerankResultsResponse2;
                        }
                        catch (DKUSecurityException | IOException e) {
                            throw new RuntimeException("Failed to rerank AI Search results", e);
                        }
                    }
                    apiClient.close();
                }
                return rerankResultsResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class RerankResultsResponse {
        public boolean ok;
        public String error;
        public List<ExplanationSection> explanationSections;
        public List<RerankedResult> results = List.of();
    }

    public static class ExplanationSection {
        @Nullable
        String title;
        List<String> content;
    }

    public static class RerankedDatasetResult
    extends RerankedResult {
        public static final String TYPE = "dataset";
        public String datasetName;
        public String projectKey;
        public ItemFacets itemFacets;
    }

    public static class RerankedTableResult
    extends RerankedResult {
        public static final String TYPE = "table";
        public String tableId;
        public LuceneResponseWrapper.Hit hit;
    }

    @PolyJSON(value={@Mapping(value=RerankedDatasetResult.class, type="dataset"), @Mapping(value=RerankedTableResult.class, type="table")})
    public static abstract class RerankedResult {
        public String usage;
        public String summary;
        public int newRank;
        public int oldRank;
        public boolean isRelevant;
        public float relevanceScore;
        public String relevance;
    }

    private record RerankResultsRequest(String licenseId, boolean telemetryEnabled, String userQuery, List<ItemMetadata.DatasetMetadata> datasetsMetadata, List<ItemMetadata.IndexedTableMetadata> indexedTableMetadata, String conversationId) {
    }
}

