/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.ISplitsStatusService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.MLTaskCodeEnvCompatibilityComputer;
import com.dataiku.dip.analysis.coreservices.TrainingSessionDetailsService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.MLTaskHandler;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.prediction.CausalPredictionMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.ClassicalPredictionMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.DeephubMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.EnsembleHandler;
import com.dataiku.dip.analysis.ml.prediction.MLLibClassicalPredictionMLTaskHandler;
import com.dataiku.dip.analysis.ml.prediction.MLSchemaComparator;
import com.dataiku.dip.analysis.ml.prediction.PartitionedExtractService;
import com.dataiku.dip.analysis.ml.prediction.PredictionMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.PredictionPostComputationHandler;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.PythonPredictionMLTaskHandler;
import com.dataiku.dip.analysis.ml.prediction.StratifiedPythonPredictionMLTaskHandler;
import com.dataiku.dip.analysis.ml.prediction.TabularPredictionParamsExpander;
import com.dataiku.dip.analysis.ml.prediction.TimeseriesForecastingMLTaskHandlingStrategy;
import com.dataiku.dip.analysis.ml.prediction.guess.CausalPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.ClassicalPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.OutcomeStats;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuessPolicy;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.TabularPredictionGuesser;
import com.dataiku.dip.analysis.ml.prediction.guess.TimeseriesForecastingGuesser;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.AnalysisRetrainWorkSetPreparator;
import com.dataiku.dip.analysis.ml.shared.AnalysisWorkSetPreparator;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.ml.shared.FeatureGuessUtils;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.BaseCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedPreprocessingParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.CausalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.DeepHubPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.EnsembleParams;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainStatus;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTaskStatus;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedDeepHubPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeOrderingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesPredictionPermutationImportance;
import com.dataiku.dip.analysis.model.prediction.TimeseriesResiduals;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.dataiku.dip.analysis.model.prediction.WeightParams;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.ImageFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TabularPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.VectorFeaturePreprocessingParams;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.distributed.metrics.ContainerUsageMetrics;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PredictionService {
    @Autowired
    private ISplitsStatusService splitsService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private AnalysisCRUDService crudService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private SavedModelsCRUDService smCRUDService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private PartitionedExtractService partitionedExtractService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TrainingSessionDetailsService trainingSessionDetailsService;
    @Autowired
    private DSSInternalCodeEnvsService dssInternalCodeEnvsService;
    @Autowired
    private CodeEnvPermissionsService codeEnvPermissionsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.prediction");

    private void saveReguessed_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask taskBefore, PredictionMLTask task) throws UnauthorizedException, IOException {
        logger.trace(() -> "Before reguess\n " + JSON.prettyLog((Object)taskBefore));
        logger.trace(() -> "After reguess\n " + JSON.prettyLog((Object)task));
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Reguessed prediction task settings for " + cp.getFullId() + " (" + cp.name + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask reguess_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task) throws Exception {
        PredictionMLTask taskBefore = (PredictionMLTask)JSON.deepCopy((Object)task);
        logger.info((Object)"Start reguess all settings");
        this.mlBaseService.addGuessing(loc);
        try {
            PredictionGuesser<? extends PredictionMLTask> guesser = this.getGuesser(cp, task, user);
            guesser.guessAllSettings(false);
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask reguessWithTarget_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, String targetVariable, boolean redetect) throws Exception {
        if (task.targetVariable.equals(targetVariable)) {
            throw new IllegalArgumentException("Target variable did not change");
        }
        PredictionMLTask taskBefore = (PredictionMLTask)JSON.deepCopy((Object)task);
        task.targetVariable = targetVariable;
        logger.infoV("Start reguess with target variable %s (redetect all settings: %s)", new Object[]{targetVariable, redetect});
        this.mlBaseService.addGuessing(loc);
        try {
            PredictionGuesser<? extends PredictionMLTask> guesser = this.getGuesser(cp, task, user);
            if (redetect) {
                guesser.guessAllSettings(true);
            } else {
                guesser.changeTargetNoReguess(taskBefore.targetVariable, loc.getGuessStatus());
            }
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimeseriesIdentifiers_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask.TimeseriesForecastingMLTask task, List<String> timeseriesIdentifiers, boolean redetect) throws Exception {
        if (CollectionUtils.isEqualCollection(timeseriesIdentifiers, task.timeseriesIdentifiers)) {
            throw new IllegalArgumentException("Time series identifiers did not change");
        }
        PredictionMLTask.TimeseriesForecastingMLTask taskBefore = (PredictionMLTask.TimeseriesForecastingMLTask)JSON.deepCopy((Object)task);
        task.timeseriesIdentifiers = timeseriesIdentifiers;
        logger.infoV("Start reguess with time series identifiers %s (redetect all settings: %s)", new Object[]{timeseriesIdentifiers, redetect});
        this.mlBaseService.addGuessing(loc);
        try {
            TimeseriesForecastingGuesser guesser = (TimeseriesForecastingGuesser)this.getGuesser(cp, task, user);
            if (redetect) {
                guesser.guessAllSettings(true);
            } else {
                guesser.changeTimeseriesIdentifiersNoReguess(taskBefore.timeseriesIdentifiers, loc.getGuessStatus());
            }
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimeVariable_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask.TimeseriesForecastingMLTask task, String timeVariable, boolean redetect) throws Exception {
        if (timeVariable.equals(task.timeVariable)) {
            throw new IllegalArgumentException("Time variable did not change");
        }
        PredictionMLTask.TimeseriesForecastingMLTask taskBefore = (PredictionMLTask.TimeseriesForecastingMLTask)JSON.deepCopy((Object)task);
        task.timeVariable = timeVariable;
        logger.infoV("Start reguess with time variable %s (redetect all settings: %s)", new Object[]{timeVariable, redetect});
        this.mlBaseService.addGuessing(loc);
        try {
            TimeseriesForecastingGuesser guesser = (TimeseriesForecastingGuesser)this.getGuesser(cp, task, user);
            if (redetect) {
                guesser.guessAllSettings(true);
            } else {
                guesser.changeTimeVariableNoReguess(taskBefore.timeVariable, loc.getGuessStatus());
            }
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask.CausalPredictionMLTask reguessWithTreatmentVariable_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask.CausalPredictionMLTask task, String treatmentVariable, boolean redetect) throws Exception {
        if (treatmentVariable.equals(task.treatmentVariable)) {
            throw new IllegalArgumentException("Treatment variable did not change");
        }
        PredictionMLTask.CausalPredictionMLTask taskBefore = (PredictionMLTask.CausalPredictionMLTask)JSON.deepCopy((Object)task);
        task.treatmentVariable = treatmentVariable;
        logger.infoV("Start reguess with treatment variable %s (redetect all settings: %s)", new Object[]{treatmentVariable, redetect});
        this.mlBaseService.addGuessing(loc);
        try {
            CausalPredictionGuesser guesser = (CausalPredictionGuesser)this.getGuesser(cp, task, user);
            if (redetect) {
                guesser.guessAllSettings(true);
            } else {
                guesser.changeTreatmentNoReguess(taskBefore.treatmentVariable, loc.getGuessStatus());
            }
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask reguessWithType_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, PredictionMLTask.PredictionType newType, boolean redetect) throws Exception {
        if (newType.equals((Object)task.predictionType)) {
            throw new IllegalArgumentException("Prediction type did not change");
        }
        PredictionMLTask taskBefore = (PredictionMLTask)JSON.deepCopy((Object)task);
        logger.infoV("Start reguess with prediction type %s (redetect all settings: %s)", new Object[]{newType, redetect});
        this.mlBaseService.addGuessing(loc);
        try {
            PredictionGuesser<? extends PredictionMLTask> guesser = this.getGuesser(cp, task, user);
            if (!guesser.canChangePredictionType()) {
                throw new UnsupportedOperationException("Cannot reguess with prediction type for MLTask: " + task.getClass().getSimpleName());
            }
            if (redetect) {
                guesser.guessAllSettings(newType, true);
            } else {
                task.setPredictionType(newType);
                guesser.changeTypeNoReguess(taskBefore.predictionType, loc.getGuessStatus());
            }
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimestepParams_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask.TimeseriesForecastingMLTask task, @Nullable TimestepParams timestepParams, @Nullable Long predictionLength, boolean reguessAlgoAndAlignmentsParams, @Nullable Long validationHorizons) throws Exception {
        boolean predictionLengthUpdated;
        boolean timestepParamsUpdated = null != timestepParams;
        boolean bl = predictionLengthUpdated = null != predictionLength;
        if (!timestepParamsUpdated && !predictionLengthUpdated) {
            logger.info((Object)"Skipping setting of forecasting parameters: neither time step parameters nor forecasting horizon were specified.");
            return task;
        }
        PredictionMLTask.TimeseriesForecastingMLTask taskBefore = (PredictionMLTask.TimeseriesForecastingMLTask)JSON.deepCopy((Object)task);
        if (timestepParamsUpdated) {
            task.timestepParams = timestepParams;
        }
        Long previousPredictionLength = task.predictionLength;
        if (predictionLengthUpdated) {
            task.predictionLength = predictionLength;
        }
        logger.infoV("Start reguess of algorithm params related to time step parameters (%s) and forecast horizon (%s)(reguess algo params: %s)", new Object[]{timestepParams, predictionLength, reguessAlgoAndAlignmentsParams});
        this.mlBaseService.addGuessing(loc);
        try {
            TimeseriesForecastingGuesser guesser = (TimeseriesForecastingGuesser)this.getGuesser(cp, task, user);
            guesser.changeTimestepParamsLimitedReguess(timestepParamsUpdated, predictionLengthUpdated, reguessAlgoAndAlignmentsParams, loc.getGuessStatus(), previousPredictionLength, validationHorizons);
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        this.saveReguessed_NT(user, cp, loc, taskBefore, task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeGuessPolicy(AuthCtx user, AnalysisCoreParams acp, MLTaskLoc loc, PredictionMLTask.TabularPredictionMLTask task, PredictionGuessPolicy guessPolicy) throws Exception {
        logger.info((Object)"Start changing prediction task guess policy");
        PredictionMLTask taskBefore = (PredictionMLTask)JSON.deepCopy((Object)task);
        task.guessPolicy = guessPolicy;
        this.mlBaseService.addGuessing(loc);
        try {
            TabularPredictionGuesser guesser = (TabularPredictionGuesser)this.getGuesser(acp, task, user);
            guesser.reguessAlgorithms();
            loc.writeGuessStatus(guesser.checkStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
        logger.trace(() -> "Before changing policy\n " + JSON.prettyLog((Object)taskBefore));
        logger.trace(() -> "After changing policy\n " + JSON.prettyLog((Object)task));
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Changed prediction task guess policy for " + acp.projectKey + "." + acp.id + " (" + acp.name + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDuplicate(AnalysisCoreParams acp, AuthCtx user, MLTaskLoc loc, PredictionMLTask task, String newTarget) throws Exception {
        this.mlBaseService.addGuessing(loc);
        try {
            boolean bl = this.getGuesser(acp, task, user).isTargetPresent(StringUtils.isBlank((String)newTarget) ? task.targetVariable : newTarget);
            return bl;
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duplicate(AnalysisCoreParams acp, AuthCtx user, MLTaskLoc loc, PredictionMLTask task, String newTarget, PartitioningScheme partitioningFrom, PartitioningScheme partitioningTo, List<Partition> partitionsTo) throws Exception {
        this.mlBaseService.addGuessing(loc);
        try {
            MLTaskLoc newLoc;
            PredictionGuesser<? extends PredictionMLTask> guesser = this.getGuesser(acp, task, user);
            if (!StringUtils.isBlank((String)newTarget)) {
                task.targetVariable = newTarget;
                guesser.changeTargetNoReguess(null, loc.getGuessStatus());
            } else if (task instanceof PredictionMLTask.ClassicalPredictionMLTask) {
                ((PredictionMLTask.ClassicalPredictionMLTask)task).assertionsParams = new MLAssertionsParams();
            }
            task.id = SecretKeyGenerator.generate((int)8);
            task.name = this.newTaskName(acp, (String)(StringUtils.isBlank((String)newTarget) ? task.name : "Predict " + newTarget));
            task.initiator = user.getIdentifier();
            guesser.fixupAfterDuplication();
            if (task.isPartitioned()) {
                this.fixPartitioningForDuplication((PredictionMLTask.TabularPredictionMLTask)task, partitioningTo, partitioningFrom, partitionsTo);
            }
            try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
                newLoc = new MLTaskLoc(acp.projectKey, acp.id, task.id);
                this.crudService.prepareMLTaskCreation(newLoc, task, user);
                this.crudService.saveMLTask(newLoc, task, true);
                rw.commit("Duplicate task " + loc.analysisId + "." + loc.mlTaskId + " into " + acp.id + "." + task.id);
            }
            newLoc.writeGuessStatus(loc.getGuessStatus());
        }
        finally {
            this.mlBaseService.removeGuessing(loc);
        }
    }

    private void fixPartitioningForDuplication(PredictionMLTask.TabularPredictionMLTask task, PartitioningScheme partitioningTo, PartitioningScheme partitioningFrom, List<Partition> partitionsTo) {
        if (!partitioningTo.isPartitioned() || !partitioningFrom.equals((Object)partitioningTo)) {
            task.partitionedModel = new PartitionedModelParams();
            task.splitParams.ssdSelection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
            task.splitParams.ssdSelection.selectedPartitions = null;
            return;
        }
        if (DatasetSelection.PartitionSelectionMethod.SELECTED.equals((Object)task.partitionedModel.ssdSelection.partitionSelectionMethod)) {
            HashSet<String> newPartitions = new HashSet<String>();
            HashSet partitionSet = new HashSet(task.partitionedModel.ssdSelection.selectedPartitions);
            int numSelectedPartitions = partitionSet.size();
            for (Partition p : partitionsTo) {
                String partition = p.id();
                if (partitionSet.contains(partition)) {
                    newPartitions.add(partition);
                }
                if (newPartitions.size() != numSelectedPartitions) continue;
                break;
            }
            if (newPartitions.isEmpty()) {
                task.partitionedModel.ssdSelection.selectedPartitions = null;
                task.partitionedModel.ssdSelection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
            } else {
                task.partitionedModel.ssdSelection.selectedPartitions = new ArrayList(newPartitions);
            }
            task.splitParams.ssdSelection.selectedPartitions = task.partitionedModel.ssdSelection.selectedPartitions;
            task.splitParams.ssdSelection.partitionSelectionMethod = task.partitionedModel.ssdSelection.partitionSelectionMethod;
        }
    }

    public void fixUpAlgoDifferentPredType(PredictionMLTask.ClassicalPredictionMLTask task, AuthCtx user, AnalysisCoreParams cp) throws Exception {
        ClassicalPredictionGuesser guesser = (ClassicalPredictionGuesser)this.getGuesser(cp, task, user);
        guesser.fixUpAlgoDifferentPredType();
    }

    private String newTaskName(AnalysisCoreParams acp, String wantedName) throws Exception {
        List<AnalysisCRUDService.MLTaskHead> mlTasks;
        try (Transaction t = this.transactionService.beginRead();){
            mlTasks = this.crudService.listMLTasks(acp.projectKey, acp.id, false);
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier(" ", 1);
        for (AnalysisCRUDService.MLTaskHead head : mlTasks) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(head.name);
        }
        return transmogrifier.transmogrify(wantedName);
    }

    public String createAndGuess_NT(AuthCtx user, AnalysisCoreParams cp, String targetVariable, @Nullable String managedFolderSmartId, MLTask.BackendType mlBackendType, MLSparkParams sparkParams, PredictionGuessPolicy guessPolicy, @Nullable PredictionMLTask.PredictionType predictionType, @Nullable String timeVariable, @Nullable List<String> timeseriesIdentifiers, @Nullable String treatmentVariable) throws Exception {
        PredictionMLTask task = switch (mlBackendType) {
            case MLTask.BackendType.DEEP_HUB -> {
                PredictionMLTask.DeepHubPredictionMLTask deepHubTask = new PredictionMLTask.DeepHubPredictionMLTask();
                deepHubTask.setPredictionType(predictionType);
                deepHubTask.managedFolderSmartId = managedFolderSmartId;
                deepHubTask.name = this.newTaskName(cp, "Predict " + targetVariable);
                DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType = this.dssInternalCodeEnvsService.getDSSInternalCodeEnvTypeForDeepHub(predictionType);
                CodeEnvSelection envSelection = new CodeEnvSelection();
                Optional<CodeEnvModel.CodeEnvListItem> deepHubCodeEnv = this.dssInternalCodeEnvsService.getCodeEnv_NT(dssInternalCodeEnvType);
                String codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(dssInternalCodeEnvType);
                if (!deepHubCodeEnv.isPresent()) {
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_DEEPHUB_ENV, "Missing '" + codeEnvName + "' code environment for " + String.valueOf((Object)predictionType));
                }
                envSelection.envMode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
                envSelection.envName = codeEnvName;
                deepHubTask.envSelection = envSelection;
                this.codeEnvPermissionsService.failIfCodeEnvNotUsable(cp.projectKey, CodeEnvModel.EnvLang.PYTHON, deepHubTask, null, user);
                yield deepHubTask;
            }
            case MLTask.BackendType.PY_MEMORY -> {
                if (guessPolicy == PredictionGuessPolicy.CAUSAL_PREDICTION) {
                    if (treatmentVariable == null || treatmentVariable.isEmpty()) {
                        throw new IllegalArgumentException("Missing treatment variable");
                    }
                    PredictionMLTask.CausalPredictionMLTask causalPredictionMLTask = new PredictionMLTask.CausalPredictionMLTask();
                    causalPredictionMLTask.treatmentVariable = treatmentVariable;
                    causalPredictionMLTask.name = this.newTaskName(cp, "Predict effect of " + treatmentVariable + " on " + targetVariable);
                    causalPredictionMLTask.setGuessPolicy(PredictionGuessPolicy.CAUSAL_PREDICTION);
                    yield causalPredictionMLTask;
                }
                if (predictionType == PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
                    PredictionMLTask.TimeseriesForecastingMLTask timeseriesMlTask = new PredictionMLTask.TimeseriesForecastingMLTask();
                    timeseriesMlTask.setPredictionType(PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
                    timeseriesMlTask.setGuessPolicy(guessPolicy);
                    if (timeVariable == null) {
                        throw new IllegalArgumentException("Cannot create timeseries forecast MLTask: missing time variable");
                    }
                    timeseriesMlTask.timeVariable = timeVariable;
                    if (timeseriesIdentifiers != null && !timeseriesIdentifiers.isEmpty()) {
                        timeseriesMlTask.timeseriesIdentifiers = timeseriesIdentifiers;
                    }
                    timeseriesMlTask.name = this.newTaskName(cp, "Forecast " + targetVariable);
                    yield timeseriesMlTask;
                }
                PredictionMLTask.ClassicalPredictionMLTask classicalMlTask = new PredictionMLTask.ClassicalPredictionMLTask();
                classicalMlTask.setGuessPolicy(guessPolicy);
                classicalMlTask.name = this.newTaskName(cp, "Predict " + targetVariable);
                classicalMlTask.managedFolderSmartId = managedFolderSmartId;
                yield classicalMlTask;
            }
            case MLTask.BackendType.MLLIB, MLTask.BackendType.H2O, MLTask.BackendType.KERAS -> {
                PredictionMLTask.ClassicalPredictionMLTask classicalMlTask = new PredictionMLTask.ClassicalPredictionMLTask();
                classicalMlTask.setGuessPolicy(guessPolicy);
                classicalMlTask.name = this.newTaskName(cp, "Predict " + targetVariable);
                yield classicalMlTask;
            }
            case MLTask.BackendType.VERTICA -> throw new IllegalArgumentException("Cannot create MLTask: Vertica backend is deprecated");
            default -> throw new IllegalArgumentException("Unsupported backend: " + String.valueOf((Object)mlBackendType));
        };
        task.id = SecretKeyGenerator.generate((int)8);
        task.targetVariable = targetVariable;
        task.initiator = user.getIdentifier();
        task.backendType = mlBackendType;
        if (mlBackendType.isSparkBased()) {
            task.sparkParams = sparkParams;
        }
        MLTaskLoc loc = new MLTaskLoc(cp.projectKey, cp.id, task.id);
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.prepareMLTaskCreation(loc, task, user);
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Create prediction task for " + targetVariable + " in " + cp.projectKey + "." + cp.id + "(" + cp.name + ")");
        }
        MLPaths.createIfNeededMLTaskFolderAndRestrictPermissions(loc);
        FilesystemACLUtils.grantFSReadACLs(user, cp.projectKey, loc.getDataFolder());
        InitialGuessWorkThread thread = new InitialGuessWorkThread((DSSAuthCtx)user, loc, cp, task, predictionType);
        this.mlBaseService.addGuessing(loc);
        thread.init();
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
        return task.id;
    }

    private void selectDefaultCodeEnv_NT(AuthCtx user, String projectKey, PredictionMLTask task) throws IOException, DKUSecurityException {
        if (!ApplicationConfigurator.getNodeType().equals((Object)ApplicationConfigurator.DSSNodeType.DESIGN)) {
            return;
        }
        if (!EnumSet.of(MLTask.BackendType.PY_MEMORY, MLTask.BackendType.KERAS).contains((Object)task.backendType)) {
            return;
        }
        MLTaskCodeEnvCompatibilityComputer envCompatibilityComputer = new MLTaskCodeEnvCompatibilityComputer(task);
        if (envCompatibilityComputer.getIncompatibilityReasons_NT(PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat.builtinEnvCompatibility()).isEmpty()) {
            logger.info((Object)"Builtin environment is compatible with the current ML task");
            task.envSelection.envMode = CodeEnvSelection.EnvMode.USE_BUILTIN_MODE;
            return;
        }
        Stream<PythonCodeEnvPackagesUtils.PythonEnvPackages> compatiblePythonEnvs = this.designNodeEnvsService.getCompatiblePythonEnvs_NT(user, projectKey, task, envCompatibilityComputer);
        if (task.backendType.equals((Object)MLTask.BackendType.KERAS)) {
            String envNameCompatibleForKerasDL = this.designNodeEnvsService.getBestCompatibleEnvNameForKerasDL_NT(compatiblePythonEnvs);
            if (envNameCompatibleForKerasDL != null) {
                this.setCodeEnv(task, envNameCompatibleForKerasDL);
            } else {
                logger.warn((Object)"No compatible code environment was found for Visual Deep Learning.");
            }
            return;
        }
        if (task instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            String envNameCompatibleForTimeseries = this.designNodeEnvsService.getBestCompatibleEnvNameForTimeseries_NT(compatiblePythonEnvs);
            if (envNameCompatibleForTimeseries != null) {
                this.setCodeEnv(task, envNameCompatibleForTimeseries);
            } else {
                logger.warn((Object)"No compatible code environment was found for Visual Time Series Forecasting. Fallback to builtin env.");
                task.envSelection.envMode = CodeEnvSelection.EnvMode.USE_BUILTIN_MODE;
            }
            return;
        }
        Optional<PythonCodeEnvPackagesUtils.PythonEnvPackages> firstCompatiblePythonEnv = compatiblePythonEnvs.findFirst();
        if (firstCompatiblePythonEnv.isPresent()) {
            this.setCodeEnv(task, firstCompatiblePythonEnv.get().envName);
        } else {
            logger.warn((Object)"No compatible code environment was found.");
        }
    }

    private void setCodeEnv(PredictionMLTask task, String envNameCompatible) {
        task.envSelection.envMode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
        task.envSelection.envName = envNameCompatible;
    }

    public boolean update_NT(AuthCtx user, AnalysisCoreParams cp, String mlTaskId) throws Exception {
        PredictionMLTask task;
        logger.info((Object)"Start update guess");
        MLTaskLoc loc = new MLTaskLoc(cp.projectKey, cp.id, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            task = this.crudService.getPMLTask(loc);
        }
        PredictionMLTask taskBefore = (PredictionMLTask)JSON.deepCopy((Object)task);
        PredictionGuesser<? extends PredictionMLTask> guesser = this.getGuesser(cp, task, user);
        guesser.updateGuess(loc.getGuessStatus());
        loc.writeGuessStatus(guesser.checkStatus());
        if (JSON.json((Object)taskBefore).equals(JSON.json((Object)task))) {
            return false;
        }
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(user);){
            this.crudService.saveMLTask(loc, task, true);
            rw.commit("Updated prediction task (preparation script changed) in " + cp.projectKey + "." + cp.id + "(" + cp.name + ")");
        }
        return true;
    }

    private static boolean isTimeBoundOnlySearch(PredictionModelingParams.GridSearchParams gridSearchParams) {
        if (!EnumSet.of(PredictionModelingParams.GridSearchParams.Strategy.RANDOM, PredictionModelingParams.GridSearchParams.Strategy.BAYESIAN).contains((Object)gridSearchParams.strategy) || gridSearchParams.nIterRandom > 0) {
            return false;
        }
        if (gridSearchParams.timeout <= 0) {
            throw new IllegalArgumentException("Hyperparameter search has no limits, please select a positive 'Search space limit' or 'Time limit'");
        }
        return true;
    }

    private void checkPredictionTaskDuringTraining_NT(MLTaskLoc taskLoc, AuthCtx user, AnalysisCoreParams coreParams, PredictionMLTask pmlTask) throws Exception {
        PreTrainStatus pts = this.getPreTrainStatus_NT(taskLoc, user, coreParams, pmlTask);
        for (InfoMessage msg : pts.messages) {
            if (!msg.isFatal) continue;
            throw ErrorContext.iae((String)msg.message);
        }
    }

    public PreTrainStatus getPreTrainStatus_NT(MLTaskLoc taskLoc, AuthCtx user, AnalysisCoreParams coreParams, PredictionMLTask pmlTask) throws Exception {
        PredictionMLTask.TabularPredictionMLTask task;
        PreTrainStatus pts = new PreTrainStatus();
        PartitioningScheme partitioning = null;
        Dataset inputDataSet = null;
        try (Transaction t = this.transactionService.beginRead();){
            inputDataSet = this.datasetAccessService.getMandatoryFromRef(taskLoc.analysisProjectKey, coreParams.inputDatasetSmartName);
            if (pmlTask.isPartitioned()) {
                partitioning = inputDataSet.getPartitioningSchema();
            }
        }
        try {
            DKUMLUtils.checkPredictionTaskBeforeTraining(pmlTask);
        }
        catch (Exception e) {
            logger.warn((Object)"Check task failed", (Throwable)e);
            pts.messages.add(InfoMessage.fatal((String)e.getMessage()));
            return pts;
        }
        GuessStatus guessStatus = taskLoc.getGuessStatus();
        if (guessStatus != null && GuessStatus.GuessState.CAN_CHANGE_SETTINGS.equals((Object)guessStatus.state) && StringUtils.isNotBlank((String)guessStatus.error.message)) {
            pts.messages.add(InfoMessage.warning((String)guessStatus.error.message));
        }
        if (!pmlTask.backendType.isSparkBased()) {
            pts.splitStatus = this.splitsService.getSplitStatus_NT(coreParams, taskLoc, pmlTask, user);
        }
        switch (pmlTask.splitParams.ttPolicy) {
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                if (pmlTask.splitParams.efsdDatasetSmartName == null) break;
                Schema trainSchema = this.analysisDataService.getInferredSchemaForML_NT(coreParams, pmlTask.splitParams.efsdDatasetSmartName, user);
                pts.messages.addAll(MLSchemaComparator.checkForTrain("In train set " + pmlTask.splitParams.efsdDatasetSmartName, pmlTask.getPreprocessingParams(), trainSchema));
                break;
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                Schema trainSchema = this.analysisDataService.getInferredSchemaForML_NT(coreParams, pmlTask.splitParams.eftdTrain.datasetSmartName, user);
                pts.messages.addAll(MLSchemaComparator.checkForTrain("In train set " + pmlTask.splitParams.eftdTrain.datasetSmartName, pmlTask.getPreprocessingParams(), trainSchema));
                Schema testSchema = this.analysisDataService.getInferredSchemaForML_NT(coreParams, pmlTask.splitParams.eftdTest.datasetSmartName, user);
                pts.messages.addAll(MLSchemaComparator.checkForTrain("In test set " + pmlTask.splitParams.eftdTest.datasetSmartName, pmlTask.getPreprocessingParams(), testSchema));
                if (pmlTask.splitParams.eftdTest != null) break;
                throw new IllegalArgumentException("Test set is not set");
            }
            case SPLIT_SINGLE_DATASET: {
                if (pmlTask.splitParams.ssdDatasetSmartName == null) break;
                Schema trainSchema = this.analysisDataService.getInferredSchemaForML_NT(coreParams, pmlTask.splitParams.ssdDatasetSmartName, user);
                pts.messages.addAll(MLSchemaComparator.checkForTrain("In train set " + pmlTask.splitParams.ssdDatasetSmartName, pmlTask.getPreprocessingParams(), trainSchema));
            }
        }
        if (pmlTask.splitParams.ssdSelection.samplingMethod.needsColumn) {
            String samplingColumn = pmlTask.splitParams.ssdSelection.column;
            if (!inputDataSet.getSchema().getColumns().stream().anyMatch(p -> p.getName().equals(samplingColumn))) {
                pts.messages.add(InfoMessage.warning((String)"Missing column for sampling method", (String)String.format("Column '%s' is used for sampling but does not exist in the input dataset as it was created in the script. Select a column from the input dataset for sampling (Train / Test Set tab).", samplingColumn)));
            }
        }
        if (pmlTask.splitParams.ssdGrouped && pmlTask.splitParams.ssdGroupColumnName == null) {
            pts.messages.add(InfoMessage.warning((String)"Group k-fold column name required", (String)"Group k-fold train/test split has been selected, but a group column has not been selected. Please select a group column to use group k-fold train/test split."));
        }
        if (pmlTask instanceof PredictionMLTask.DeepHubPredictionMLTask) {
            this.checkDeepHubMLTask(user, taskLoc.analysisProjectKey, pts, (PredictionMLTask.DeepHubPredictionMLTask)pmlTask);
            return pts;
        }
        if (pmlTask instanceof PredictionMLTask.ClassicalPredictionMLTask) {
            task = (PredictionMLTask.ClassicalPredictionMLTask)pmlTask;
            Schema schema = this.analysisDataService.getInferredSchemaForML_NT(coreParams, user);
            this.checkClassicalMLTask(taskLoc, user, pts, partitioning, inputDataSet, (PredictionMLTask.ClassicalPredictionMLTask)task, schema);
            return pts;
        }
        if (pmlTask instanceof PredictionMLTask.CausalPredictionMLTask) {
            task = (PredictionMLTask.CausalPredictionMLTask)pmlTask;
            this.checkCausalMLTask(taskLoc, user, pts, partitioning, inputDataSet, (PredictionMLTask.CausalPredictionMLTask)task);
            return pts;
        }
        if (pmlTask instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            task = (PredictionMLTask.TimeseriesForecastingMLTask)pmlTask;
            this.checkTimeseriesMLTask(taskLoc, user, pts, partitioning, inputDataSet, (PredictionMLTask.TimeseriesForecastingMLTask)task, coreParams);
            return pts;
        }
        throw new IllegalArgumentException("Unknown PredictionMLTask: " + pmlTask.getClass().getName());
    }

    private HashMap<String, String> listAlgosIncompatibleWithSearchStrategy(WorkSet workSet, PredictionModelingParams.GridSearchParams.Strategy currentStrategy) throws Exception {
        if (currentStrategy == PredictionModelingParams.GridSearchParams.Strategy.GRID) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> algosIncompatibleWithSearchStrategy = new HashMap<String, String>();
        for (WorkSet.PreprocessingSet pps : workSet.preprocessingSets) {
            for (WorkSet.ModelingSet ms : pps.modelingSets) {
                if (!(ms.modelingParams instanceof PreTrainPredictionModelingParams)) {
                    throw new IllegalArgumentException("Unsupported modeling params: " + ms.modelingParams.getClass().getSimpleName());
                }
                PreTrainPredictionModelingParams rpmp = (PreTrainPredictionModelingParams)ms.modelingParams;
                Optional<PredictionModelingParams.GridSearchParams.Strategy> maxSupportedStrategy = rpmp.checkMaximumSearchStrategy(currentStrategy);
                maxSupportedStrategy.ifPresent(strategy -> algosIncompatibleWithSearchStrategy.put(rpmp.generateName(), ((PredictionModelingParams.GridSearchParams.Strategy)((Object)((Object)maxSupportedStrategy.get()))).name()));
            }
        }
        return algosIncompatibleWithSearchStrategy;
    }

    public HashMap<String, String> listAlgosIncompatibleWithSearchStrategy(PredictionMLTask.TabularPredictionMLTask task) throws Exception {
        PredictionModelingParams.GridSearchParams.Strategy currentStrategy = task.modeling.gridSearchParams.strategy;
        WorkSet workSet = TabularPredictionParamsExpander.createFromMLTask(task, "__no_session__").expand();
        return this.listAlgosIncompatibleWithSearchStrategy(workSet, currentStrategy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int countNumPartitionsAboutToBeTrained(PredictionMLTask.TabularPredictionMLTask task, AuthCtx user, Dataset inputDataset) {
        StreamableDatasetSelection ssdSelection = task.partitionedModel.ssdSelection;
        switch (ssdSelection.partitionSelectionMethod) {
            case ALL: {
                int n;
                DatasetHandler datasetHandler = DatasetHandlerFactory.build(user, inputDataset);
                try {
                    n = datasetHandler.listPartitions().size();
                    if (datasetHandler == null) return n;
                }
                catch (Throwable throwable) {
                    try {
                        if (datasetHandler == null) throw throwable;
                        try {
                            datasetHandler.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Could not compute number of partitions");
                        return 0;
                    }
                }
                datasetHandler.close();
                return n;
            }
            case LATEST_N: {
                return ssdSelection.latestPartitionsN;
            }
            case SELECTED: {
                if (null == ssdSelection.selectedPartitions) return 0;
                return ssdSelection.selectedPartitions.size();
            }
        }
        return 0;
    }

    private void checkTabularMLTask(MLTaskLoc taskLoc, AuthCtx user, PreTrainStatus pts, PartitioningScheme partitioning, Dataset inputDataSet, PredictionMLTask.TabularPredictionMLTask task) {
        pts.messages.addAll(PredictionService.checkCustomMetricParams(task.modeling.metrics.getCustomMetrics()));
        boolean noTarget = true;
        for (FeaturePreprocessingParams params : task.getPreprocessingParams().per_feature.values()) {
            if (params.role.isInput()) {
                ++pts.nbInputFeatures;
            }
            if (params.role != FeaturePreprocessingParams.Role.TARGET) continue;
            noTarget = false;
        }
        if (task.splitParams.kfold && task.splitParams.ssdGrouped && task.splitParams.ssdGroupColumnName != null && task.splitParams.ssdGroupColumnName.equals(task.targetVariable)) {
            pts.messages.add(InfoMessage.fatal((String)"Target variable cannot be group k-fold column", (String)String.format("The target column (%s) has been selected as the group column for group k-fold train/test split.", task.targetVariable)));
        }
        if (task.modeling.gridSearchParams.mode == PredictionModelingParams.GridSearchCrossValidationMode.KFOLD && task.modeling.gridSearchParams.grouped && task.modeling.gridSearchParams.groupColumnName != null && task.modeling.gridSearchParams.groupColumnName.equals(task.targetVariable)) {
            String targetRoleName = task instanceof PredictionMLTask.CausalPredictionMLTask ? "Outcome" : "Target";
            pts.messages.add(InfoMessage.fatal((String)String.format("%s variable cannot be group k-fold column", targetRoleName), (String)String.format("The %s column (%s) has been selected as the group column for group k-fold hyperparameter search.", targetRoleName.toLowerCase(), task.targetVariable)));
        }
        if (noTarget) {
            String message = task instanceof PredictionMLTask.CausalPredictionMLTask ? "No outcome selected" : "No target selected";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        boolean isTimeBoundOnlySearch = false;
        try {
            isTimeBoundOnlySearch = PredictionService.isTimeBoundOnlySearch(task.modeling.gridSearchParams);
        }
        catch (IllegalArgumentException e) {
            pts.messages.add(InfoMessage.fatal((String)e.getMessage()));
            logger.warn((Object)e.getMessage());
        }
        try {
            WorkSet ws = TabularPredictionParamsExpander.createFromMLTask(task, "__no_session__").expand();
            pts.messages.addAll(ws.messages);
            HashMap<String, String> algosIncompatibleWithSearchStrategy = this.listAlgosIncompatibleWithSearchStrategy(ws, task.modeling.gridSearchParams.strategy);
            ArrayList incompatibleSearchStrategyDetails = new ArrayList();
            algosIncompatibleWithSearchStrategy.forEach((algoName, maxStrategy) -> incompatibleSearchStrategyDetails.add(String.format("- %s (will fall back to %s search)", algoName, maxStrategy)));
            if (!incompatibleSearchStrategyDetails.isEmpty()) {
                String message = "The following algorithms are not compatible with the selected search strategy:";
                pts.messages.add(InfoMessage.warning((String)message, (String)String.join((CharSequence)"\n", incompatibleSearchStrategyDetails)));
            }
            boolean customGridSearch = task.modeling.gridSearchParams.mode == PredictionModelingParams.GridSearchCrossValidationMode.CUSTOM;
            for (WorkSet.PreprocessingSet pps : ws.preprocessingSets) {
                for (WorkSet.ModelingSet ms : pps.modelingSets) {
                    ++pts.nbModelsPreGS;
                    if (!customGridSearch) {
                        pts.estimatedTotalFits += ms.estimatedTrains;
                    }
                    if (!ms.pluginAlgoCustomGridSearch) continue;
                    pts.pluginAlgoCustomGridSearch = true;
                }
                if (customGridSearch || !task.splitParams.kfold) continue;
                pts.estimatedTotalFits += task.splitParams.nFolds * pps.modelingSets.size();
            }
            if (task.partitionedModel.enabled) {
                pts.partitionedModelEnabled = true;
                int nbPartitions = this.countNumPartitionsAboutToBeTrained(task, user, inputDataSet);
                if (nbPartitions > DKUApp.getParams().getIntParam("dku.ml.prediction.highPartitionCountLimit", Integer.valueOf(500))) {
                    pts.messages.add(InfoMessage.warning((String)"Number of partitions is unusually high", (String)("A model with " + nbPartitions + " partitions is about to be trained. Models with lots of partitions have chances to fail training.")));
                }
                pts.estimatedTotalFits *= nbPartitions;
                if (task.modeling.gridSearchParams.distributed) {
                    int maxNbModelsPerContainer = Math.min(task.maxConcurrentModelTraining, pts.nbModelsPreGS * nbPartitions);
                    pts.maxConcurrentK8sContainers = task.modeling.gridSearchParams.nContainers * maxNbModelsPerContainer;
                }
            } else if (task.modeling.gridSearchParams.distributed) {
                pts.maxConcurrentK8sContainers = task.modeling.gridSearchParams.nContainers * Math.min(task.maxConcurrentModelTraining, pts.nbModelsPreGS);
            }
            if (isTimeBoundOnlySearch) {
                pts.estimatedTotalFits = 0;
            }
            pts.timeout = task.modeling.gridSearchParams.timeout;
            if (pts.nbModelsPreGS == 0) {
                pts.messages.add(InfoMessage.warning((String)"You have not selected any algorithm"));
            }
            pts.customGridSearch = customGridSearch && pts.nbModelsPreGS > 1;
        }
        catch (Exception e) {
            logger.warn((Object)"Expansion failed", (Throwable)e);
            pts.messages.add(InfoMessage.fatal((String)"Could not prepare models", (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        if (partitioning != null) {
            if (!partitioning.isPartitioned()) {
                String message = "Partitioned model is enabled but dataset is not partitioned.";
                pts.messages.add(InfoMessage.fatal((String)message));
                logger.warn((Object)message);
            } else {
                for (String dimensionName : partitioning.getDimensionNames()) {
                    if (!task.getPreprocessingParams().per_feature.containsKey(dimensionName) || ((FeaturePreprocessingParams)task.getPreprocessingParams().per_feature.get((Object)dimensionName)).role == FeaturePreprocessingParams.Role.REJECT) continue;
                    String message = "Feature \"" + dimensionName + "\" is not rejected but is also a partitioning dimension.";
                    String details = "This feature " + ("value".equals(partitioning.getDimension(dimensionName).getType()) ? " is constant for each partition, and thus of no" : " may be constant for each partition and/or of little") + " use to the model, but causes issues if required when scoring. You should reject it.";
                    pts.messages.add(InfoMessage.warning((String)message, (String)details));
                    logger.warn((Object)message);
                }
            }
        }
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.DESIGN && task.backendType.isPythonBased()) {
            this.mlBaseService.checkVisualMlRuntime(user, pts, taskLoc.analysisProjectKey, task);
        }
    }

    private void checkClassicalMLTask(MLTaskLoc taskLoc, AuthCtx user, PreTrainStatus pts, PartitioningScheme partitioning, Dataset inputDataSet, PredictionMLTask.ClassicalPredictionMLTask task, Schema schema) {
        String message;
        this.checkTabularMLTask(taskLoc, user, pts, partitioning, inputDataSet, task);
        if (task.weight.isSampleWeightEnabled() && (task.weight.sampleWeightVariable == null || task.weight.sampleWeightVariable.isEmpty())) {
            message = "\"Sample weights\" option is enabled but no weight variable is selected.";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        if (task.time.isTimeOrderingEnabled() && (task.time.timeVariable == null || task.time.timeVariable.isEmpty())) {
            message = "\"Time ordering\" is enabled but no time variable is selected.";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        if (task.assertionsParams != null && task.assertionsParams.hasAssertions()) {
            pts.messages.addAll(PredictionService.checkAssertionsParams(task, schema));
        }
        if (task.overridesParams != null && task.overridesParams.hasOverrides()) {
            pts.messages.addAll(PredictionService.checkOverridesParams(task, schema));
        }
        if (task.uncertainty.isPredictionIntervalEnabled() && task.splitParams.kfold) {
            pts.messages.add(InfoMessage.fatal((String)"Kfold is not supported when prediction interval coverage is enabled"));
        }
        if (task.preprocessing.isMonotonicConstrainedEnabled()) {
            pts.messages.addAll(PredictionService.checkMonotonicConstraints(task));
        }
        if (task.preprocessing.isKeepMissingAsNaNEnabled()) {
            pts.messages.addAll(PredictionService.checkKeepNumericalMissingAsNaN(task));
        }
    }

    public static List<InfoMessage> checkMonotonicConstraints(PredictionMLTask.TabularPredictionMLTask task) {
        ArrayList<InfoMessage> msg = new ArrayList<InfoMessage>();
        ArrayList<String> incompatibleAlgos = new ArrayList<String>();
        for (PredictionModelingParams.ClassicalMLHyperparametersSpace space : task.modeling.listAllEnabledClassicalPythonHyperparametersSpace()) {
            if (space.isCompatibleWithMonotonicConstraints()) continue;
            incompatibleAlgos.add(space.getAlgorithmName());
        }
        if (incompatibleAlgos.size() > 0) {
            Object details = "The following selected algorithms will fail during training:";
            for (String algoName : incompatibleAlgos) {
                details = (String)details + "\n- " + algoName;
            }
            msg.add(InfoMessage.warning((String)"Algorithms incompatible with monotonicity constraints.", (String)details));
        }
        return msg;
    }

    public static List<InfoMessage> checkKeepNumericalMissingAsNaN(PredictionMLTask.TabularPredictionMLTask task) {
        ArrayList<InfoMessage> msg = new ArrayList<InfoMessage>();
        TabularPredictionPreprocessingParams.FeatureSelectionParams featureReduction = task.getPreprocessingParams().feature_selection_params;
        if (featureReduction.method == TabularPredictionPreprocessingParams.FeatureSelectionMethod.PCA) {
            msg.add(InfoMessage.warning((String)"Feature reduction (PCA) is incompatible with non-imputed empty numerical input.", (String)"Fallback method (impute missing values or drop rows) will be used instead."));
        } else if (featureReduction.method == TabularPredictionPreprocessingParams.FeatureSelectionMethod.ICA) {
            msg.add(InfoMessage.warning((String)"Feature reduction (ICA) is incompatible with non-imputed empty numerical input.", (String)"Fallback method (impute missing values or drop rows) will be used instead."));
        } else if (featureReduction.method == TabularPredictionPreprocessingParams.FeatureSelectionMethod.CORRELATION) {
            msg.add(InfoMessage.warning((String)"Feature reduction (correlation with target) is incompatible with non-imputed empty numerical input.", (String)"Fallback method (impute missing values or drop rows) will be used instead."));
        } else if (featureReduction.method == TabularPredictionPreprocessingParams.FeatureSelectionMethod.LASSO) {
            msg.add(InfoMessage.warning((String)"Feature reduction (Lasso regression) is incompatible with non-imputed empty numerical input.", (String)"Fallback method (impute missing values or drop rows) will be used instead."));
        }
        return msg;
    }

    public static List<InfoMessage> checkCustomMetricParams(List<? extends BaseCustomEvaluationMetric> customMetrics) {
        HashSet<String> usedCustomMetricNames = new HashSet<String>();
        for (BaseCustomEvaluationMetric baseCustomEvaluationMetric : customMetrics) {
            if (usedCustomMetricNames.add(baseCustomEvaluationMetric.name)) continue;
            String error = "Invalid custom metric configuration";
            String message = "Custom Metric name '" + baseCustomEvaluationMetric.name + "' is used more than once. Custom Metric names must be unique.";
            logger.warn((Object)String.format("%s - %s", error, message));
            return Collections.singletonList(InfoMessage.fatal((String)error, (String)message));
        }
        return new ArrayList<InfoMessage>();
    }

    private static List<InfoMessage> checkAssertionsParams(PredictionMLTask.ClassicalPredictionMLTask task, Schema schema) {
        ArrayList<InfoMessage> warnings = new ArrayList<InfoMessage>();
        if (!task.predictionType.supportsMLAssertions()) {
            return Collections.singletonList(InfoMessage.fatal((String)("Assertions not supported for " + String.valueOf((Object)task.predictionType))));
        }
        HashSet<String> usedAssertionNames = new HashSet<String>();
        int index = 0;
        for (MLAssertionsParams.MLAssertion assertion : task.assertionsParams.assertions) {
            if (StringUtils.isBlank((String)assertion.name)) {
                return Collections.singletonList(InfoMessage.fatal((String)("Assertion name for assertion #" + (index + 1) + " is not defined")));
            }
            if (usedAssertionNames.contains(assertion.name)) {
                return Collections.singletonList(InfoMessage.fatal((String)("Assertion name '" + assertion.name + "' is used more than once. Assertion names must be unique.")));
            }
            usedAssertionNames.add(assertion.name);
            if (assertion.assertionCondition.expectedValidRatio < 0.0 || assertion.assertionCondition.expectedValidRatio > 1.0) {
                return Collections.singletonList(InfoMessage.fatal((String)("Success ratio (" + assertion.assertionCondition.expectedValidRatio + ") for assertion '" + assertion.name + "' is not between 0 and 1")));
            }
            if (FilterDescUtils.willFilter(assertion.filter)) {
                try {
                    new Expression(FilterDescUtils.getFilterRepr(assertion.filter), schema);
                }
                catch (Exception e) {
                    return Collections.singletonList(InfoMessage.fatal((String)"Formula error on assertions", (String)("'" + assertion.name + "': " + e.getMessage())));
                }
            }
            if (task.predictionType == PredictionMLTask.PredictionType.REGRESSION) {
                if (assertion.assertionCondition.expectedMinValue == null) {
                    return Collections.singletonList(InfoMessage.fatal((String)("Min value for assertion '" + assertion.name + "' is not defined")));
                }
                if (assertion.assertionCondition.expectedMaxValue == null) {
                    return Collections.singletonList(InfoMessage.fatal((String)("Max value for assertion '" + assertion.name + "' is not defined")));
                }
                if (assertion.assertionCondition.expectedMinValue > assertion.assertionCondition.expectedMaxValue) {
                    return Collections.singletonList(InfoMessage.fatal((String)("Min value > max value for assertion '" + assertion.name + "'")));
                }
            } else if (!task.preprocessing.getTargetValues().contains(assertion.assertionCondition.expectedClass)) {
                return Collections.singletonList(InfoMessage.fatal((String)("Expected class ('" + assertion.assertionCondition.expectedClass + "') for assertion '" + assertion.name + "' is unknown")));
            }
            ++index;
        }
        return warnings;
    }

    private static Schema getClassicalPredictionOutcomeSchema(PredictionMLTask.ClassicalPredictionMLTask task, Schema schema) {
        Schema outcomeSchema = schema.getCopy();
        boolean isMulticlass = task.predictionType.equals((Object)PredictionMLTask.PredictionType.MULTICLASS);
        if (task.predictionType.equals((Object)PredictionMLTask.PredictionType.REGRESSION) || isMulticlass) {
            outcomeSchema.addColumn(new SchemaColumn("prediction", schema.getColumn(task.targetVariable).getType()));
        }
        if (task.predictionType.equals((Object)PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) || isMulticlass) {
            outcomeSchema.addColumn(new SchemaColumn("prediction_uncertainty", Type.DOUBLE));
        }
        if (task.uncertainty.isPredictionIntervalEnabled()) {
            outcomeSchema.addColumn(new SchemaColumn("prediction_interval_lower", Type.DOUBLE));
            outcomeSchema.addColumn(new SchemaColumn("prediction_interval_upper", Type.DOUBLE));
            outcomeSchema.addColumn(new SchemaColumn("prediction_interval_size", Type.DOUBLE));
            outcomeSchema.addColumn(new SchemaColumn("prediction_interval_relative_size", Type.DOUBLE));
        }
        return outcomeSchema;
    }

    private static List<InfoMessage> checkOverridesParams(PredictionMLTask.ClassicalPredictionMLTask task, Schema schema) {
        ArrayList<InfoMessage> warnings = new ArrayList<InfoMessage>();
        if (!task.predictionType.supportsMLOverrides()) {
            return Collections.singletonList(InfoMessage.fatal((String)("Overrides not supported for " + String.valueOf((Object)task.predictionType))));
        }
        if (task.isPartitioned()) {
            return Collections.singletonList(InfoMessage.fatal((String)"Overrides not supported for partitioned models"));
        }
        Schema outcomeSchema = PredictionService.getClassicalPredictionOutcomeSchema(task, schema);
        HashSet<String> usedOverridesNames = new HashSet<String>();
        int index = 0;
        for (MLOverridesParamsBase.MLOverride override : task.overridesParams.overrides) {
            if (StringUtils.isBlank((String)override.name)) {
                return Collections.singletonList(InfoMessage.fatal((String)("Override name for override #" + (index + 1) + " is not defined")));
            }
            if (usedOverridesNames.contains(override.name)) {
                return Collections.singletonList(InfoMessage.fatal((String)("Override name '" + override.name + "' is used more than once. Override names must be unique.")));
            }
            usedOverridesNames.add(override.name);
            if (FilterDescUtils.willFilter((FilterDesc)override.filter)) {
                try {
                    Expression expression = new Expression(FilterDescUtils.getFilterRepr((FilterDesc)override.filter), outcomeSchema);
                    if (!task.calibration.isEnabled() && expression.getVariables().contains("prediction_uncertainty")) {
                        warnings.add(InfoMessage.warning((String)"Uncertainty should not be used without probability calibration", (String)("The condition using uncertainty on '" + override.name + "' won't behave as expected since probabilities aren't calibrated\nPlease enable calibration in 'Advanced' > 'Probability Calibration'")));
                    }
                }
                catch (Exception e) {
                    return Collections.singletonList(InfoMessage.fatal((String)"Formula error on overrides", (String)("'" + override.name + "': " + e.getMessage())));
                }
            }
            if (override.outcome.type != MLOverridesParamsBase.MLOverride.Outcome.Type.DECLINED) {
                if (task.predictionType == PredictionMLTask.PredictionType.REGRESSION) {
                    if (override.outcome.minValue == null) {
                        return Collections.singletonList(InfoMessage.fatal((String)("Min value for override '" + override.name + "' is not defined")));
                    }
                    if (override.outcome.maxValue == null) {
                        return Collections.singletonList(InfoMessage.fatal((String)("Max value for override '" + override.name + "' is not defined")));
                    }
                    if (override.outcome.minValue > override.outcome.maxValue) {
                        return Collections.singletonList(InfoMessage.fatal((String)("Min value > max value for override '" + override.name + "'")));
                    }
                } else if (task.predictionType == PredictionMLTask.PredictionType.MULTICLASS && !task.preprocessing.getTargetValues().contains(override.outcome.category)) {
                    return Collections.singletonList(InfoMessage.fatal((String)("Expected class ('" + override.outcome.category + "') for override '" + override.name + "' is unknown")));
                }
            }
            ++index;
        }
        return warnings;
    }

    private void checkTimeseriesMLTask(MLTaskLoc taskLoc, AuthCtx user, PreTrainStatus pts, PartitioningScheme partitioning, Dataset inputDataSet, PredictionMLTask.TimeseriesForecastingMLTask task, AnalysisCoreParams acp) throws Exception {
        this.checkTabularMLTask(taskLoc, user, pts, partitioning, inputDataSet, task);
        HashSet<Double> uniqueQuantiles = new HashSet<Double>(task.quantilesToForecast);
        if (task.quantilesToForecast.size() != uniqueQuantiles.size()) {
            String message = "Duplicate quantiles were specified.";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        for (Double quantile : task.quantilesToForecast) {
            String message;
            if (Math.abs(quantile - Math.floor(quantile * 10000.0) / 10000.0) > 1.0E-8) {
                message = "Can only specify quantiles with up to 4 decimals. Got value: " + quantile;
                pts.messages.add(InfoMessage.fatal((String)message));
                logger.warn((Object)message);
            }
            if (!(quantile < 1.0E-4) && !(quantile > 0.9999)) continue;
            message = "Quantile values must be between 0.0001 and 0.9999. Got value: " + quantile;
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        MemScriptRunner.TableWithReport dataTable = this.dataService.getCachedUnfiltered_NOTRANSACTION(acp, user);
        if (StringUtils.isBlank((String)task.timeVariable) || !FeatureGuessUtils.isTemporal(dataTable.table.getColumn(task.timeVariable))) {
            String message = "No time variable selected, or time variable does not have a 'Date' meaning.";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        if (task.customTrainTestSplit) {
            if (task.customTrainTestIntervals.isEmpty()) {
                pts.messages.add(InfoMessage.fatal((String)"Custom train/test split is enabled but no interval was specified."));
            }
            DateTimeFormatter dtf = task.getDateTimeFormatter();
            for (int intervalIndex = 0; intervalIndex < task.customTrainTestIntervals.size(); ++intervalIndex) {
                PredictionMLTask.TimeseriesForecastingMLTask.FoldInterval interval = task.customTrainTestIntervals.get(intervalIndex);
                String messagePrefix = String.format("Fold %s - ", intervalIndex + 1);
                try {
                    LocalDateTime trainStart = LocalDateTime.parse(interval.train.get(0), dtf);
                    LocalDateTime trainEnd = LocalDateTime.parse(interval.train.get(1), dtf);
                    LocalDateTime testStart = LocalDateTime.parse(interval.test.get(0), dtf);
                    LocalDateTime testEnd = LocalDateTime.parse(interval.test.get(1), dtf);
                    if (trainEnd.isBefore(trainStart)) {
                        pts.messages.add(InfoMessage.fatal((String)(messagePrefix + "Train end date is before train start date.")));
                    }
                    if (testStart.isBefore(trainEnd)) {
                        pts.messages.add(InfoMessage.fatal((String)(messagePrefix + "Test start date is before train end date.")));
                    }
                    if (testEnd.isBefore(testStart)) {
                        pts.messages.add(InfoMessage.fatal((String)(messagePrefix + "Test end date is before test start date.")));
                    }
                    TimestepParams.TimeUnitQuantity timeUnitQuantity = task.timestepParams.timeunit.toTimeUnitQuantity();
                    long theoreticalMaxTestTimesteps = task.timestepParams.timeunit == TimestepParams.Timeunit.BUSINESS_DAY ? PredictionService.countBusinessDaysBetween(testStart, testEnd) : timeUnitQuantity.unit.between(testStart, testEnd);
                    if (task.predictionLength * task.timestepParams.numberOfTimeunits <= theoreticalMaxTestTimesteps) continue;
                    pts.messages.add(InfoMessage.fatal((String)(messagePrefix + "Test length is shorter than " + task.predictionLength + " timesteps (1 forecast horizon)" + (task.timestepParams.numberOfTimeunits > 1L ? "s" : ""))));
                    continue;
                }
                catch (DateTimeParseException e) {
                    pts.messages.add(InfoMessage.fatal((String)(messagePrefix + e.getMessage())));
                }
            }
        }
        PredictionParameterChecks checks = new PredictionParameterChecks(task.modeling, task.preprocessing);
        try {
            task.preprocessing.validateWindowsAndShifts(checks, task);
            pts.messages.addAll(checks.getMessages());
        }
        catch (IllegalArgumentException e) {
            pts.messages.add(InfoMessage.fatal((String)e.getMessage()));
        }
    }

    private static long countBusinessDaysBetween(LocalDateTime start, LocalDateTime end) {
        LocalDateTime currentDate = start;
        long businessDays = 0L;
        while (currentDate.isBefore(end)) {
            DayOfWeek dayOfWeek = currentDate.getDayOfWeek();
            if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY) {
                ++businessDays;
            }
            currentDate = currentDate.plusDays(1L);
        }
        return businessDays;
    }

    private void checkDeepHubMLTask(AuthCtx user, String projectKey, PreTrainStatus pts, PredictionMLTask.DeepHubPredictionMLTask pmlTask) throws IOException, DKUSecurityException {
        InfoMessage message = this.checkDeepHubCodeEnv(pmlTask);
        if (message != null) {
            pts.messages.add(message);
        }
        String deephubCodeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(this.dssInternalCodeEnvsService.getDSSInternalCodeEnvTypeForDeepHub(pmlTask.predictionType));
        this.mlBaseService.checkVisualMLContainerSelection(user, pts, deephubCodeEnvName, projectKey, pmlTask);
    }

    public InfoMessage checkDeepHubCodeEnv(PredictionMLTask.DeepHubPredictionMLTask pmlTask) throws IOException {
        DSSInternalCodeEnvsService.DSSInternalCodeEnvType dssInternalCodeEnvType = this.dssInternalCodeEnvsService.getDSSInternalCodeEnvTypeForDeepHub(pmlTask.predictionType);
        String codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(dssInternalCodeEnvType);
        if (pmlTask.envSelection.envMode != CodeEnvSelection.EnvMode.EXPLICIT_ENV || !pmlTask.envSelection.envName.equals(codeEnvName)) {
            if (this.dssInternalCodeEnvsService.getCodeEnv_NT(dssInternalCodeEnvType).isPresent()) {
                return InfoMessage.warning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NOT_USING_LATEST_DEEPHUB_ENV, (String)("Runtime is not using the latest code environment for " + String.valueOf((Object)pmlTask.predictionType) + " (" + codeEnvName + ")."));
            }
            return InfoMessage.warning((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_DEEPHUB_ENV, (String)("Runtime is not using the latest code environment for " + String.valueOf((Object)pmlTask.predictionType) + " (not installed)."));
        }
        return null;
    }

    private void checkCausalMLTask(MLTaskLoc taskLoc, AuthCtx user, PreTrainStatus pts, PartitioningScheme partitioning, Dataset inputDataSet, PredictionMLTask.CausalPredictionMLTask task) throws Exception {
        this.checkTabularMLTask(taskLoc, user, pts, partitioning, inputDataSet, task);
        boolean noTreatment = true;
        for (FeaturePreprocessingParams params : task.preprocessing.per_feature.values()) {
            if (params.role != FeaturePreprocessingParams.Role.TREATMENT) continue;
            noTreatment = false;
            break;
        }
        if (noTreatment) {
            String message = "No treatment selected";
            pts.messages.add(InfoMessage.fatal((String)message));
            logger.warn((Object)message);
        }
        if (task.modeling.gridSearchParams.mode == PredictionModelingParams.GridSearchCrossValidationMode.KFOLD && task.modeling.gridSearchParams.grouped && task.modeling.gridSearchParams.groupColumnName != null && task.modeling.gridSearchParams.groupColumnName.equals(task.treatmentVariable)) {
            pts.messages.add(InfoMessage.fatal((String)"Treatment variable cannot be group k-fold column", (String)String.format("The treatment column (%s) has been selected as the group column for group k-fold hyperparameter search.", task.treatmentVariable)));
        }
    }

    public static boolean isHPSearchNeeded(PredictionMLTask.TabularPredictionMLTask task) throws Exception {
        if (task.backendType == MLTask.BackendType.KERAS) {
            return false;
        }
        if (PredictionService.isTimeBoundOnlySearch(task.modeling.gridSearchParams)) {
            return true;
        }
        WorkSet workSet = TabularPredictionParamsExpander.createFromMLTask(task, "__no_session__").expand();
        return workSet.preprocessingSets.stream().anyMatch(ps2 -> ps2.modelingSets.stream().anyMatch(ms -> ms.estimatedTrains > 1 || ms.pluginAlgoCustomGridSearch));
    }

    public String trainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        return this.trainStartHelper_NT(user, cp, loc, task, null, userSessionName, userSessionDescription, runQueue);
    }

    public void trainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, String sessionId, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        this.trainStartHelper_NT(user, cp, loc, task, sessionId, userSessionName, userSessionDescription, runQueue);
    }

    private String trainStartHelper_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, @Nullable String sessionId, String userSessionName, String userSessionDescription, boolean runQueue) throws Exception {
        this.mlBaseService.failIfWorking(loc, false);
        this.checkPredictionTaskDuringTraining_NT(loc, user, cp, task);
        MLPaths.createIfNeededMLTaskFolderAndRestrictPermissions(loc);
        FilesystemACLUtils.grantFSReadACLs(user, cp.projectKey, loc.getDataFolder());
        TrainWorkThread thread = new TrainWorkThread((DSSAuthCtx)user, loc, cp, task, sessionId, userSessionName, userSessionDescription);
        thread.initiator = user.getIdentifier();
        this.mlBaseService.setWorking(loc, thread);
        this.mlBaseService.setQueueState(loc, runQueue);
        thread.init();
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
        return thread.sessionId;
    }

    public void retrainStart_NT(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, String sessionId, PredictionMLTask task, String[] fullModelIdArray) throws Exception {
        this.mlBaseService.failIfWorking(loc, false);
        this.checkPredictionTaskDuringTraining_NT(loc, user, cp, task);
        List<FullModelId> fullModelIdList = task.isPartitioned() ? this.getPartFMIsToRetrain(fullModelIdArray) : this.getFMIsToRetrain(fullModelIdArray);
        this.runRetrainThread(user, cp, loc, sessionId, task, fullModelIdList);
    }

    private void runRetrainThread(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, String sessionId, PredictionMLTask task, List<FullModelId> fmisToRetrain) throws Exception {
        ReTrainWorkThread thread = new ReTrainWorkThread(user, loc, cp, task, sessionId, fmisToRetrain);
        thread.initiator = user.getIdentifier();
        this.mlBaseService.setWorking(loc, thread);
        thread.init();
        FilesystemACLUtils.grantFSReadACLs(user, cp.projectKey, loc.getDataFolder());
        this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    private List<FullModelId> getFMIsToRetrain(String[] fullModelIdArray) throws Exception {
        ArrayList<FullModelId> fullModelIdList = new ArrayList<FullModelId>();
        if (fullModelIdArray != null) {
            for (String fullModelId : fullModelIdArray) {
                FullModelId fmi = FullModelId.parse(fullModelId);
                File stopSearchFile = fmi.getStopSearchFile();
                if (stopSearchFile.exists() && !stopSearchFile.delete()) {
                    throw new Exception("Could not delete stop_search file");
                }
                ModelTrainInfo mti = fmi.parseModelFile("train_info.json", ModelTrainInfo.class);
                mti.resumed = mti.state == ModelTrainInfo.ModelTrainState.DONE;
                mti.state = ModelTrainInfo.ModelTrainState.PENDING;
                JSON.prettyToFile((Object)mti, (File)new File(fmi.getModelFolder(), "train_info.json"));
                fullModelIdList.add(fmi);
            }
        }
        return fullModelIdList;
    }

    private List<FullModelId> getPartFMIsToRetrain(String[] baseFmisArray) throws IOException {
        ArrayList<FullModelId> partFmisList = new ArrayList<FullModelId>();
        if (baseFmisArray == null) {
            return partFmisList;
        }
        for (String baseFmiStr : baseFmisArray) {
            FullModelId baseFmi = FullModelId.parse(baseFmiStr);
            boolean needToRetrain = false;
            ArrayList<String> partitionsToSetPending = new ArrayList<String>();
            PartitionedModelExtract extract = this.partitionedExtractService.read(baseFmi);
            if (extract != null) {
                for (Map.Entry<String, PartitionedModelExtract.PartitionedModelSummary> elem : extract.summaries.entrySet()) {
                    PartitionedModelExtract.PartitionedModelSummary summary = elem.getValue();
                    FullModelId partFmi = FullModelId.parse(summary.snippet.fullModelId);
                    if (summary.state == PartitionedModelExtract.PartitionState.PENDING) {
                        needToRetrain = true;
                        continue;
                    }
                    if (summary.state != PartitionedModelExtract.PartitionState.ABORTED) continue;
                    needToRetrain = true;
                    ModelTrainInfo mti = partFmi.parseModelFile("train_info.json", ModelTrainInfo.class);
                    mti.state = ModelTrainInfo.ModelTrainState.PENDING;
                    JSON.prettyToFile((Object)mti, (File)partFmi.getModelFile("train_info.json"));
                    partitionsToSetPending.add(elem.getKey());
                    partFmisList.add(partFmi);
                }
            }
            if (!partitionsToSetPending.isEmpty()) {
                this.partitionedExtractService.updateStates(baseFmi, PartitionedModelExtract.PartitionState.PENDING, partitionsToSetPending.toArray(new String[0]));
            }
            if (!needToRetrain) continue;
            ModelTrainInfo mti = baseFmi.parseModelFile("train_info.json", ModelTrainInfo.class);
            mti.state = ModelTrainInfo.ModelTrainState.PENDING;
            JSON.prettyToFile((Object)mti, (File)new File(baseFmi.getModelFolder(), "train_info.json"));
        }
        return partFmisList;
    }

    public FutureResponse<String> createSavedModelVersionWithDifferentOverrides_NT(AuthCtx user, FullModelId originFmi, String newModelName, MLOverridesParams newOverridesParams) throws Exception {
        assert (originFmi.type == FullModelId.Type.SAVED);
        String newVersionId = "" + System.currentTimeMillis();
        FullModelId newFmi = new FullModelId(originFmi.getProjectKey(), originFmi.getSavedModelID(), newVersionId);
        logger.info((Object)("Creating new model version '" + String.valueOf(newFmi) + "' from version '" + String.valueOf(originFmi) + "', with different override params"));
        newFmi.getModelFolder().mkdir();
        DKUFileUtils.copyDirectory((File)originFmi.getModelFolder(), (File)newFmi.getModelFolder());
        ModelUserMeta mum = newFmi.getUserMeta();
        mum.name = newModelName;
        newFmi.saveUserMeta(mum);
        JSON.prettyToFile((Object)newOverridesParams, (File)newFmi.getOverridesFile());
        logger.info((Object)("Starting retraining new model version with different overrides (fmi=" + String.valueOf(newFmi) + ")"));
        PredictionPostComputationHandler.RetrainingPTCWorkThread ft = new PredictionPostComputationHandler.RetrainingPTCWorkThread((DSSAuthCtx)user, newFmi);
        return this.futureService.runFuture(ft, 0L, ft.getTypeToken());
    }

    public void createTrainedModelWithDifferentOverridesAnalysis_NT(AuthCtx user, FullModelId originFmi, String newModelName, MLOverridesParams newOverridesParams) throws Exception {
        AnalysisCoreParams acp;
        assert (originFmi.type == FullModelId.Type.ANALYSIS);
        this.mlBaseService.failIfWorking(originFmi.getTaskLoc(), false);
        MLTaskLoc loc = originFmi.getTaskLoc();
        String newSessionId = this.mlBaseService.getNextSessionIdAndCreateSessionFolder(loc);
        FullModelId newFmi = new FullModelId(loc, newSessionId, "pp1", "m1");
        logger.info((Object)("Creating new model version '" + String.valueOf(newFmi) + "' from version '" + String.valueOf(originFmi) + "', with different override params"));
        this.copyModelFilesInNewSession(originFmi, newFmi);
        ModelTrainInfo mti = newFmi.parseModelFile("train_info.json", ModelTrainInfo.class);
        mti.state = ModelTrainInfo.ModelTrainState.PENDING;
        JSON.prettyToFile((Object)mti, (File)new File(newFmi.getModelFolder(), "train_info.json"));
        JSON.prettyToFile((Object)newOverridesParams, (File)newFmi.getOverridesFile());
        PredictionMLTask.ClassicalPredictionMLTask task = this.getPreTrainEquivalentClassicalMLTask(newFmi);
        task.overridesParams = newOverridesParams;
        JSON.prettyToFile((Object)task, (File)newFmi.getSessionFile("mltask.json"));
        ModelUserMeta mum = newFmi.getUserMeta();
        mum.name = newModelName;
        newFmi.saveUserMeta(mum);
        ArrayList<FullModelId> toRetrain = new ArrayList<FullModelId>();
        toRetrain.add(newFmi);
        try (Transaction t = this.transactionService.beginRead();){
            acp = this.crudService.getCoreMandatory(loc.analysisProjectKey, loc.analysisId);
        }
        logger.info((Object)("Starting retraining new model version with different overrides (fmi=" + String.valueOf(newFmi) + ")"));
        this.runRetrainThread(user, acp, newFmi.getTaskLoc(), newFmi.getSessionId(), task, toRetrain);
    }

    private void copyModelFilesInNewSession(FullModelId originFmi, FullModelId newSessionFmi) throws IOException {
        for (File sessionFile : DKUFileUtils.listFiles((File)originFmi.getSessionFolder())) {
            File targetSessionFolder = newSessionFmi.getSessionFolder();
            BasicFileAttributes sessionFileAttributes = DKUFileUtils.getAttributesNoFollowLinksOrNull((File)sessionFile);
            if (sessionFileAttributes == null) continue;
            if (sessionFileAttributes.isRegularFile()) {
                FileUtils.copyFileToDirectory((File)sessionFile, (File)targetSessionFolder);
                continue;
            }
            if (!sessionFileAttributes.isDirectory() || !sessionFile.getName().equals(originFmi.getPreprocessingId())) continue;
            File targetPreprocessingFolder = newSessionFmi.getPreprocessingFolder();
            for (File preprocessingFile : DKUFileUtils.listFiles((File)sessionFile)) {
                BasicFileAttributes preprocessingFileAttributes = DKUFileUtils.getAttributesNoFollowLinksOrNull((File)preprocessingFile);
                if (preprocessingFileAttributes == null) continue;
                if (preprocessingFileAttributes.isRegularFile()) {
                    FileUtils.copyFileToDirectory((File)preprocessingFile, (File)targetPreprocessingFolder);
                }
                if (!preprocessingFileAttributes.isDirectory() || !preprocessingFile.getName().equals(originFmi.getModelId())) continue;
                DKUFileUtils.copyDirectory((File)preprocessingFile, (File)newSessionFmi.getModelFolder());
            }
        }
    }

    private PredictionMLTask.ClassicalPredictionMLTask getPreTrainEquivalentClassicalMLTask(FullModelId fmi) throws IOException {
        PredictionMLTask task = (PredictionMLTask)fmi.getTrainedWithMLTask();
        if (!(task instanceof PredictionMLTask.ClassicalPredictionMLTask)) {
            throw new IllegalArgumentException("fmi " + String.valueOf(fmi) + " does not correspond to a classical ML Task");
        }
        PredictionMLTask.ClassicalPredictionMLTask classicalTask = (PredictionMLTask.ClassicalPredictionMLTask)task;
        classicalTask.modeling = PredictionModelingParams.fromPredictionModelingParamsNoEnabledAlgos(classicalTask.modeling, classicalTask.predictionType);
        PreTrainPredictionModelingParams preTrain = fmi.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
        preTrain.algorithm.meta.refreshMLTask(classicalTask.modeling, preTrain);
        return classicalTask;
    }

    public void enqueueSession(AuthCtx user, AnalysisCoreParams cp, MLTaskLoc loc, PredictionMLTask task, boolean pauseQueue, String userSessionName, String userSessionDescription, Boolean forceRefresh) throws Exception {
        this.mlBaseService.failIfWorking(loc, true);
        String sessionId = this.mlBaseService.getNextSessionIdAndCreateSessionFolder(loc);
        DKUMLUtils.dumpParamsOnDisk(cp, loc, task, sessionId);
        try {
            MLBaseService.QueuedSessionMetadata queuedSessionMetadata = new MLBaseService.QueuedSessionMetadata();
            queuedSessionMetadata.userSessionName = userSessionName;
            queuedSessionMetadata.userSessionDescription = userSessionDescription;
            queuedSessionMetadata.forceSplitRefresh = forceRefresh;
            queuedSessionMetadata.sessionOwner = user.getIdentifier();
            JSON.prettyToFile((Object)queuedSessionMetadata, (File)new File(loc.getSessionFolder(sessionId), "queue_info.json"));
        }
        catch (IOException e) {
            logger.error((Object)"Failed to mark session as queued", (Throwable)e);
        }
        if (pauseQueue) {
            this.mlBaseService.setQueueState(loc, false);
        }
    }

    public String trainQueue(AnalysisCoreParams cp, MLTaskLoc loc) throws Exception {
        if (this.mlBaseService.isTraining(loc)) {
            return null;
        }
        String nextSessionId = this.mlBaseService.getNextQueuedSessionId(loc);
        PredictionMLTask task = null;
        if (nextSessionId != null) {
            try (Transaction t = this.transactionService.beginRead();){
                task = this.crudService.getPMLSessionTask(loc, nextSessionId, false);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get ML task", (Throwable)e);
            }
            if (task != null) {
                MLBaseService.QueuedSessionMetadata queuedSessionMetadata = new MLBaseService.QueuedSessionMetadata();
                try {
                    File sessionFolder = loc.getSessionFolder(nextSessionId);
                    File queueInfoFile = new File(sessionFolder, "queue_info.json");
                    queuedSessionMetadata = (MLBaseService.QueuedSessionMetadata)JSON.parseFile((File)queueInfoFile, MLBaseService.QueuedSessionMetadata.class);
                    DKUFileUtils.delete((File)queueInfoFile);
                }
                catch (IOException e) {
                    logger.info((Object)"Failed to delete queue_info.json", (Throwable)e);
                }
                this.mlBaseService.setQueueState(loc, true);
                DSSAuthCtx user = null;
                try (Transaction t = this.transactionService.beginRead();){
                    user = this.mlBaseService.getQueuedSessionUser(queuedSessionMetadata.sessionOwner, loc);
                }
                if (queuedSessionMetadata.forceSplitRefresh != null && queuedSessionMetadata.forceSplitRefresh.booleanValue()) {
                    t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)user);
                    try {
                        ++task.splitParams.instanceIdRefresher;
                        this.crudService.saveMLTask(loc, task, true);
                        t.commit("Saved settings of ML task " + task.id + " in " + loc.analysisProjectKey + "." + loc.analysisId);
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                }
                this.trainStart_NT(user, cp, loc, task, nextSessionId, queuedSessionMetadata.userSessionName, queuedSessionMetadata.userSessionDescription, true);
            }
        }
        if (nextSessionId == null || task == null) {
            this.mlBaseService.setQueueState(loc, false);
        }
        return nextSessionId;
    }

    public List<FullModelId> listTaskModelIds(MLTaskLoc taskLoc) {
        ArrayList<FullModelId> ret = new ArrayList<FullModelId>();
        HashSet<String> modelsBeingTrained = new HashSet<String>();
        MLBaseService.MLTaskWorkThread thread = this.mlBaseService.getWorkingThread(taskLoc);
        if (thread != null) {
            for (FullModelId fmi : thread.modelsBeingTrained()) {
                modelsBeingTrained.add(fmi.toString());
                ret.add(fmi);
            }
        }
        for (FullModelId fmi : this.mlBaseService.listCompletedModelIds(taskLoc)) {
            if (modelsBeingTrained.contains(fmi.toString())) continue;
            ret.add(fmi);
        }
        return ret;
    }

    public Map<String, PredictionModelSnippetData> getSnippets_NT(PredictionMLTask task, List<FullModelId> fullModelIdList) {
        HashMap<String, PredictionModelSnippetData> snippets = new HashMap<String, PredictionModelSnippetData>();
        for (FullModelId fmi : fullModelIdList) {
            try {
                PredictionModelSnippetData pms;
                if (fmi.isModelPartition()) continue;
                PredictionModelDetails details = PredictionResultsReader.makeModelDetails(fmi);
                if (details instanceof ClassicalPredictionModelDetails) {
                    ClassicalPredictionModelDetails modelDetails = (ClassicalPredictionModelDetails)details;
                    modelDetails.headTaskCMW = ((PredictionMLTask.ClassicalPredictionMLTask)task).modeling.metrics.costMatrixWeights;
                    pms = PredictionResultsReader.makeSnippet(details);
                    PredictionResultsReader.addGridsearchData(pms, modelDetails, fmi);
                    PredictionResultsReader.addKerasModelTrainingInfo(pms, fmi);
                    PredictionResultsReader.addPartitionedBaseModelInfo(pms, fmi);
                } else if (details instanceof DeepHubPredictionModelDetails) {
                    pms = PredictionResultsReader.makeSnippet(details);
                    PredictionResultsReader.addDeepHubModelTrainingInfo(pms, fmi);
                } else if (details instanceof CausalPredictionModelDetails) {
                    pms = PredictionResultsReader.makeSnippet(details);
                    PredictionResultsReader.addGridsearchData(pms, details, fmi);
                } else if (details instanceof TimeseriesForecastingModelDetails) {
                    pms = PredictionResultsReader.makeSnippet(details);
                    PredictionResultsReader.addGridsearchData(pms, details, fmi);
                    PredictionResultsReader.addPartitionedBaseModelInfo(pms, fmi);
                } else {
                    throw new IllegalArgumentException("Unsupported model details: " + details.getClass().getSimpleName());
                }
                snippets.put(fmi.toString(), pms);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to get status for model " + String.valueOf(fmi)), (Throwable)e);
                PredictionModelSnippetData errorSnippet = new PredictionModelSnippetData();
                errorSnippet.fullModelId = fmi.toString();
                errorSnippet.sessionId = fmi.getSessionId();
                errorSnippet.trainInfo = new ModelTrainInfo();
                errorSnippet.trainInfo.state = ModelTrainInfo.ModelTrainState.FAILED;
                errorSnippet.trainInfo.failure = new APIError((Throwable)e, true);
                errorSnippet.userMeta = new ModelUserMeta();
                errorSnippet.userMeta.name = "Unreadable model";
                snippets.put(fmi.toString(), errorSnippet);
            }
        }
        return snippets;
    }

    public FullModelId getLatestModelId(PredictionMLTask task, List<FullModelId> fullModelIdList) {
        Map<String, PredictionModelSnippetData> snippets = this.getSnippets_NT(task, fullModelIdList);
        PredictionModelSnippetData latestVersion = snippets.values().stream().filter(v -> v.trainInfo != null).max(Comparator.comparing(v -> v.trainInfo.endTime)).orElse(null);
        if (latestVersion == null) {
            return null;
        }
        return FullModelId.parse(latestVersion.fullModelId);
    }

    public PredictionMLTaskStatus getLightMLTaskStatus_NT(MLTaskLoc taskLoc) {
        PredictionMLTaskStatus ret = new PredictionMLTaskStatus();
        ret.guessing = this.mlBaseService.isGuessing(taskLoc);
        ret.training = this.mlBaseService.isTraining(taskLoc);
        ret.queueStatus = this.mlBaseService.getQueueStatus(taskLoc);
        if (!ret.guessing) {
            ret.guessStatus = taskLoc.getGuessStatus();
        }
        return ret;
    }

    public PredictionMLTaskStatus getMLTaskStatus_NT(MLTaskLoc taskLoc) throws IOException {
        PredictionMLTaskStatus ret = this.getLightMLTaskStatus_NT(taskLoc);
        HashSet<String> modelsBeingTrained = new HashSet<String>();
        MLBaseService.MLTaskWorkThread thread = this.mlBaseService.getWorkingThread(taskLoc);
        if (thread != null) {
            Map<FullModelId, ContainerUsageMetrics> containerUsageMetricsPerModel = thread.getContainerUsageMetricsPerModel();
            for (FullModelId fmi : thread.modelsBeingTrained()) {
                modelsBeingTrained.add(fmi.toString());
                ret.addModelIdInfo(fmi, true, (ContainerUsageMetrics)containerUsageMetricsPerModel.get(fmi));
            }
        }
        for (FullModelId fmi : this.mlBaseService.listCompletedModelIds(taskLoc)) {
            if (modelsBeingTrained.contains(fmi.toString())) continue;
            ret.addModelIdInfo(fmi, false, null);
        }
        File lastSessionFolder = taskLoc.getLastSessionFolder();
        if (lastSessionFolder != null) {
            ret.headSessionTask = (PredictionMLTask)JSON.parseFile((File)new File(lastSessionFolder, "mltask.json"), MLTask.class);
        }
        return ret;
    }

    public Callable<NotebookToSave> createJupyterNotebook(final FullModelId fmi, String notebookTitle, final AuthCtx authCtx) throws Exception {
        PredictionMLTask.PredictionType predictionType = fmi.getPredictionType();
        if (!EnumSet.of(PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.MULTICLASS, PredictionMLTask.PredictionType.REGRESSION).contains((Object)predictionType)) {
            throw new IllegalArgumentException("Unsupported prediction type for jupyter notebook export: " + String.valueOf((Object)predictionType));
        }
        final ClassicalPredictionModelDetails pms = PredictionResultsReader.makeDetails(fmi);
        final AnalysisCoreParams acp = this.crudService.getCoreMandatory(fmi.getProjectKey(), fmi.getTaskLoc().analysisId);
        final JsonObject splitStuff = new JsonObject();
        SplitParams sp = pms.splitDesc.params;
        if (sp.ttPolicy == SplitParams.TrainTestPolicy.SPLIT_SINGLE_DATASET && sp.ssdSplitMode == SplitParams.SplitMode.RANDOM && !sp.kfold) {
            splitStuff.addProperty("splitTrainingRatio", (Number)sp.ssdTrainingRatio);
            if (sp.ssdSelection.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
                splitStuff.addProperty("respectedSampling", Boolean.valueOf(true));
                splitStuff.addProperty("splitSamplingHeadRows", (Number)sp.ssdSelection.maxRecords);
            } else {
                splitStuff.addProperty("respectedSampling", Boolean.valueOf(false));
                splitStuff.addProperty("splitSamplingHeadRows", (Number)100000);
            }
        } else {
            splitStuff.addProperty("respectedSampling", Boolean.valueOf(false));
            splitStuff.addProperty("splitTrainingRatio", (Number)0.8);
            splitStuff.addProperty("splitSamplingHeadRows", (Number)100000);
        }
        List<JupyterUtils.JupyterNotebookListEntry> existingNotebooks = this.jupyterService.listSimple(DSSAuthCtx.newNone(), fmi.getProjectKey());
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (JupyterUtils.JupyterNotebookListEntry nbk : existingNotebooks) {
            transmogrifier.addAlreadyTransmogrifiedAcceptDupes(nbk.name);
        }
        notebookTitle = notebookTitle.replaceAll("[\\\\:/\\s]+", " ");
        final String transmogrifiedTitle = transmogrifier.transmogrify(notebookTitle);
        final RelFile newNotebookFile = this.jupyterService.getNotebookFile(fmi.getProjectKey(), transmogrifiedTitle);
        CodeEnvSelection envSelection = pms.coreParams.executionParams.envSelection;
        Pair<String, String> nameAndDisplayNameOfKernelSpecs = this.jupyterService.getNameAndDisplayNameOfKernelSpecs(fmi.getProjectKey(), envSelection).orElse((Pair<String, String>)Pair.of((Object)"python3", (Object)"Python 3"));
        final String finalKernelName = (String)nameAndDisplayNameOfKernelSpecs.getLeft();
        final String finalKernelDisplayName = (String)nameAndDisplayNameOfKernelSpecs.getRight();
        return new Callable<NotebookToSave>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotebookToSave call() throws Exception {
                logger.info((Object)"Acquiring a kernel");
                PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), dssPortRange);
                AnalysisMLKernel dk = new AnalysisMLKernel(link, null, fmi.getProjectKey(), null, authCtx, fmi.getModelFolder(), null);
                dk.start();
                try {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("model_name", pms.userMeta.name);
                    obj.addProperty("model_date", (Number)(pms.trainInfo.startTime / 1000L));
                    obj.addProperty("dataset_smartname", acp.inputDatasetSmartName);
                    obj.add("script", (JsonElement)JSON.toJsonObject((Object)pms.trainedWithScript, (String[])new String[0]));
                    obj.add("preparation_output_schema", (JsonElement)JSON.toJsonObject((Object)pms.splitDesc.schema, (String[])new String[0]));
                    obj.add("split_stuff", (JsonElement)splitStuff);
                    obj.add("core_params", (JsonElement)JSON.toJsonObject((Object)pms.coreParams, (String[])new String[0]));
                    obj.add("pre_train", (JsonElement)JSON.toJsonObject((Object)pms.modeling, (String[])new String[0]));
                    obj.add("post_train", (JsonElement)JSON.toJsonObject((Object)pms.actualParams.resolved, (String[])new String[0]));
                    obj.add("preprocessing_params", (JsonElement)JSON.toJsonObject((Object)pms.preprocessing, (String[])new String[0]));
                    obj.addProperty("kernel_name", finalKernelName);
                    obj.addProperty("kernel_display_name", finalKernelDisplayName);
                    String jsonContent = null;
                    try {
                        jsonContent = (String)link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest("create_prediction_notebook", obj.toString()), null, String.class, "Failed to convert").call();
                    }
                    catch (SocketBlockLinkException e) {
                        throw e.withLogTail((IDSSKernelBase)dk);
                    }
                    if (JupyterService.getKernelFolder("python3").isDirectory()) {
                        logger.info((Object)"Setting Python 3 base env");
                        try {
                            JsonObject jsonNBK = (JsonObject)JSON.parse((String)jsonContent, JsonObject.class);
                            jsonNBK.get("metadata").getAsJsonObject().get("kernelspec").getAsJsonObject().addProperty("name", "python3");
                            jsonNBK.get("metadata").getAsJsonObject().get("kernelspec").getAsJsonObject().addProperty("display_name", "Python 3");
                            jsonContent = JSON.pretty((Object)jsonNBK);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Failed to override builtin env kernel name", (Throwable)e);
                        }
                    }
                    NotebookToSave nbk = new NotebookToSave();
                    nbk.transmogrifiedTitle = transmogrifiedTitle;
                    nbk.newNotebookFile = newNotebookFile;
                    nbk.jsonContent = jsonContent;
                    NotebookToSave notebookToSave = nbk;
                    return notebookToSave;
                }
                finally {
                    try {
                        dk.killWithoutMercy();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failure while destroying ml kernel", (Throwable)e);
                    }
                    try {
                        link.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failure while closing link to kernel", (Throwable)e);
                    }
                }
            }
        };
    }

    private PredictionGuesser<? extends PredictionMLTask> getGuesser(AnalysisCoreParams cp, PredictionMLTask task, AuthCtx user) throws Exception {
        MemScriptRunner.TableWithReport dataTable = this.dataService.getCachedUnfiltered_NOTRANSACTION(cp, user);
        return task.getGuesser(dataTable.table);
    }

    public FullModelId createEnsemble(AuthCtx auth, MLTaskLoc loc, AnalysisCoreParams acp, List<FullModelId> fmis, EnsembleParams.EnsembleMethod method) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(auth);){
            PredictionMLTask.ClassicalPredictionMLTask task = (PredictionMLTask.ClassicalPredictionMLTask)this.crudService.getPMLTask(loc);
            if (!task.predictionType.supportsEnsemble()) {
                throw new IllegalArgumentException("Can't ensemble predictions models of type " + String.valueOf((Object)task.predictionType));
            }
            ArrayList<ResolvedPredictionPreprocessingParams> rppps = new ArrayList<ResolvedPredictionPreprocessingParams>();
            ArrayList<PreTrainPredictionModelingParams> rpmps = new ArrayList<PreTrainPredictionModelingParams>();
            ArrayList<ResolvedClassicalPredictionCoreParams> rpcps = new ArrayList<ResolvedClassicalPredictionCoreParams>();
            for (FullModelId fmi : fmis) {
                rppps.add(fmi.parsePreprocessingFile("rpreprocessing_params.json", ResolvedClassicalPredictionPreprocessingParams.class));
                rpmps.add(fmi.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class));
                rpcps.add((ResolvedClassicalPredictionCoreParams)fmi.getResolvedCoreParams());
            }
            EnsembleCheck ec = PredictionService.checkEnsemblability(fmis, rppps, rpmps, rpcps);
            if (!ec.canEnsemble()) {
                throw new IllegalArgumentException("Can't ensemble because " + ec.cannotEnsembleReason);
            }
            if (!ec.okForMethod(method)) {
                throw new IllegalArgumentException("Illegal ensembling method.");
            }
            String sessionId = this.mlBaseService.getNextSessionIdAndCreateSessionFolder(loc);
            File sessionFolder = MLPaths.sessionFolder(loc, sessionId);
            ResolvedClassicalPredictionCoreParams coreParams = fmis.get(0).parseSessionFile("core_params.json", ResolvedClassicalPredictionCoreParams.class);
            coreParams.diagnosticsSettings = task.diagnosticsSettings;
            JSON.prettyToFile((Object)coreParams, (File)new File(sessionFolder, "core_params.json"));
            JSON.prettyToFile((Object)task, (File)new File(sessionFolder, "mltask.json"));
            FileUtils.copyFile((File)fmis.get(0).getSessionFile("script.json"), (File)new File(sessionFolder, "script.json"));
            FileUtils.copyFile((File)fmis.get(0).getSessionFile("split_ref.json"), (File)new File(sessionFolder, "split_ref.json"));
            File inputDatasetSchemaFile = fmis.get(0).getSessionFile("input_dataset_schema.json");
            if (inputDatasetSchemaFile.exists()) {
                FileUtils.copyFile((File)inputDatasetSchemaFile, (File)new File(sessionFolder, "input_dataset_schema.json"));
            }
            AnalysisWorkSetPreparator prep = new AnalysisWorkSetPreparator(MLTask.MLTaskType.PREDICTION, loc, sessionId, EvaluationLabelsHelper.getTrainTimeLabels(loc, task, acp));
            WorkSet ws = new WorkSet(sessionId);
            WorkSet.PreprocessingSet ps2 = new WorkSet.PreprocessingSet(PredictionService.ensemblePreprocessingParams(rppps), "dummy prep for ensemble");
            PreTrainPredictionModelingParams rpmp = new PreTrainPredictionModelingParams();
            rpmp.algorithm = task.backendType == MLTask.BackendType.PY_MEMORY ? PreTrainPredictionModelingParams.Algorithm.PYTHON_ENSEMBLE : PreTrainPredictionModelingParams.Algorithm.SPARK_ENSEMBLE;
            rpmp.ensemble_params = PredictionService.createEnsembleParams(task.predictionType, fmis, method, rppps, rpmps);
            rpmp.metrics = task.modeling.metrics;
            rpmp.autoOptimizeThreshold = true;
            ps2.modelingSets = Lists.newArrayList((Object[])new WorkSet.ModelingSet[]{new WorkSet.ModelingSet(rpmp)});
            ws.preprocessingSets = Lists.newArrayList((Object[])new WorkSet.PreprocessingSet[]{ps2});
            logger.info((Object)"Preparing workset for ensembling");
            prep.prepare(ws);
            FullModelId fmi = new FullModelId(loc, sessionId, ps2.preprocessingId, ps2.modelingSets.get((int)0).modelId);
            FilesystemACLUtils.grantFSReadACLs(auth, fmi.getProjectKey(), fmi.getFolderEnsuringSecurity());
            EnsembleHandler.EnsembleWorkThread thread = new EnsembleHandler.EnsembleWorkThread((DSSAuthCtx)auth, loc, acp, ws, fmi, fmis);
            this.mlBaseService.setWorking(loc, thread);
            thread.init();
            this.futureService.runFuture(thread, 0L, new TypeToken<FutureResponse<Void>>(){});
            ArrayList<String> ensemblePreprocessingFileNames = new ArrayList<String>();
            for (File f : fmi.getPreprocessingFolder().listFiles()) {
                if (!f.isFile()) continue;
                ensemblePreprocessingFileNames.add(f.getName());
            }
            for (FullModelId fmiInputModel : fmis) {
                for (File f : fmiInputModel.getPreprocessingFolder().listFiles()) {
                    if (!f.isFile() || !com.dataiku.dip.utils.StringUtils.endsWithAny((String)f.getName(), (String[])new String[]{".json", ".pkl", ".pkl.gz"}) || ensemblePreprocessingFileNames.contains(f.getName())) continue;
                    File fEnsemble = fmi.getPreprocessingFile(f.getName());
                    if (!fEnsemble.exists()) {
                        FileUtils.copyFileToDirectory((File)f, (File)fmi.getPreprocessingFolder());
                        continue;
                    }
                    if (FileUtils.contentEquals((File)f, (File)fEnsemble)) continue;
                    logger.info((Object)("Found preprocessing file " + fEnsemble.getName() + " with different contents in input models. Arbitrarily copied one to the ensemble."));
                }
            }
            FullModelId fullModelId = fmi;
            return fullModelId;
        }
    }

    private static Map<String, FeaturePreprocessingParams> getEnsemblePerFeature(List<ResolvedPredictionPreprocessingParams> rppps) {
        HashMap<String, FeaturePreprocessingParams> perFeature = new HashMap<String, FeaturePreprocessingParams>();
        for (ResolvedPredictionPreprocessingParams rppp : rppps) {
            for (Map.Entry e : rppp.per_feature.entrySet()) {
                String ft = (String)e.getKey();
                FeaturePreprocessingParams current = (FeaturePreprocessingParams)perFeature.get(ft);
                if (current != null && current.role != FeaturePreprocessingParams.Role.REJECT) continue;
                perFeature.put(ft, (FeaturePreprocessingParams)e.getValue());
            }
        }
        return perFeature;
    }

    private static ResolvedPredictionPreprocessingParams ensemblePreprocessingParams(List<ResolvedPredictionPreprocessingParams> rppps) {
        ResolvedClassicalPredictionPreprocessingParams rppp = new ResolvedClassicalPredictionPreprocessingParams();
        rppp.skipPreprocessing = true;
        rppp.per_feature = PredictionService.getEnsemblePerFeature(rppps);
        rppp.reduce = new ResolvedPreprocessingParams.ReductionParams();
        rppp.reduce.enabled = false;
        rppp.target_remapping = rppps.get((int)0).target_remapping;
        return rppp;
    }

    private static EnsembleParams createEnsembleParams(PredictionMLTask.PredictionType predictionType, List<FullModelId> fmis, EnsembleParams.EnsembleMethod method, List<ResolvedPredictionPreprocessingParams> rppps, List<PreTrainPredictionModelingParams> rpmps) throws Exception {
        boolean probaInputs;
        EnsembleParams par = new EnsembleParams();
        par.method = method;
        par.model_ids = new ArrayList<String>();
        par.modeling_params = new ArrayList<PreTrainPredictionModelingParams>();
        par.modeling_params = rpmps;
        for (FullModelId fmi : fmis) {
            par.model_ids.add(fmi.toString());
        }
        par.preprocessing_hashes = PredictionService.preparePreprocessingHashes(fmis, rppps);
        HashSet<String> uniqueHashes = new HashSet<String>();
        ArrayList<String> orderedHashes = new ArrayList<String>();
        ArrayList<ResolvedClassicalPredictionPreprocessingParams> preps = new ArrayList<ResolvedClassicalPredictionPreprocessingParams>();
        for (Map.Entry<String, String> entry : par.preprocessing_hashes.entrySet()) {
            String fmi = entry.getKey();
            String hash = entry.getValue();
            if (uniqueHashes.contains(hash)) continue;
            uniqueHashes.add(hash);
            orderedHashes.add(hash);
            preps.add((ResolvedClassicalPredictionPreprocessingParams)JSON.parseFile((File)FullModelId.parse(fmi).getPreprocessingFile("rpreprocessing_params.json"), ResolvedClassicalPredictionPreprocessingParams.class));
        }
        par.preprocessing_params = preps;
        par.ordered_hashes = orderedHashes;
        block0 : switch (predictionType) {
            case REGRESSION: {
                probaInputs = false;
                break;
            }
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                if (method == EnsembleParams.EnsembleMethod.VOTE) {
                    probaInputs = false;
                    break;
                }
                probaInputs = true;
                for (PreTrainPredictionModelingParams rpmp : rpmps) {
                    if (rpmp.hasProbabilities()) continue;
                    probaInputs = false;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionType));
            }
        }
        par.proba_inputs = probaInputs;
        if (par.proba_inputs && predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) {
            double[] dArray = new double[fmis.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = fmis.get((int)i).parseModelFile((String)"perf.json", BinaryClassificationModelPerf.class).usedThreshold;
            }
            par.thresholds = dArray;
        }
        return par;
    }

    private static Map<String, String> preparePreprocessingHashes(List<FullModelId> fmis, List<ResolvedPredictionPreprocessingParams> rppps) throws Exception {
        HashMap<String, String> hashes = new HashMap<String, String>();
        for (int i = 0; i < fmis.size(); ++i) {
            int hash = JSON.json((Object)rppps.get(i)).hashCode();
            hashes.put(fmis.get(i).toString(), Integer.toString(hash));
        }
        return hashes;
    }

    public EnsembleCheck createEmptyEnsembleCheckWithReason(String cannotEnsembleReason) {
        EnsembleCheck check = new EnsembleCheck();
        check.availableMethods = new ArrayList<EnsembleCheck.EnsembleMethodDescription>();
        check.cannotEnsembleReason = cannotEnsembleReason;
        return check;
    }

    public EnsembleCheck checkEnsemblability(List<FullModelId> fmis) throws Exception {
        ArrayList<ResolvedPredictionPreprocessingParams> rppps = new ArrayList<ResolvedPredictionPreprocessingParams>();
        ArrayList<PreTrainPredictionModelingParams> rpmps = new ArrayList<PreTrainPredictionModelingParams>();
        ArrayList<ResolvedClassicalPredictionCoreParams> rpcps = new ArrayList<ResolvedClassicalPredictionCoreParams>();
        for (FullModelId fmi : fmis) {
            ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
            if (rcp instanceof ResolvedClassicalPredictionCoreParams && StringUtils.isNotBlank((String)((ResolvedClassicalPredictionCoreParams)rcp).managedFolderSmartId)) {
                return this.createEmptyEnsembleCheckWithReason("you cannot ensemble models using data from a managed folder (e.g. images)");
            }
            if (rcp instanceof ResolvedTimeseriesForecastingCoreParams) {
                return this.createEmptyEnsembleCheckWithReason("you cannot ensemble time series forecasting models");
            }
            if (rcp instanceof ResolvedDeepHubPredictionCoreParams) {
                return this.createEmptyEnsembleCheckWithReason("you cannot ensemble deephub prediction models");
            }
            if (rcp.backendType.equals((Object)MLTask.BackendType.KERAS)) {
                return this.createEmptyEnsembleCheckWithReason("you cannot ensemble deep learning models");
            }
            assert (rcp instanceof ResolvedClassicalPredictionCoreParams);
            rpcps.add((ResolvedClassicalPredictionCoreParams)rcp);
            rppps.add(fmi.parsePreprocessingFile("rpreprocessing_params.json", ResolvedClassicalPredictionPreprocessingParams.class));
            rpmps.add(fmi.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class));
        }
        return PredictionService.checkEnsemblability(fmis, rppps, rpmps, rpcps);
    }

    private static EnsembleCheck checkEnsemblability(List<FullModelId> modelIds, List<ResolvedPredictionPreprocessingParams> rppps, List<PreTrainPredictionModelingParams> rpmps, List<ResolvedClassicalPredictionCoreParams> rpcps) throws Exception {
        EnsembleCheck check = new EnsembleCheck();
        check.availableMethods = new ArrayList<EnsembleCheck.EnsembleMethodDescription>();
        String splitInstanceId = null;
        for (FullModelId fmi : modelIds) {
            String splitRefPath = fmi.getSessionFile("split_ref.json").getAbsolutePath();
            String sref = ((SplitDesc.SplitRef)JSON.parseFile((String)splitRefPath, SplitDesc.SplitRef.class)).splitInstanceId;
            if (splitInstanceId == null) {
                splitInstanceId = sref;
            } else if (!splitInstanceId.equals(sref)) {
                check.cannotEnsembleReason = "you cannot ensemble models trained with different scripts or train/test splits";
            }
            SplitDesc splitDesc = ResultsReaderBase.readSplitDesc(fmi);
            if (splitDesc.params.kfold) {
                check.cannotEnsembleReason = "ensembling models trained with KFold cross test is not supported";
            }
            if (fmi.isPartitionedBaseModel() || fmi.isModelPartition()) {
                check.cannotEnsembleReason = "ensembling partitioned models is not supported";
            }
            if (!fmi.getOverridesFile().isFile() || !fmi.getOverridesParams().hasOverrides()) continue;
            check.cannotEnsembleReason = "ensembling models with overrides is not supported";
        }
        PredictionMLTask task = (PredictionMLTask)modelIds.get(0).getHeadMLTask();
        HashMap<String, Boolean> dropMissing = new HashMap<String, Boolean>();
        HashMap<String, FeaturePreprocessingParams.FeatureType> typeMap = new HashMap<String, FeaturePreprocessingParams.FeatureType>();
        for (ResolvedPredictionPreprocessingParams rppp : rppps) {
            for (Map.Entry entry : rppp.per_feature.entrySet()) {
                boolean drop;
                FeaturePreprocessingParams par = (FeaturePreprocessingParams)entry.getValue();
                if (par instanceof NumFeaturePreprocessingParams) {
                    boolean bl = drop = ((NumFeaturePreprocessingParams)par).missing_handling == NumFeaturePreprocessingParams.MissingHandlingMethod.DROP_ROW;
                    if (((NumFeaturePreprocessingParams)par).missing_handling == NumFeaturePreprocessingParams.MissingHandlingMethod.KEEP_NAN_OR_DROP) {
                        check.cannotEnsembleReason = "ensembling models that handle a numerical feature with \"Keep empty | Drop rows for incompatible algorithms\" is not supported";
                        return check;
                    }
                } else if (par instanceof CatFeaturePreprocessingParams) {
                    drop = ((CatFeaturePreprocessingParams)par).missing_handling == CatFeaturePreprocessingParams.MissingHandlingMethod.DROP_ROW;
                } else if (par instanceof TextFeaturePreprocessingParams) {
                    drop = false;
                } else {
                    String unsupportedFeature = par instanceof VectorFeaturePreprocessingParams ? "a vector feature" : (par instanceof ImageFeaturePreprocessingParams ? "an image feature" : "a feature of an unrecognized type");
                    check.cannotEnsembleReason = "you cannot ensemble models using " + unsupportedFeature;
                    return check;
                }
                if (!dropMissing.containsKey(entry.getKey())) {
                    dropMissing.put((String)entry.getKey(), drop);
                } else if ((Boolean)dropMissing.get(entry.getKey()) != drop) {
                    check.cannotEnsembleReason = "you cannot ensemble models which handle the same feature by dropping and not dropping corresponding rows";
                }
                FeaturePreprocessingParams.FeatureType type = ((FeaturePreprocessingParams)entry.getValue()).type;
                if (!typeMap.containsKey(entry.getKey())) {
                    typeMap.put((String)entry.getKey(), type);
                    continue;
                }
                if (((FeaturePreprocessingParams.FeatureType)((Object)typeMap.get(entry.getKey()))).equals((Object)type)) continue;
                check.cannotEnsembleReason = "you cannot ensemble models which treat the same feature as a different type (numeric, categorical, text)";
            }
        }
        WeightParams wp = null;
        TimeOrderingParams time = null;
        for (ResolvedClassicalPredictionCoreParams resolvedClassicalPredictionCoreParams : rpcps) {
            if (wp == null) {
                wp = resolvedClassicalPredictionCoreParams.weight;
            } else if (wp.weightMethod != resolvedClassicalPredictionCoreParams.weight.weightMethod || !StringUtils.equals((String)wp.sampleWeightVariable, (String)resolvedClassicalPredictionCoreParams.weight.sampleWeightVariable)) {
                check.cannotEnsembleReason = "you cannot ensemble models which have different sample weights parameters";
            }
            if (time == null) {
                time = resolvedClassicalPredictionCoreParams.time;
            } else if (!Objects.equals(time, resolvedClassicalPredictionCoreParams.time)) {
                check.cannotEnsembleReason = "you cannot ensemble models which have different time ordering parameters";
            }
            if (!resolvedClassicalPredictionCoreParams.uncertainty.isPredictionIntervalEnabled()) continue;
            check.cannotEnsembleReason = "ensembling models with uncertainty is not supported";
        }
        if (check.canEnsemble()) {
            check.availableMethods = PredictionService.generateMethodDescriptions(task.predictionType, rpmps);
        }
        return check;
    }

    private static List<EnsembleCheck.EnsembleMethodDescription> generateMethodDescriptions(PredictionMLTask.PredictionType predictionType, List<PreTrainPredictionModelingParams> rpmps) {
        ArrayList<EnsembleCheck.EnsembleMethodDescription> availableMethods = new ArrayList<EnsembleCheck.EnsembleMethodDescription>();
        switch (predictionType) {
            case BINARY_CLASSIFICATION: 
            case MULTICLASS: {
                boolean canAverage = true;
                for (PreTrainPredictionModelingParams rpmp : rpmps) {
                    if (rpmp.hasProbabilities()) continue;
                    canAverage = false;
                    break;
                }
                if (canAverage) {
                    availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.PROBA_AVERAGE));
                }
                availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.VOTE));
                availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.LOGISTIC_MODEL));
                break;
            }
            case REGRESSION: {
                availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.AVERAGE));
                availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.MEDIAN));
                availableMethods.add(new EnsembleCheck.EnsembleMethodDescription(EnsembleParams.EnsembleMethod.LINEAR_MODEL));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)predictionType));
            }
        }
        return availableMethods;
    }

    public void checkSourceDatasetPermissions(AuthCtx authCtx, AnalysisCoreParams acp, MLTaskLoc loc) throws IOException, DKUSecurityException {
        PredictionMLTask task = this.crudService.getPMLTask(loc);
        Preconditions.checkNotNull((Object)task.splitParams, (Object)"Invalid ML task: no split params");
        Preconditions.checkNotNull((Object)((Object)task.splitParams.ttPolicy), (Object)"Invalid ML task: no train/test split policy");
        switch (task.splitParams.ttPolicy) {
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                String ref = task.splitParams.efsdDatasetSmartName == null ? acp.inputDatasetSmartName : task.splitParams.efsdDatasetSmartName;
                AnyLoc dsLoc = AnyLoc.resolveSmart(loc.analysisProjectKey, ref);
                this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, dsLoc);
                break;
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                String trainRef = task.splitParams.eftdTrain.datasetSmartName == null ? acp.inputDatasetSmartName : task.splitParams.eftdTrain.datasetSmartName;
                AnyLoc trainLoc = AnyLoc.resolveSmart(loc.analysisProjectKey, trainRef);
                this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, trainLoc);
                String testRef = task.splitParams.eftdTest.datasetSmartName == null ? acp.inputDatasetSmartName : task.splitParams.eftdTest.datasetSmartName;
                AnyLoc testLoc = AnyLoc.resolveSmart(loc.analysisProjectKey, testRef);
                this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, testLoc);
                break;
            }
            case SPLIT_SINGLE_DATASET: {
                String ref = task.splitParams.ssdDatasetSmartName == null ? acp.inputDatasetSmartName : task.splitParams.ssdDatasetSmartName;
                AnyLoc dsLoc = AnyLoc.resolveSmart(loc.analysisProjectKey, ref);
                this.projectsService.checkDatasetReadAccessRegardlessOfContext(authCtx, dsLoc);
                break;
            }
        }
    }

    public static void assertFeaturesInModelPerFeature(ModelLikeId mle, List<String> features, PredictionPostComputationHandler.PostComputationCommand cmd) throws IOException, CodedException {
        Map<String, FeaturePreprocessingParams> featuresMap = mle.getFeatures();
        Set<String> modelFeatures = featuresMap.keySet();
        for (String feature : features) {
            if (!modelFeatures.contains(feature)) {
                throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_POSTTRAIN_CONFIG, "Cannot run posttrain computation on unknown feature '" + feature + "'");
            }
            FeaturePreprocessingParams featurePreprocessingParams = featuresMap.get(feature);
            if (!cmd.containsAuthorizedFeatureRoles(featurePreprocessingParams.role)) {
                throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_POSTTRAIN_CONFIG, "Cannot run posttrain computation on feature '" + feature + "' with role '" + String.valueOf((Object)featurePreprocessingParams.role) + "'");
            }
            if (cmd.containsAuthorizedFeatureTypes(featurePreprocessingParams.type)) continue;
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_INVALID_POSTTRAIN_CONFIG, "Cannot run posttrain computation on feature '" + feature + "' with type '" + String.valueOf((Object)featurePreprocessingParams.type) + "'");
        }
    }

    public FutureResponse<?> subpopulationComputationStart(DSSAuthCtx user, FullModelId fmi, List<String> features, JsonObject computationParams, boolean computePerformanceMetrics) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        PredictionService.assertFeaturesInModelPerFeature(fmi, features, PredictionPostComputationHandler.PostComputationCommand.SUBPOPULATION);
        computationParams.add("features_to_compute", (JsonElement)JSON.toJsonArray(features));
        Params dipProperties = ApplicationConfigurator.getParams();
        int maxModalities = dipProperties.getIntParam("dku.ml.postTraining.subpopulation.maxModalities", Integer.valueOf(10));
        computationParams.addProperty("max_modalities", (Number)maxModalities);
        PredictionPostComputationHandler.PostComputationCommand.SUBPOPULATION.checkCompatible(fmi);
        PredictionPostComputationHandler.SubpopulationPTCWorkThread thread = new PredictionPostComputationHandler.SubpopulationPTCWorkThread(user, fmi, features, computationParams, computePerformanceMetrics);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<?> pdpComputationStart(DSSAuthCtx user, ModelLikeId mle, List<String> features, JsonObject computationParams) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        FullModelId fmi = mle.getUnderlyingModel();
        PredictionService.assertFeaturesInModelPerFeature(fmi, features, PredictionPostComputationHandler.PostComputationCommand.PDP);
        computationParams.add("features_to_compute", (JsonElement)JSON.toJsonArray(features));
        PredictionPostComputationHandler.PostComputationCommand.PDP.checkCompatible(fmi);
        PredictionPostComputationHandler.PartialDependenciesPTCworkThread thread = new PredictionPostComputationHandler.PartialDependenciesPTCworkThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<PredictionResultsReader.LearningCurveResults<?>> learningCurvesComputationStart(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) throws Exception {
        PredictionPostComputationHandler.LearningCurvePTCWorkThread thread = new PredictionPostComputationHandler.LearningCurvePTCWorkThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<?> globalExplanationsComputationStart(DSSAuthCtx user, ModelLikeId mle) throws Exception {
        PredictionPostComputationHandler.PostComputationCommand.GLOBAL_EXPLANATIONS.checkCompatible(mle.getUnderlyingModel());
        PredictionPostComputationHandler.GlobalExplanationsPTCWorkThread thread = new PredictionPostComputationHandler.GlobalExplanationsPTCWorkThread(user, mle);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<?> individualExplanationsComputationStart(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        PredictionPostComputationHandler.PostComputationCommand.INDIVIDUAL_EXPLANATIONS.checkCompatible(mle.getUnderlyingModel());
        PredictionPostComputationHandler.IndividualExplanationsPTCWorkThread thread = new PredictionPostComputationHandler.IndividualExplanationsPTCWorkThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<TimeseriesPredictionPermutationImportance> permutationImportanceComputationStart(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) throws Exception {
        if (computationParams == null) {
            computationParams = new JsonObject();
        }
        PredictionPostComputationHandler.PostComputationCommand.TIMESERIES_PERMUTATION_IMPORTANCE_COMPUTATION.checkCompatible(mle.getUnderlyingModel());
        PredictionPostComputationHandler.TSPermutationImportanceWorkThread thread = new PredictionPostComputationHandler.TSPermutationImportanceWorkThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<?> retrieveTimeseriesInformationCriteria(DSSAuthCtx user, ModelLikeId mle) throws Exception {
        PredictionPostComputationHandler.PostComputationCommand.INFORMATION_CRITERIA.checkCompatible(mle.getUnderlyingModel());
        PredictionPostComputationHandler.TimeseriesInformationCriteriaWorkThread thread = new PredictionPostComputationHandler.TimeseriesInformationCriteriaWorkThread(user, mle);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<Map<String, TimeseriesResiduals>> computePerTimeseriesResiduals(DSSAuthCtx user, ModelLikeId mle) throws Exception {
        PredictionPostComputationHandler.PostComputationCommand.TIMESERIES_RESIDUALS.checkCompatible(mle.getUnderlyingModel());
        PredictionPostComputationHandler.TimeseriesResidualsWorkThread thread = new PredictionPostComputationHandler.TimeseriesResidualsWorkThread(user, mle);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public OutcomeStats getOutcomeStatsByTreatedState(AuthCtx user, AnalysisCoreParams acp, PredictionMLTask.CausalPredictionMLTask causalTask, String controlValue, boolean dropMissingValues) throws Exception {
        CausalPredictionGuesser guesser = (CausalPredictionGuesser)this.getGuesser(acp, causalTask, user);
        return guesser.getOutcomeStats(controlValue, dropMissingValues);
    }

    public Set<String> getTreatmentColValues(AuthCtx user, AnalysisCoreParams acp, PredictionMLTask.CausalPredictionMLTask causalTask) throws Exception {
        CausalPredictionGuesser guesser = (CausalPredictionGuesser)this.getGuesser(acp, causalTask, user);
        return guesser.getTreatmentColDistribution().keySet();
    }

    private MLTaskHandler<? extends PredictionMLTask> buildMLTaskHandler(AnalysisCoreParams acp, MLTaskLoc taskLoc, PredictionMLTask task, String sessionId, List<FullModelId> fullModelIds, AuthCtx user) {
        ErrorContext.checkNotNull((Object)((Object)task.backendType));
        switch (task.backendType) {
            case MLLIB: 
            case H2O: {
                return new MLLibClassicalPredictionMLTaskHandler(acp, taskLoc, (PredictionMLTask.ClassicalPredictionMLTask)task, sessionId, fullModelIds, user);
            }
            case PY_MEMORY: 
            case KERAS: {
                PredictionMLTaskHandlingStrategy predictionMLTaskHandlingStrategy = task.predictionType == PredictionMLTask.PredictionType.TIMESERIES_FORECAST ? new TimeseriesForecastingMLTaskHandlingStrategy() : (task.predictionType == PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION || task.predictionType == PredictionMLTask.PredictionType.CAUSAL_REGRESSION ? new CausalPredictionMLTaskHandlingStrategy() : new ClassicalPredictionMLTaskHandlingStrategy());
                if (task.isPartitioned()) {
                    return new StratifiedPythonPredictionMLTaskHandler(acp, taskLoc, task, predictionMLTaskHandlingStrategy, sessionId, fullModelIds, user);
                }
                return new PythonPredictionMLTaskHandler(acp, taskLoc, task, predictionMLTaskHandlingStrategy, sessionId, fullModelIds, user);
            }
            case DEEP_HUB: {
                return new PythonPredictionMLTaskHandler(acp, taskLoc, task, new DeephubMLTaskHandlingStrategy(), sessionId, null, user);
            }
        }
        throw ErrorContext.iaef((String)"Unsupported prediction ML backend: %s", (Object)((Object)task.backendType), (Object[])new Object[0]);
    }

    class InitialGuessWorkThread
    extends MLBaseService.MLTaskWorkThread {
        final PredictionMLTask task;
        final PredictionMLTask.PredictionType predictionType;

        InitialGuessWorkThread(DSSAuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, @Nullable PredictionMLTask task, PredictionMLTask.PredictionType predictionType) {
            super(user, loc, cp);
            this.task = task;
            this.predictionType = predictionType;
        }

        @Override
        public synchronized List<FullModelId> modelsBeingTrained() {
            return Lists.newArrayList();
        }

        @Override
        public void init() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("IGT-" + this.task.id));){
                logger.info((Object)"Start initial guess");
                try {
                    PredictionGuesser<? extends PredictionMLTask> guesser = PredictionService.this.getGuesser(this.cp, this.task, this.owner);
                    if (this.predictionType != null) {
                        guesser.guessAllSettings(this.predictionType, false);
                    } else {
                        guesser.guessAllSettings(false);
                    }
                    PredictionService.this.selectDefaultCodeEnv_NT(this.owner, this.cp.projectKey, this.task);
                    GuessStatus gs = guesser.checkStatus();
                    try (RWTransaction rw = PredictionService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);){
                        PredictionService.this.crudService.prepareMLTaskCreation(this.loc, this.task, this.owner);
                        PredictionService.this.crudService.saveMLTask(this.loc, this.task, false);
                        rw.commit("Create prediction task for " + this.task.targetVariable + " in " + this.cp.projectKey + "." + this.cp.id + "(" + this.cp.name + ")");
                    }
                    this.loc.writeGuessStatus(gs);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to guess", (Throwable)e);
                    PredictionService.this.mlBaseService.setNotWorking(this.loc);
                    GuessStatus gs = new GuessStatus();
                    gs.state = GuessStatus.GuessState.BROKEN;
                    gs.error = new APIError((Throwable)e, true);
                    this.loc.writeGuessStatus(gs);
                }
                finally {
                    PredictionService.this.mlBaseService.removeGuessing(this.loc);
                }
                logger.info((Object)"Done initial guess");
            }
        }

        @Override
        public FuturePayload buildFuturePayload(MLTaskLoc loc, AnalysisCoreParams cp) {
            return MLBaseService.buildBaseFuturePayload(loc, "Guessing prediction training parameters", "guess", "prediction");
        }

        public Void getResult() {
            return null;
        }

        @Override
        public List<Integer> getPids() {
            return null;
        }
    }

    class TrainWorkThread
    extends MLBaseService.MLTaskWorkThread {
        final PredictionMLTask task;
        final String userSessionName;
        final String userSessionDescription;
        String initiator;
        MLTaskHandler<? extends PredictionMLTask> trainHandler;
        String sessionId;

        TrainWorkThread(DSSAuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, PredictionMLTask task, String sessionId, String userSessionName, String userSessionDescription) {
            super(user, loc, cp);
            this.task = task;
            this.userSessionName = userSessionName;
            this.userSessionDescription = userSessionDescription;
            this.sessionId = sessionId;
        }

        @Override
        public synchronized List<FullModelId> modelsBeingTrained() {
            if (this.trainHandler != null) {
                return this.trainHandler.getTrainedModelIds();
            }
            return Lists.newArrayList();
        }

        @Override
        public synchronized Map<FullModelId, ContainerUsageMetrics> getContainerUsageMetricsPerModel() {
            if (this.trainHandler == null) {
                return new HashMap<FullModelId, ContainerUsageMetrics>();
            }
            return this.trainHandler.getContainerUsageMetricsPerModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws Exception {
            try {
                PredictionService.this.mlBaseService.startLogAppender();
                if (this.sessionId == null) {
                    this.sessionId = PredictionService.this.mlBaseService.getNextSessionIdAndCreateSessionFolder(this.loc);
                }
                MLTaskHandler<? extends PredictionMLTask> tmpTrainHandler = PredictionService.this.buildMLTaskHandler(this.cp, this.loc, this.task, this.sessionId, Collections.emptyList(), this.owner);
                AnalysisWorkSetPreparator preparator = new AnalysisWorkSetPreparator(MLTask.MLTaskType.PREDICTION, this.loc, this.sessionId, this.userSessionName, this.userSessionDescription, EvaluationLabelsHelper.getTrainTimeLabels(this.loc, this.task, this.cp));
                tmpTrainHandler.init(preparator);
                try (Transaction t = PredictionService.this.transactionService.beginRead();){
                    SerializedDataset dataset = (SerializedDataset)PredictionService.this.datasetsDAO.getMandatory(AnyLoc.resolveSmart(this.cp.projectKey, this.cp.inputDatasetSmartName));
                    JSON.prettyToFile((Object)dataset.getSchema(), (File)new File(MLPaths.sessionFolder(this.loc, this.sessionId), "input_dataset_schema.json"));
                }
                TrainWorkThread trainWorkThread = this;
                synchronized (trainWorkThread) {
                    this.trainHandler = tmpTrainHandler;
                }
            }
            catch (Exception e) {
                PredictionService.this.mlBaseService.setNotWorking(this.loc);
                PredictionService.this.mlBaseService.setQueueState(this.loc, false);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeProcess() {
            try (ErrorContext.ACNDC acndc = ErrorContext.pushWithNDC((String)("T-" + this.task.id));){
                try (FutureAborter.AutoCloseableAbortHook aborting = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        assert (TrainWorkThread.this.trainHandler != null);
                        logger.info((Object)"Abort training thread");
                        TrainWorkThread.this.trainHandler.abort();
                    }
                });){
                    PredictionService.this.pubSub.publish(new MLTaskStateChangedEvent(this.task, this.cp.projectKey, this.cp.id, this.sessionId, this.cp.inputDatasetSmartName, true, this.initiator, null));
                    this.trainHandler.train();
                    logger.info((Object)"Train done");
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedException)) {
                        PredictionService.this.mlBaseService.setQueueState(this.loc, false);
                    }
                    logger.error((Object)"Failed to train", (Throwable)e);
                }
                finally {
                    PredictionService.this.mlBaseService.setNotWorking(this.loc);
                    try {
                        FileUtils.touch((File)new File(this.loc.getSessionFolder(this.sessionId), "done.txt"));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to mark session as complete", (Throwable)e);
                    }
                    PredictionService.this.trainingSessionDetailsService.publishPredictionSession(this.loc, this.sessionId, this.initiator, this.cp, this.task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            mlTaskContext.set(new MLBaseService.MLTaskWorkThread.MLTaskContext(this.trainHandler.getTrainedModelIds()));
            logger.info((Object)"******************************************");
            logger.info((Object)("** Start train session " + this.sessionId));
            logger.info((Object)"******************************************");
            DSSMetrics.registry().counter("dku.ml.predictionTrain.training").inc();
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.ml.predictionTrain.trainSession");){
                this.executeProcess();
            }
            finally {
                DSSMetrics.registry().counter("dku.ml.predictionTrain.training").dec();
            }
        }

        @Override
        public void abort(List<FullModelId> fullModelIdSet) throws IOException {
            this.trainHandler.abort(fullModelIdSet);
        }

        @Override
        public FuturePayload buildFuturePayload(MLTaskLoc loc, AnalysisCoreParams cp) {
            return MLBaseService.buildBaseFuturePayload(loc, "Training prediction model", "train", "prediction");
        }

        public Void getResult() {
            return null;
        }

        @Override
        public List<Integer> getPids() {
            return this.trainHandler != null ? this.trainHandler.getKernelPids() : null;
        }
    }

    class ReTrainWorkThread
    extends TrainWorkThread {
        final List<FullModelId> fullModelIds;

        ReTrainWorkThread(AuthCtx user, MLTaskLoc loc, AnalysisCoreParams cp, PredictionMLTask task, String sessionId, List<FullModelId> fullModelIds) {
            super((DSSAuthCtx)user, loc, cp, task, sessionId, null, null);
            this.fullModelIds = fullModelIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws Exception {
            try {
                PredictionService.this.mlBaseService.startLogAppender();
                MLTaskHandler<? extends PredictionMLTask> tempTrainHandler = PredictionService.this.buildMLTaskHandler(this.cp, this.loc, this.task, this.sessionId, this.fullModelIds, this.owner);
                AnalysisRetrainWorkSetPreparator preparator = new AnalysisRetrainWorkSetPreparator(MLTask.MLTaskType.PREDICTION, this.loc, this.sessionId, EvaluationLabelsHelper.getTrainTimeLabels(this.loc, this.task, this.cp));
                tempTrainHandler.init(preparator);
                ReTrainWorkThread reTrainWorkThread = this;
                synchronized (reTrainWorkThread) {
                    this.trainHandler = tempTrainHandler;
                }
            }
            catch (Exception e) {
                PredictionService.this.mlBaseService.setNotWorking(this.loc);
                throw e;
            }
        }

        @Override
        public void execute() {
            if (!this.fullModelIds.isEmpty()) {
                mlTaskContext.set(new MLBaseService.MLTaskWorkThread.MLTaskContext(this.fullModelIds));
            } else {
                mlTaskContext.set(new MLBaseService.MLTaskWorkThread.MLTaskContext(this.trainHandler.getTrainedModelIds()));
            }
            logger.info((Object)"******************************************");
            logger.info((Object)("** Start retraining session " + this.sessionId));
            logger.info((Object)"******************************************");
            this.executeProcess();
        }
    }

    public static class EnsembleCheck {
        public List<EnsembleMethodDescription> availableMethods;
        public String cannotEnsembleReason;

        public boolean canEnsemble() {
            return StringUtils.isBlank((String)this.cannotEnsembleReason);
        }

        public boolean okForMethod(EnsembleParams.EnsembleMethod method) {
            for (EnsembleMethodDescription emd : this.availableMethods) {
                if (emd.method != method) continue;
                return true;
            }
            return false;
        }

        public static class EnsembleMethodDescription {
            public EnsembleParams.EnsembleMethod method;
            public String name;
            public String description;

            public EnsembleMethodDescription(EnsembleParams.EnsembleMethod method) {
                this.method = method;
                this.name = method.methodName;
                this.description = method.description;
            }
        }
    }

    public static class NotebookToSave {
        public String transmogrifiedTitle;
        public RelFile newNotebookFile;
        public String jsonContent;
    }
}

