/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.GenericMultiTimeseriesExtractor;
import com.dataiku.dip.analysis.docgen.transform.Placeholder;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeseriesArimaOrdersMultiExtractor
extends GenericMultiTimeseriesExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        boolean isSeasonalAutoARIMA;
        this.assertModelIsSupported(model, Arrays.asList(PreTrainPredictionModelingParams.Algorithm.AUTO_ARIMA));
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        if (timeseriesModelDetails.getCoreParams().timeseriesIdentifiers.size() == 0) {
            throw new IOException(String.format("Wrong placeholder. Extractor '%s' does not support single time series. Use {{%s}} instead.", this.getClass().getSimpleName(), Placeholder.RESULT_AUTOARIMA_ORDERS_SINGLE_TABLE.placeholderName));
        }
        PostTrainPredictionModelingParams.AutoArimaParams autoArimaParams = ((PostTrainPredictionModelingParams)model.actualParams.resolved).auto_arima_timeseries_params;
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        if (autoArimaParams.p.isEmpty()) {
            return output;
        }
        List<String> headerRow = this.extractHeadersFromMap(autoArimaParams.p);
        headerRow.add("p");
        headerRow.add("q");
        if (!autoArimaParams.stationary) {
            headerRow.add("d");
        }
        boolean bl = isSeasonalAutoARIMA = autoArimaParams.m > 1L;
        if (isSeasonalAutoARIMA) {
            headerRow.add("P");
            headerRow.add("Q");
            if (!autoArimaParams.stationary) {
                headerRow.add("D");
            }
        }
        output.add(headerRow);
        for (String timeseriesIdentifierString : autoArimaParams.p.keySet()) {
            ArrayList<String> row = new ArrayList<String>();
            JsonObject tsIdentifiers = (JsonObject)JSON.parse((String)timeseriesIdentifierString, JsonObject.class);
            for (String identifier : tsIdentifiers.keySet()) {
                row.add(tsIdentifiers.get(identifier).getAsString());
            }
            row.add(String.valueOf(autoArimaParams.p.get(timeseriesIdentifierString)));
            row.add(String.valueOf(autoArimaParams.q.get(timeseriesIdentifierString)));
            if (!autoArimaParams.stationary) {
                row.add(String.valueOf(autoArimaParams.d.get(timeseriesIdentifierString)));
            }
            if (isSeasonalAutoARIMA) {
                row.add(String.valueOf(autoArimaParams.P.get(timeseriesIdentifierString)));
                row.add(String.valueOf(autoArimaParams.Q.get(timeseriesIdentifierString)));
                if (!autoArimaParams.stationary) {
                    row.add(String.valueOf(autoArimaParams.D.get(timeseriesIdentifierString)));
                }
            }
            output.add(row);
        }
        return output;
    }
}

