/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.extractor.TimeseriesExternalFeaturesExtractor;
import com.dataiku.dip.analysis.docgen.extractor.TimeseriesIdentifiersExtractor;
import com.dataiku.dip.analysis.docgen.extractor.TimeseriesNumExternalFeaturesExtractor;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeseriesGeneralSettingsTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        output.add(Arrays.asList("Target variable", timeseriesModelDetails.coreParams.target_variable));
        output.add(Arrays.asList("Time variable", timeseriesModelDetails.coreParams.timeVariable));
        FullModelId fmi = FullModelId.parse(timeseriesModelDetails.fullModelId);
        if (fmi.isPartitionedBaseModel()) {
            output.add(Arrays.asList("Number of time series per partition", ""));
            for (String partitionName : fmi.listTrainedPartitions()) {
                FullModelId partition_fmi = fmi.getModelPartition(partitionName);
                output.add(Arrays.asList("Partition: " + partitionName, partition_fmi.getTimeseriesForecastingPerf((boolean)true).perTimeseriesMetrics.size() + " time series"));
            }
        } else {
            TimeseriesForecastingModelPerf fullPerf = fmi.getTimeseriesForecastingPerf(true);
            output.add(Arrays.asList("Number of time series", Integer.toString(fullPerf.perTimeseriesMetrics.size())));
        }
        if (timeseriesModelDetails.coreParams.timeseriesIdentifiers.size() > 0) {
            output.add(Arrays.asList("Time series identifiers", new TimeseriesIdentifiersExtractor().extract(documentContext, model)));
        }
        String numExternalFeatures = new TimeseriesNumExternalFeaturesExtractor().extract(documentContext, model);
        output.add(Arrays.asList("Number of external features", numExternalFeatures));
        if (Integer.parseInt(numExternalFeatures) > 0) {
            output.add(Arrays.asList("External features", new TimeseriesExternalFeaturesExtractor().extract(documentContext, model)));
        }
        return output;
    }
}

