/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.shared.Guesser;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class IncrementalFeatureGuessHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.analysis.prediction.guess");

    public void update(MemTable table, Map<String, FeaturePreprocessingParams> per_feature, Guesser<?> guesser) {
        HashSet<String> tableColumnNames = new HashSet<String>();
        for (MemColumn column : table.columns.values()) {
            tableColumnNames.add(column.getName());
            String curMeaning = column.selectedType.type.getClass().getSimpleName();
            FeaturePreprocessingParams oldParams = per_feature.get(column.getName());
            if (oldParams == null) {
                FeaturePreprocessingParams newParams = guesser.guessSingleFeature(column);
                newParams.state = new FeaturePreprocessingParams.FeatureState();
                newParams.state.recordedMeaning = curMeaning;
                per_feature.put(column.getName(), newParams);
                continue;
            }
            String previousMeaning = oldParams.state == null ? null : oldParams.state.recordedMeaning;
            logger.debugV("Feature %s existed with meaning %s (user-mod=%s)", new Object[]{column.getName(), previousMeaning, oldParams.state != null && oldParams.state.userModified});
            if ("dss14_migration".equals(previousMeaning)) {
                oldParams.state.recordedMeaning = curMeaning;
                continue;
            }
            if (curMeaning.equals(previousMeaning)) {
                logger.trace((Object)"No change !");
                continue;
            }
            logger.debug((Object)("  Meaning changed from " + previousMeaning + " to " + curMeaning));
            FeaturePreprocessingParams newParams = guesser.guessSingleFeature(column);
            assert (newParams.state == null);
            if (oldParams.state != null && oldParams.state.userModified) {
                oldParams.state.recordedMeaning = curMeaning;
                oldParams.state.dssWantsToSet = newParams;
                continue;
            }
            newParams.state = new FeaturePreprocessingParams.FeatureState();
            newParams.state.recordedMeaning = curMeaning;
            newParams.state.autoModifiedByDSS = true;
            newParams.state.previousSettings = oldParams;
            newParams.state.previousSettings.state = null;
            per_feature.put(column.getName(), newParams);
        }
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String presentInMLTask : per_feature.keySet()) {
            if (tableColumnNames.contains(presentInMLTask)) continue;
            toDelete.add(presentInMLTask);
        }
        for (String td : toDelete) {
            logger.infoV("Removing feature %s, not present in data anymore", new Object[]{td});
            per_feature.remove(td);
        }
    }
}

