/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.spark;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.spark.MLLibAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class SparklingKMeansMeta
extends MLLibAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "KMeans (H2O, k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "k=" + rpmp.k;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.H2OKMeansModelingParams km = task.modeling.h2o_kmeans;
        if (km.enabled) {
            checks.checkAllPositive(km.kValues(), "KMeans requires a positive number of clusters !");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.H2OKMeansModelingParams km = task.modeling.h2o_kmeans;
        if (km.enabled) {
            for (int k : km.kValues()) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.SPARKLING_KMEANS);
                rcmp.k = k;
                rcmp.init = km.init;
                rcmp.seed = km.seed;
                rcmp.max_iterations = km.max_iterations;
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

