/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.badges;

import com.dataiku.dip.badges.TypeBadge;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TypeBadges
extends LinkedHashMap<TypeBadge, LinkedHashSet<String>> {
    static final String TYPE_ML_TAG = "type-ml";
    static final String TYPE_LLM_TAG = "type-llm";
    static final String TYPE_AGENT_TAG = "type-agent";

    @Nonnull
    public List<TypeBadge> list() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entrySet().stream().filter(entry -> !((LinkedHashSet)entry.getValue()).isEmpty()).map(Map.Entry::getKey).toList();
    }

    public void addToContributors(TypeBadge badge, String contributorId) {
        this.computeIfAbsent(badge, k -> new LinkedHashSet()).add(contributorId);
    }

    public void removeFromContributors(TypeBadge badge, String contributorId) {
        this.computeIfPresent(badge, (b, set) -> {
            set.remove(contributorId);
            return set.isEmpty() ? null : set;
        });
    }

    public boolean isContributing(TypeBadge badge, String contributorId) {
        return this.containsKey(badge) && ((LinkedHashSet)this.get(badge)).contains(contributorId);
    }
}

