/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.impl.FilesBasedDatasetsDAO;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.CredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatasetDumpCommand
extends CLICommand {
    private static Logger logger = Logger.getLogger((String)"dku");

    @Override
    public Options opts() {
        Options opts = new Options();
        opts.addOption(null, "header", false, "Print Header");
        opts.addOption("s", "separator", true, "CSV separator (default \t)");
        opts.addOption("d", "delimiter", true, "Alias for -s");
        opts.addOption("l", "limit", true, "Limit the number of rows");
        opts.addOption("c", "columns", true, "Column list");
        opts.addOption(null, "sampling", true, "");
        opts.addOption(null, "style", true, "CSV Style (default UNIX)");
        opts.addOption(null, "charset", true, "Charset (default UTF8)");
        opts.addOption(null, "arrayMapFormat", true, "Format for maps and array. Default JSON");
        opts.addOption(null, "arrayItemSeparator", true, "Separator for array items. Default \\u0002");
        opts.addOption(null, "mapKeySeparator", true, "Separator between key and values in maps. Default \\u0003");
        opts.addOption("p", "partitions", true, "Partition or partition-range to read (multi-valued)");
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public String usageString() {
        return "dku dataset-dump [OPTS] DATASET[=PARTITION]";
    }

    @Override
    public String description() {
        return "Dump a dataset in CSV format";
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "dataset-dump");
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing 'dataset' argument");
        }
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        SpringUtils.getInstance().registerAndAutowire(FilesBasedUsersDAO.class);
        SpringUtils.getInstance().registerAndAutowire(CredentialsService.class);
        SpringUtils.getInstance().registerAndAutowire(FilesBasedDatasetsDAO.class);
        SpringUtils.getInstance().registerAndAutowire(DatasetAccessService.class);
        DKUTransactionService transactionService = new DKUTransactionService();
        try {
            Dataset dataset;
            String dataset_partition = cmdLine.getArgs()[1];
            String[] splits = dataset_partition.split("=", 2);
            String datasetName = splits[0];
            ArrayList<String> partitionSpecs = new ArrayList<String>();
            if (splits.length > 1) {
                partitionSpecs.add(splits[1]);
            }
            if (cmdLine.hasOption('p')) {
                for (String p : cmdLine.getOptionValues('p')) {
                    partitionSpecs.add(p);
                }
            }
            try (Transaction t = transactionService.beginRead();){
                SerializedDataset sd = (SerializedDataset)CLISetup.getDatasetsDAO().getMandatory(DatasetLocUtils.resolveWithEnvDefault(datasetName));
                dataset = Dataset.fromSerialized(sd);
            }
            SamplingParam samplingParam = null;
            if (cmdLine.hasOption("sampling")) {
                String samplingJson = cmdLine.getOptionValue("sampling");
                samplingParam = (SamplingParam)JSON.parse((String)samplingJson, SamplingParam.class);
            } else {
                samplingParam = new SamplingParam();
            }
            if (cmdLine.hasOption("l")) {
                try {
                    long limit = Long.parseLong(cmdLine.getOptionValue("l"));
                    samplingParam.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
                    samplingParam.maxRecords = limit;
                }
                catch (Exception e) {
                    int p = this.usage(1, "Invalid 'limit' argument");
                    transactionService.close();
                    return p;
                }
            }
            CSVFormatConfig csv = new CSVFormatConfig();
            csv.style = CSVFormatConfig.CSVStyle.UNIX;
            csv.charset = "utf8";
            csv.setSeparatorStr("\t");
            csv.setQuoteStr("\"");
            csv.setEscapeStr("\\");
            csv.parseHeaderRow = false;
            csv.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.json;
            csv.arrayItemSeparator = "\u0002";
            csv.mapKeySeparator = "\u0003";
            if (cmdLine.hasOption("separator")) {
                csv.setSeparatorStr(cmdLine.getOptionValue("separator"));
            }
            if (cmdLine.hasOption("style")) {
                csv.style = CSVFormatConfig.CSVStyle.valueOf(cmdLine.getOptionValue("style").toUpperCase());
            }
            if (cmdLine.hasOption("charset")) {
                csv.charset = cmdLine.getOptionValue("charset");
            }
            if (cmdLine.hasOption("arrayMapFormat")) {
                csv.arrayMapFormat = CSVFormatConfig.CSVComplexTypeSerialization.valueOf(cmdLine.getOptionValue("arrayMapFormat"));
            }
            if (cmdLine.hasOption("arrayItemSeparator")) {
                csv.arrayItemSeparator = cmdLine.getOptionValue("arrayItemSeparator");
            }
            if (cmdLine.hasOption("mapKeySeparator")) {
                csv.mapKeySeparator = cmdLine.getOptionValue("mapKeySeparator");
            }
            if (cmdLine.hasOption("header")) {
                csv.parseHeaderRow = true;
            }
            if (cmdLine.hasOption("d")) {
                csv.setSeparatorStr(cmdLine.getOptionValue("d"));
            }
            List<String> columns = null;
            if (cmdLine.hasOption("columns")) {
                String columnsString = cmdLine.getOptionValue("c");
                columns = Arrays.asList(StringUtils.split((String)columnsString, (char)','));
            }
            WarningsContext wc = new WarningsContext();
            StreamColumnFactory cf = new StreamColumnFactory();
            OutputFormatter formatter = FormatFactory.buildFormatter(DSSAuthCtx.newNone(), dataset.getProjectKey(), "csv", csv);
            Schema inputSchema = dataset.getSchema();
            if (inputSchema != null) {
                if (columns != null) {
                    Schema outputSchema = inputSchema.filter(columns);
                    formatter.setOutputSchema(outputSchema);
                } else {
                    formatter.setOutputSchema(inputSchema);
                }
            }
            formatter.setWarningsContext(wc);
            FileOutputStream stdoutStream = new FileOutputStream(FileDescriptor.out);
            OutputStreamOutputWriter osow = new OutputStreamOutputWriter((OutputStream)stdoutStream, formatter);
            osow.init((ColumnFactory)cf);
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher((AuthCtx)DSSAuthCtx.newNone(), dataset, (ProcessorOutput)osow, (ColumnFactory)cf, (RowFactory)new StreamRowFactory());
            StreamableDatasetSelection selection = StreamableDatasetSelection.fromSamplingParam(samplingParam);
            if (partitionSpecs.size() > 0) {
                for (String spec : partitionSpecs) {
                    selection.withSelectedPartitions(PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), spec));
                }
            }
            pusher.setDatasetSelection(selection);
            final InputSplitProgressListener listener = pusher.getListener(new FutureProgressState("dumping dataset", 0));
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        InputSplitProgressListener inputSplitProgressListener = listener;
                        synchronized (inputSplitProgressListener) {
                            System.err.println(" Progress : " + JSON.log((Object)listener));
                        }
                        DKUtils.unsafeSleep((long)200L);
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            pusher.push();
            if (System.getenv("DKU_FLOW") != null) {
                File f = new File("dku_warnings_" + SecretKeyGenerator.generate((int)8));
                JSON.prettyToFile((Object)wc.getOutput(), (File)f);
            }
            osow.lastRowEmitted();
            int n = 0;
            return n;
        }
        finally {
            try {
                transactionService.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }
}

