/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.sql.GreenplumDatasetConfig;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.Greenplum5SQLDialect;
import com.dataiku.dip.sql.GreenplumSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GreenplumConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String connectionType = "Greenplum";
    public Params params = new Params();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public GreenplumSQLDialect getDialect() {
        return StringUtils.isNotBlank((String)this.params.version) && this.params.version.startsWith("5.") ? new Greenplum5SQLDialect() : new GreenplumSQLDialect();
    }

    @Override
    String getDriver() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.driver;
        }
        switch (this.params.driverMode) {
            case MANAGED_LEGACY_POSTGRESQL: 
            case CUSTOM_LEGACY_POSTGRESQL: {
                return "org.postgresql.Driver";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Greenplum connection JDBC URL is not set");
            }
            return this.params.url;
        }
        switch (this.params.driverMode) {
            case MANAGED_LEGACY_POSTGRESQL: 
            case CUSTOM_LEGACY_POSTGRESQL: {
                return "jdbc:postgresql://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED_LEGACY_POSTGRESQL: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-legacy-postgresql"}).getAbsolutePath();
            }
            case CUSTOM_LEGACY_POSTGRESQL: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.encryptCustomFields(cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.decryptCustomFields(cryptoService);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        return new InfoMessage.InfoMessages();
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 5432;
        public GreenplumDriverMode driverMode = GreenplumDriverMode.MANAGED_LEGACY_POSTGRESQL;
        public String driver;
        public String version;
        public GreenplumDatasetConfig.DistributionStrategy defaultDistributionStrategy = GreenplumDatasetConfig.DistributionStrategy.AUTO;
    }

    public static enum GreenplumDriverMode {
        MANAGED_LEGACY_POSTGRESQL,
        CUSTOM_LEGACY_POSTGRESQL;

    }
}

