/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.MySQL8Dialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MySQLConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String connectionType = "MySQL";
    public Params params = new Params();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public MySQLDialect getDialect() {
        return StringUtils.isNotBlank((String)this.params.version) && this.params.version.startsWith("8.") ? new MySQL8Dialect() : new MySQLDialect();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SQLConnectionProvider.SQLConnectionData cd = super.getConnectionData_NT(authCtx, projectKey);
        String zeroDateTimeBehavior = null;
        for (AbstractSQLConnection.CustomDatabaseProperty p : this.params.properties) {
            if (!"zeroDateTimeBehavior".equals(p.name)) continue;
            zeroDateTimeBehavior = p.value;
        }
        if (StringUtils.isBlank(zeroDateTimeBehavior)) {
            zeroDateTimeBehavior = StringUtils.isNotBlank((String)this.params.version) && this.params.version.startsWith("8.") ? "CONVERT_TO_NULL" : "convertToNull";
        }
        cd.withProperty("zeroDateTimeBehavior", zeroDateTimeBehavior);
        cd.withProperty("useInformationSchema", "true");
        cd.withProperty("useServerPrepStmts", "false");
        cd.withProperty("rewriteBatchedStatements", "true");
        cd.withProperty("useOldAliasMetadataBehavior", "true");
        cd.withProperty("useLegacyDatetimeCode", "false");
        return cd;
    }

    @Override
    String getDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"MySQL connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:mysql://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.encryptCustomFields(cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.decryptCustomFields(cryptoService);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        return new InfoMessage.InfoMessages();
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 3306;
        public String version;
    }
}

