/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.util.IsolatedClassLoaderBuilder;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class SQLDriverLoader {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"dku.connections.sql.driver");
    private static final Map<DriverKey, DriverWrapper> wrappedDrivers = new HashMap<DriverKey, DriverWrapper>();

    public static void loadDriver(String driverClass, String jarsDirectory, List<String> fallThroughPackages, List<String> nonFallThroughPackages) throws CodedSQLException {
        if (StringUtils.isNotBlank((String)jarsDirectory)) {
            SQLDriverLoader.retrieveOrRegisterCustomLoaderDriver(driverClass, jarsDirectory, fallThroughPackages, nonFallThroughPackages);
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (Exception e) {
                throw new CodedSQLException(SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, "Failed to load JDBC driver (" + driverClass + ")", (Throwable)e);
            }
        }
    }

    public static Driver getDriverTheRightWay(String jdbcUrl, String driverClass, String jarsDirectory, List<String> fallThroughPackages, List<String> nonFallThroughPackages) throws SQLException {
        block5: {
            if (StringUtils.isNotBlank((String)driverClass) && StringUtils.isNotBlank((String)jarsDirectory)) {
                Driver driver = SQLDriverLoader.retrieveOrRegisterCustomLoaderDriver(driverClass, jarsDirectory, fallThroughPackages, nonFallThroughPackages);
                try {
                    if (!driver.acceptsURL(jdbcUrl)) break block5;
                    try {
                        logger.debug((Object)("Driver version " + driver.getMajorVersion() + "." + driver.getMinorVersion()));
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Failed to get info from driver : " + ex.getMessage()), (Throwable)ex);
                    }
                    return driver;
                }
                catch (SQLException e) {
                    logger.info((Object)String.format("SQL Driver %s issued an exception while testing it against JDBC url: %s", driverClass, jdbcUrl), (Throwable)e);
                }
            }
        }
        return SQLDriverLoader.getDriverTheRightWay(jdbcUrl);
    }

    public static Driver getDriverTheRightWay(String jdbcUrl) throws SQLException {
        if (StringUtils.isBlank((String)jdbcUrl)) {
            logger.warn((Object)"Missing or empty JDBC URL parameter. Make sure it is set in the connection settings.");
            throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "Missing or empty JDBC URL parameter");
        }
        Driver driver = DriverManager.getDriver(jdbcUrl);
        assert (driver != null);
        try {
            logger.debug((Object)("Driver version " + driver.getMajorVersion() + "." + driver.getMinorVersion()));
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed to get info from driver : " + ex.getMessage()), (Throwable)ex);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Driver retrieveOrRegisterCustomLoaderDriver(String driverClass, String jarsDirectory, List<String> fallThroughPackages, List<String> nonFallThroughPackages) throws CodedSQLException {
        List<String> fallThroughPackageList = fallThroughPackages != null ? fallThroughPackages : Collections.emptyList();
        List<String> nonFallThroughPackageList = nonFallThroughPackages != null ? nonFallThroughPackages : Collections.emptyList();
        DriverKey key = new DriverKey(driverClass, jarsDirectory, fallThroughPackageList);
        Map<DriverKey, DriverWrapper> map = wrappedDrivers;
        synchronized (map) {
            DriverWrapper driver = wrappedDrivers.get(key);
            if (driver != null) {
                return driver;
            }
            File jarsDirectoryF = ApplicationConfigurator.getBaseFolderF().toPath().resolve(jarsDirectory).toFile();
            if (!jarsDirectoryF.exists()) {
                String error = "Failed to load JDBC driver because the specified Jars directory do not exist on disk: " + jarsDirectoryF.getAbsolutePath();
                if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE) {
                    error = error + ". An admin must rebuild the container image for visual recipes.";
                }
                throw new CodedSQLException(SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, error);
            }
            try {
                URLClassLoader classLoader = new IsolatedClassLoaderBuilder().withJarsInRecursiveDir(jarsDirectoryF).withFallThroughPackages(fallThroughPackageList).withNonFallThroughPackages(nonFallThroughPackageList).build();
                Driver actualDriver = (Driver)Class.forName(driverClass, true, classLoader).newInstance();
                driver = new DriverWrapper(actualDriver);
                DriverManager.registerDriver(driver);
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new CodedSQLException(SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, "Failed to load JDBC driver (" + driverClass + ")", e);
            }
            wrappedDrivers.put(key, driver);
            return driver;
        }
    }

    private static class DriverKey {
        private final String driver;
        private final String jarsDirectory;
        private final List<String> fallThroughPackages;

        DriverKey(String driver, String jarsDirectory, List<String> fallThroughPackages) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)jarsDirectory, (Object)"jarsDirectory");
            Preconditions.checkNotNull(fallThroughPackages, (Object)"fallThroughPackages");
            this.driver = driver;
            this.jarsDirectory = jarsDirectory;
            this.fallThroughPackages = fallThroughPackages;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DriverKey)) {
                return false;
            }
            DriverKey that = (DriverKey)o;
            return this.driver.equals(that.driver) && this.jarsDirectory.equals(that.jarsDirectory) && this.fallThroughPackages.equals(that.fallThroughPackages);
        }

        public int hashCode() {
            return Objects.hash(this.driver, this.jarsDirectory, this.fallThroughPackages);
        }
    }

    public static class DriverWrapper
    implements Driver {
        private final Driver driver;

        public DriverWrapper(Driver driver) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            this.driver = driver;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.driver.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.driver.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.driver.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.driver.getParentLogger();
        }
    }
}

