/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights;

import com.dataiku.dip.dashboards.TileDeserializer;
import com.dataiku.dip.dashboards.insights.InsightDeserializer;
import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightMeta;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.utils.DKUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class InsightsRegistry {
    private static final Map<String, InsightMeta> library = new LinkedHashMap<String, InsightMeta>();

    public static InsightHandler buildHandler(Insight insight) {
        return InsightsRegistry.getMeta(insight).buildHandler(insight);
    }

    public static synchronized InsightMeta getMeta(Insight insight) {
        return InsightsRegistry.getMeta(insight.type);
    }

    public static synchronized InsightMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        throw new Error("Unknown insight type: " + type);
    }

    public static synchronized void register(InsightMeta meta) {
        InsightDeserializer.registerType(meta.getType(), meta.paramsClass());
        TileDeserializer.registerType(meta.getType(), meta.tileParamsClass());
        library.put(meta.getType(), meta);
    }

    public static void loadClass() {
        DKUtils.forceInit(InsightDeserializer.class);
        DKUtils.forceInit(TileDeserializer.class);
    }
}

