/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.model;

import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;

@UIModel
public class DashboardPageSectionSettings {
    private final ZoomMode zoomMode;
    private final boolean shouldDisplayPageSeparators;
    @UINullable
    private final PageSectionFormat pageSectionFormat;

    public DashboardPageSectionSettings(ZoomMode zoomMode, PageSectionFormat pageSectionFormat, boolean shouldDisplayPageSeparators) {
        this.zoomMode = zoomMode;
        this.pageSectionFormat = pageSectionFormat;
        this.shouldDisplayPageSeparators = shouldDisplayPageSeparators;
    }

    public ZoomMode getZoomMode() {
        return this.zoomMode;
    }

    public PageSectionFormat getPageSectionFormat() {
        return this.pageSectionFormat;
    }

    public boolean getShouldDisplayPageSeparators() {
        return this.shouldDisplayPageSeparators;
    }

    public static DashboardPageSectionSettings defaultSettings() {
        int xInPxA4 = 1754;
        int yInPxA4 = 1240;
        return new DashboardPageSectionSettings(ZoomMode.FIT_TO_WIDTH, new PageSectionFormat(PageSectionFormatName.A4, xInPxA4, yInPxA4, 150, PageSectionFormatOrientation.LANDSCAPE, (double)xInPxA4 / (double)yInPxA4), false);
    }

    public static enum ZoomMode {
        FIT_TO_PAGE,
        FIT_TO_WIDTH;

    }

    public static class PageSectionFormat {
        private final PageSectionFormatName formatName;
        private final int xInPx;
        private final int yInPx;
        private final int dpi;
        private final PageSectionFormatOrientation orientation;
        private final Double ratio;

        public PageSectionFormat(PageSectionFormatName formatName, int xInPx, int yInPx, int dpi, PageSectionFormatOrientation orientation, Double ratio) {
            this.formatName = formatName;
            this.xInPx = xInPx;
            this.yInPx = yInPx;
            this.dpi = dpi;
            this.orientation = orientation;
            this.ratio = ratio;
        }

        public static PageSectionFormat createFromExportFormat(ExportFormat exportFormat, int dpi) {
            PageSectionFormatOrientation orientation = exportFormat.orientation != null ? PageSectionFormatOrientation.valueOf(exportFormat.orientation.name()) : (exportFormat.width <= exportFormat.height ? PageSectionFormatOrientation.PORTRAIT : PageSectionFormatOrientation.LANDSCAPE);
            return new PageSectionFormat(PageSectionFormatName.valueOf(exportFormat.paperSize.name()), exportFormat.width, exportFormat.height, dpi, orientation, exportFormat.paperSize.ratio);
        }

        public PageSectionFormatName getFormatName() {
            return this.formatName;
        }

        public int getxInPx() {
            return this.xInPx;
        }

        public int getyInPx() {
            return this.yInPx;
        }

        public int getDpi() {
            return this.dpi;
        }

        public PageSectionFormatOrientation getOrientation() {
            return this.orientation;
        }

        public Double getRatio() {
            return this.ratio;
        }
    }

    public static enum PageSectionFormatName {
        A3,
        A4,
        LEDGER,
        US_LETTER,
        SCREEN_16_9,
        CUSTOM;

    }

    public static enum PageSectionFormatOrientation {
        LANDSCAPE,
        PORTRAIT;

    }
}

