/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeHelper;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureUtils;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.SchemaVisitor;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoFeatureGenerationRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private AutoFeatureGenerationRecipePayloadParams params;
    private AutoFeatureGenerationRecipeStatusComputer statusComputer;
    private final AutoFeatureGenerationRecipeHelper recipeHelper = new AutoFeatureGenerationRecipeHelper();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.autofeaturegeneration.schema");

    public AutoFeatureGenerationRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = AutoFeatureGenerationRecipeHelper.loadParams(payload, this.recipe);
        Preconditions.checkNotNull((Object)this.params, (Object)"Empty parameters");
        this.statusComputer = new AutoFeatureGenerationRecipeStatusComputer(this.recipe, payload);
        SpringUtils.getInstance().autowire((Object)this.statusComputer);
    }

    public void setParams(AutoFeatureGenerationRecipePayloadParams params) {
        this.params = params;
    }

    private void fastSanityCheck(AutoFeatureGenerationRecipeStatusComputer.AutoFeatureGenerationRecipeStatus status) throws Exception {
        if (this.statusComputer != null) {
            this.recipeHelper.initDatasetsConfigurations(this.activity, status.params);
            status.params.validate();
            this.statusComputer.checkRelationships(status, this.recipeHelper.datasetsMap);
            this.statusComputer.checkSelectedColumns(status, this.recipeHelper.datasetsMap);
            InfoMessage.InfoMessages statusMessages = status.gatherAllMessages();
            if (statusMessages.anyFatal()) {
                throw statusMessages.firstFatal().asCodedException();
            }
        }
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        AutoFeatureGenerationRecipeStatusComputer.AutoFeatureGenerationRecipeStatus status = new AutoFeatureGenerationRecipeStatusComputer.AutoFeatureGenerationRecipeStatus();
        status.params = this.params;
        try (Transaction t = this.transactionService.beginRead();){
            this.fastSanityCheck(status);
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    public Schema getSchema() throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        this.recipeHelper.initDatasetsConfigurations(this.activity, this.params);
        RelationshipGraph relationshipGraph = new RelationshipGraph(this.params, this.recipeHelper.datasetsMap);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine, true);
        SchemaVisitor schemaVisitor = new SchemaVisitor(this.params, FeatureUtils.getIdentifierMaxLength(dialect));
        relationshipGraph.makeFeatures(schemaVisitor);
        return relationshipGraph.getRootSchema();
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        ArrayList columnsToRemove;
        Schema schema;
        AutoFeatureGenerationRecipePayloadParams.InputDesc inputDesc;
        logger.info((Object)("AFG update recipe options=" + JSON.log((Object)optionsObj)));
        AutoFeatureGenerationRecipeUpdateOptions options = optionsObj == null ? new AutoFeatureGenerationRecipeUpdateOptions() : (AutoFeatureGenerationRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, AutoFeatureGenerationRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        ArrayList inputSchemas = Lists.newArrayList();
        try (Transaction ignored = this.transactionService.beginRead();){
            List<SerializedRecipe.RecipeInput> recipeInputs = this.recipe.getInputsForRole("main");
            for (AutoFeatureGenerationRecipePayloadParams.InputDesc inputDesc2 : this.params.virtualInputs) {
                SerializedRecipe.RecipeInput input = recipeInputs.get(inputDesc2.index);
                AnyLoc inputLoc = input.getLoc(this.recipe.projectKey);
                Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
                Schema inputSchema = inputDataset.getSchema();
                inputSchemas.add(inputSchema);
            }
        }
        if (options.removeMissingRelationships) {
            for (AutoFeatureGenerationRecipePayloadParams.RelationshipDesc relationship : this.params.relationships) {
                Schema schema1 = (Schema)inputSchemas.get(relationship.table1);
                Schema schema2 = (Schema)inputSchemas.get(relationship.table2);
                ArrayList conditionsToRemove = Lists.newArrayList();
                for (JoinRecipePayloadParams.MatchingCondition condition : relationship.on) {
                    if (schema1.getColumn(condition.column1.name) == null) {
                        conditionsToRemove.add(condition);
                        ret.recipeChanges.add(String.format("Removed matching condition using %s", condition.column1.name));
                        continue;
                    }
                    if (schema2.getColumn(condition.column2.name) != null) continue;
                    conditionsToRemove.add(condition);
                    ret.recipeChanges.add(String.format("Removed matching condition using %s", condition.column2.name));
                }
                relationship.on.removeAll(conditionsToRemove);
            }
        }
        if (options.removeMissingSelectedColumns) {
            for (int i = 0; i < this.params.virtualInputs.size(); ++i) {
                inputDesc = (AutoFeatureGenerationRecipePayloadParams.InputDesc)this.params.virtualInputs.get(i);
                schema = (Schema)inputSchemas.get(i);
                columnsToRemove = Lists.newArrayList();
                for (AutoFeatureGenerationRecipePayloadParams.Column column : inputDesc.selectedColumns) {
                    if (schema.getColumn(column.name) != null) continue;
                    columnsToRemove.add(column);
                    ret.recipeChanges.add(String.format("Removed selected column %s from %s", column.name, inputDesc.alias));
                }
                inputDesc.selectedColumns.removeAll(columnsToRemove);
            }
        }
        if (options.fixSelectedColumnsVariableTypes) {
            for (int i = 0; i < this.params.virtualInputs.size(); ++i) {
                inputDesc = (AutoFeatureGenerationRecipePayloadParams.InputDesc)this.params.virtualInputs.get(i);
                schema = (Schema)inputSchemas.get(i);
                columnsToRemove = Lists.newArrayList();
                for (AutoFeatureGenerationRecipePayloadParams.Column column : inputDesc.selectedColumns) {
                    SchemaColumn schemaCol = schema.getColumn(column.name);
                    if (schemaCol == null || AutoFeatureGenerationRecipeStatusComputer.checkVariableTypeMatchesStorageType(column, schemaCol)) continue;
                    String storageType = schemaCol.getTypeString();
                    VariableType fallbackVariableType = AutoFeatureGenerationRecipeHelper.getFallbackVariableType(schemaCol);
                    if (fallbackVariableType == null) {
                        columnsToRemove.add(column);
                        ret.recipeChanges.add(String.format("Removed selected column %s of dataset %s with type %s from %s", column.name, inputDesc.name, storageType, inputDesc.alias));
                        continue;
                    }
                    column.variableType = fallbackVariableType;
                    ret.recipeChanges.add(String.format("Changed selected column %s of dataset %s variable type to %s", new Object[]{column.name, inputDesc.name, column.variableType}));
                }
                inputDesc.selectedColumns.removeAll(columnsToRemove);
            }
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    public static class AutoFeatureGenerationRecipeUpdateOptions {
        public boolean removeMissingRelationships = false;
        public boolean removeMissingSelectedColumns = true;
        public boolean fixSelectedColumnsVariableTypes = true;
    }
}

