/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeUtils;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeoJoinRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private TransactionService transactionService;

    public List<GeoJoinRecipePayloadParams.MatchingCondition> suggestJoinConditions(SerializedRecipe sr, String payload) throws Exception {
        FlowRecipe fr = new FlowRecipe(sr);
        JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(fr));
        GeoJoinRecipePayloadParams params = this.loadParams(payload, sr);
        GeoJoinRecipePayloadParams.JoinDesc join = (GeoJoinRecipePayloadParams.JoinDesc)params.joins.get(params.joins.size() - 1);
        String datasetFullName1 = ((JoinInputDescBase)params.virtualInputs.get((int)join.table1)).name;
        String datasetFullName2 = ((JoinInputDescBase)params.virtualInputs.get((int)join.table2)).name;
        Dataset dataset1 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName1);
        Dataset dataset2 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName2);
        Schema schema1 = dataset1.getSchema();
        Schema schema2 = dataset2.getSchema();
        return new GeoJoinConditionsSuggester().computeSuggestions(join, schema1, schema2);
    }

    private GeoJoinRecipePayloadParams resolveDatasetsName(GeoJoinRecipePayloadParams params, SerializedRecipe sr) {
        ArrayList<String> datasets = new ArrayList<String>(sr.getFlatInputs().size());
        for (SerializedRecipe.RecipeInput in : sr.getFlatInputs()) {
            AnyLoc loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasets.add(loc.getFullName());
        }
        if (params.virtualInputs != null) {
            for (JoinInputDescBase vi : params.virtualInputs) {
                if (vi.index < 0 || vi.index >= datasets.size()) {
                    throw ErrorContext.iae((String)("Recipes inputs are incorrect. Input index: " + vi.index));
                }
                vi.name = (String)datasets.get(vi.index);
            }
        }
        return params;
    }

    public GeoJoinRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        GeoJoinRecipePayloadParams params = (GeoJoinRecipePayloadParams)JSON.parse((String)payload, GeoJoinRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty params");
        this.expandParams(params, sr.getProjectKey());
        return this.resolveDatasetsName(params, sr);
    }

    private void expandParams(GeoJoinRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.postFilter, vc);
    }

    private static void checkPreFilterDesc(int virtualInputIndex, GeoJoinRecipePayloadParams params, JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) throws Exception {
        FilterDesc preFilter = ((JoinInputDescBase)params.virtualInputs.get((int)virtualInputIndex)).preFilter;
        JoinLikeRecipeUtils.checkPreFilterDescUtil(ret, newSchema, preFilter);
    }

    public JoinLikeRecipeUtils.InputReplacementTestResult testVirtualInputReplacement(SerializedRecipe sr, String payload, int virtualInputIndex, SerializedDataset newInput) throws Exception {
        GeoJoinRecipePayloadParams params;
        GeoJoinRecipeHelper helper = new GeoJoinRecipeHelper();
        try (Transaction t = this.transactionService.beginRead();){
            JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(new FlowRecipe(sr)));
            params = helper.loadParams(payload, sr);
            helper.initInputDatasets(activity, params, null, false);
        }
        JoinLikeRecipeUtils.InputReplacementTestResult ret = new JoinLikeRecipeUtils.InputReplacementTestResult();
        try {
            Schema newSchema = newInput.getSchema();
            if (JoinLikeRecipeUtils.checkSchemaEmptiness(newSchema)) {
                ret.warn("Dataset schema is empty");
                return ret;
            }
            this.checkPresenceOfGeospatialColumns(ret, newSchema);
            JoinLikeRecipeUtils.checkJoinColumns(virtualInputIndex, params.joins, ret, newSchema);
            JoinLikeRecipeUtils.checkSelectedColumns(virtualInputIndex, params.getSelectedColumns(), ret, newSchema);
            GeoJoinRecipeService.checkPreFilterDesc(virtualInputIndex, params, ret, newSchema);
        }
        catch (Exception e) {
            ret.warn("Failed to complete check: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    private void checkPresenceOfGeospatialColumns(JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) {
        boolean containsGeoSpatialColumn = false;
        for (SchemaColumn column : newSchema.columns) {
            if (!column.getType().isGeo()) continue;
            containsGeoSpatialColumn = true;
            break;
        }
        if (!containsGeoSpatialColumn) {
            ret.warn("Dataset has no geospatial column, won't be able to do a geojoin.");
        }
    }

    private static class GeoJoinConditionsSuggester
    extends JoinLikeRecipeUtils.JoinConditionsSuggester<GeoJoinRecipePayloadParams.MatchingCondition, GeoJoinRecipePayloadParams.JoinDesc> {
        private GeoJoinConditionsSuggester() {
        }

        @Override
        protected boolean isJoinableColumn(SchemaColumn schemaColumn) {
            return schemaColumn.getType().isGeo();
        }

        @Override
        protected Optional<GeoJoinRecipePayloadParams.MatchingCondition> suggestedMatchDesc(SchemaColumn col1, SchemaColumn col2) {
            if (col1 == null || col2 == null) {
                return Optional.empty();
            }
            if (col1.getType().isGeo() && col2.getType().isGeo()) {
                return Optional.of(new GeoJoinRecipePayloadParams.MatchingCondition(GeoJoinRecipePayloadParams.MatchingType.DWITHIN, 100.0));
            }
            return Optional.empty();
        }
    }
}

