/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

@UIModel
public class GroupingRecipePayloadParams
extends VisualSQLRecipePayloadParams
implements ParamsWithContainerizable,
BasicRecipeLineageHandler.Params {
    public ArrayList<GroupingValue> values = new ArrayList();
    public List<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
    public FilterDesc preFilter = new FilterDesc();
    public FilterDesc postFilter = new FilterDesc();
    public HashMap<String, String> outputColumnNameOverrides;
    public boolean globalCount;
    @JSON.FileTransient
    public boolean selectAllColumns = false;
    private List<GroupingKey> keys = new ArrayList<GroupingKey>();
    public boolean enlargeYourBits;

    @Override
    public List<ComputedColumn> getComputedColumns() {
        return this.computedColumns;
    }

    @Override
    public Map<String, String> getOutputColumnNameOverrides() {
        return this.outputColumnNameOverrides;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public void setGroupingKeys(List<GroupingKey> keys) {
        this.keys = keys;
    }

    public List<GroupingKey> getRawGroupingKeys() {
        return this.keys;
    }

    @Nonnull
    public List<GroupingKey> getResolvedGroupingKeys(Schema inputSchema) {
        if (this.selectAllColumns) {
            if (inputSchema != null && inputSchema.columns != null) {
                return inputSchema.columns.stream().map(col -> new GroupingKey(col.getName(), col.getType())).toList();
            }
        } else if (this.keys != null) {
            return this.keys;
        }
        return Collections.emptyList();
    }

    @UIModel
    public static class GroupingKey {
        public String column;
        public Type type;

        public GroupingKey() {
        }

        public GroupingKey(String column) {
            this.column = column;
        }

        public GroupingKey(String column, Type type) {
            this.column = column;
            this.type = type;
        }
    }

    @UIModel
    public class Order {
        public String column;
        public boolean desc;
    }

    @UIModel
    public static class GroupingValue {
        public String column;
        public String type;
        public SchemaColumn arrayContent;
        public SchemaColumn mapKeys;
        public SchemaColumn mapValues;
        public List<SchemaColumn> objectFields;
        public transient Expression condition;
        public boolean min;
        public boolean max;
        public boolean count;
        public boolean countDistinct;
        public boolean sum;
        public boolean concat;
        public boolean stddev;
        public boolean avg;
        public boolean median;
        public boolean sum2;
        public boolean first;
        public boolean last;
        public transient boolean countUnique = false;
        public String concatSeparator;
        public boolean concatDistinct;
        public String customName;
        public String customExpr;
        public boolean firstLastNotNull;
        public String customAggr;
        public String orderColumn;

        public GroupingValue() {
        }

        public List<SQLAggregateType> getUsedAggregateTypes() {
            if (this.isCustomAggregate()) {
                return List.of();
            }
            return Arrays.stream(SQLAggregateType.values()).filter(aggType -> switch (aggType) {
                default -> throw new IncompatibleClassChangeError();
                case SQLAggregateType.MIN -> this.min;
                case SQLAggregateType.MAX -> this.max;
                case SQLAggregateType.COUNT -> {
                    if (this.count && !this.countDistinct) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.DISTINCT -> {
                    if (this.count && this.countDistinct) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.SUM -> {
                    if (this.sum || this.sum2) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.CONCAT -> {
                    if (this.concat && !this.concatDistinct) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.CONCAT_DISTINCT -> {
                    if (this.concat && this.concatDistinct) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.AVG -> this.avg;
                case SQLAggregateType.MEDIAN -> this.median;
                case SQLAggregateType.STDDEV -> this.stddev;
                case SQLAggregateType.FIRST -> {
                    if (this.first && !this.firstLastNotNull) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.LAST -> {
                    if (this.last && !this.firstLastNotNull) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.FIRST_NOTNULL -> {
                    if (this.first && this.firstLastNotNull) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.LAST_NOTNULL -> {
                    if (this.last && this.firstLastNotNull) {
                        yield true;
                    }
                    yield false;
                }
                case SQLAggregateType.RETRIEVE, SQLAggregateType.LEAD, SQLAggregateType.LAG, SQLAggregateType.LEAD_DIFF, SQLAggregateType.LAG_DIFF -> false;
            }).toList();
        }

        public boolean isCustomAggregate() {
            return StringUtils.isNotBlank((String)this.customAggr);
        }

        public GroupingValue(String column, boolean min, boolean max, boolean sum, boolean avg, boolean count, boolean countDistinct, boolean first, boolean last, String orderColumn) {
            this.column = column;
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.avg = avg;
            this.count = count;
            this.countDistinct = countDistinct;
            this.first = first;
            this.last = last;
            this.orderColumn = orderColumn;
        }

        public GroupingValue(String column, boolean min, boolean max, boolean sum, boolean avg, boolean count, boolean countDistinct, boolean first, boolean last, boolean concat, boolean concatDistinct, boolean stddev, String orderColumn, String concatSeparator) {
            this(column, min, max, sum, avg, count, countDistinct, first, last, orderColumn);
            this.concat = concat;
            this.concatDistinct = concatDistinct;
            this.stddev = stddev;
            this.concatSeparator = concatSeparator;
        }

        public Type getType() {
            return StringUtils.isBlank((String)this.type) ? Type.STRING : Type.forName((String)this.type.toLowerCase());
        }

        public void setType(Type type) {
            this.type = type == null ? null : type.name();
        }

        public boolean hasAnyAggr() {
            assert (this.column != null);
            return this.min || this.max || this.count || this.countDistinct || this.sum || this.concat || this.stddev || this.avg || this.median || this.first || this.last || this.sum2 || this.countUnique;
        }

        public int aggrCount() {
            assert (this.column != null);
            int c2 = 0;
            if (this.min) {
                ++c2;
            }
            if (this.max) {
                ++c2;
            }
            if (this.count) {
                ++c2;
            }
            if (this.countDistinct) {
                ++c2;
            }
            if (this.sum) {
                ++c2;
            }
            if (this.stddev) {
                ++c2;
            }
            if (this.avg) {
                ++c2;
            }
            if (this.median) {
                ++c2;
            }
            if (this.first) {
                ++c2;
            }
            if (this.last) {
                ++c2;
            }
            if (this.sum2) {
                ++c2;
            }
            if (this.countUnique) {
                ++c2;
            }
            return c2;
        }

        public ArrayList<SchemaColumn> getDerivedColumns(GroupingRecipePayloadParams params, Type columnType, SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer) {
            String aggColumn;
            ArrayList<SchemaColumn> ret = new ArrayList<SchemaColumn>();
            if (this.min) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_min");
                ret.add(new SchemaColumn(aggColumn, columnType));
            }
            if (this.max) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_max");
                ret.add(new SchemaColumn(aggColumn, columnType));
            }
            if (this.count) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_count");
                ret.add(new SchemaColumn(aggColumn, Type.BIGINT));
            }
            if (this.countDistinct) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_distinct");
                ret.add(new SchemaColumn(aggColumn, Type.BIGINT));
            }
            if (this.avg) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_avg");
                Type outColType = columnType == Type.DATE || columnType == Type.DATEONLY ? Type.DATE : (columnType == Type.DATETIMENOTZ ? Type.DATETIMENOTZ : Type.DOUBLE);
                ret.add(new SchemaColumn(aggColumn, outColType));
            }
            if (this.median) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_median");
                ret.add(new SchemaColumn(aggColumn, Type.DOUBLE));
            }
            if (this.sum || this.sum2) {
                Type outColType = columnType == Type.BOOLEAN || columnType.isInteger() && params.enlargeYourBits ? Type.BIGINT : columnType;
                String aggColumn2 = safeSuffixer.addSuffix(this.column, "_sum");
                ret.add(new SchemaColumn(aggColumn2, outColType));
            }
            if (this.concat) {
                ret.add(new SchemaColumn(safeSuffixer.addSuffix(this.column, "_concat"), Type.STRING));
            }
            if (this.stddev) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_stddev");
                ret.add(new SchemaColumn(aggColumn, Type.DOUBLE));
            }
            if (this.first) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_first");
                ret.add(new SchemaColumn(aggColumn, columnType));
            }
            if (this.last) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_last");
                ret.add(new SchemaColumn(aggColumn, columnType));
            }
            if (this.countUnique) {
                aggColumn = safeSuffixer.addSuffix(this.column, "_unique");
                ret.add(new SchemaColumn(aggColumn, columnType));
            }
            return ret;
        }
    }
}

