/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.stream;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.WithFactories;
import com.dataiku.dip.dataflow.exec.WithPushOutputs;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.PipelineInterruptedException;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.stream.ParallelStreamer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import org.apache.log4j.Logger;

public class ParallelStreamSlaveRunnable
implements FlowRunnable,
WithPushOutputs,
WithFactories {
    private ParallelStreamer.SplitRunner split;
    private Dataset dataset;
    private WarningsContext warningContext;
    private AuthCtx authCtx;
    private ProcessorOutput out;
    private ColumnFactory cf;
    private RowFactory rf;
    public InputSplitProgressListener listener = new InputSplitProgressListener();
    private static Logger logger = Logger.getLogger((String)"dku.pipeline");

    public ParallelStreamSlaveRunnable(AuthCtx authCtx, Dataset dataset, ParallelStreamer.SplitRunner split, WarningsContext warningContext) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.split = split;
        this.warningContext = warningContext;
    }

    @Override
    public void setOutput(String name, ProcessorOutput out) {
        this.out = out;
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)"start running");
        try {
            if (this.dataset.getFormatType() == null) {
                throw ErrorContext.iaef((String)"No format for dataset %s", (Object)this.dataset.getName(), (Object[])new Object[0]);
            }
            FormatExtractor extractor = FormatFactory.buildExtractor(this.dataset.getFormatType(), this.dataset.getFormatParams(), this.authCtx, this.dataset.getProjectKey());
            if (this.dataset.getSchema() != null) {
                extractor.setSchema(this.dataset.getSchema(), false);
            }
            extractor.setProgressListener(this.listener);
            extractor.setWarningsContext(this.warningContext);
            boolean ok = extractor.run(this.split, this.out, this.cf, this.rf);
            assert (ok);
            this.out.lastRowEmitted();
        }
        catch (PipelineInterruptedException e) {
            logger.info((Object)("Pipeline was interrupted:" + e.getMessage()));
            this.split.cancel();
            this.out.lastRowEmitted();
        }
        catch (Throwable e) {
            logger.error((Object)"Parallel stream worker failed", e);
            this.split.cancel();
            throw e;
        }
        finally {
            logger.info((Object)"done running");
        }
    }

    @Override
    public void setFactories(ColumnFactory cf, RowFactory rf) {
        assert (this.out != null);
        this.cf = cf;
        this.rf = rf;
        if (this.out instanceof ProcessorOutputToSIP) {
            SingleInputRowProcessor sirp = ((ProcessorOutputToSIP)this.out).getTarget();
            if (sirp instanceof WithFactories) {
                ((WithFactories)sirp).setFactories(cf, rf);
            }
        } else if (this.out instanceof WithFactories) {
            ((WithFactories)this.out).setFactories(cf, rf);
        }
    }
}

