/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataquality.DatasetQuality;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.util.AnyLoc;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DataQualityView
extends AbstractFlowTool.FlowView {
    @Autowired
    private DataQualityService dataQualityService;
    private DataQualityViewState state;

    public DataQualityView(AuthCtx authCtx, String projectKey) {
        super(authCtx, projectKey);
    }

    @Override
    public synchronized AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        boolean includeForeignObjects = false;
        JsonElement modeOption = options.get("includeForeignObjects");
        if (modeOption != null) {
            includeForeignObjects = modeOption.getAsBoolean();
        } else if (this.state != null) {
            includeForeignObjects = this.state.includeForeignObjects;
        }
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState(includeForeignObjects);
            this.state.focused = currentFocus;
        } else {
            this.computeState(includeForeignObjects);
        }
        return this.state;
    }

    @Override
    public synchronized DataQualityViewState computeState() throws Exception {
        return this.computeState(false);
    }

    private synchronized DataQualityViewState computeState(boolean includeForeignObjects) throws SQLException, IOException, InterruptedException {
        this.state = new DataQualityViewState();
        for (Map.Entry<AnyLoc, DatasetQuality> entry : this.dataQualityService.getDatasetsStatusLastInProject_NT(this.projectKey, includeForeignObjects).entrySet()) {
            FutureProgressState.checkInterrupt();
            AnyLoc loc = entry.getKey();
            DatasetQuality datasetQuality = entry.getValue();
            String nodeId = GraphIds.forDataset(loc.getProjectKey(), loc.getId());
            this.state.valueByNode.put(nodeId, datasetQuality);
        }
        this.state.includeForeignObjects = includeForeignObjects;
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused, String mode) throws Exception {
        this.setFocus(focused, Boolean.parseBoolean(mode));
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        this.setFocus(focused, false);
    }

    private void setFocus(Collection<String> focused, boolean includeForeignObjects) throws Exception {
        if (this.state == null) {
            this.computeState(includeForeignObjects);
        }
        this.state.focused = focused == null ? new HashSet() : focused;
        this.state.includeForeignObjects = includeForeignObjects;
    }

    private static class DataQualityViewState
    implements AbstractFlowTool.FlowState {
        public Collection<String> focused = new HashSet<String>();
        public Map<String, DatasetQuality> valueByNode = new HashMap<String, DatasetQuality>();
        public boolean includeForeignObjects = false;

        private DataQualityViewState() {
        }
    }
}

