/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner.status;

import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import java.lang.invoke.CallSite;
import java.util.HashSet;

public class StatusAsDOTPrinter {
    private static String getStatusStyle(SerializedJobActivityStatus ja) {
        switch (ja.state) {
            case FAILED: {
                return "style=filled,fillcolor=\"#FF8888\"";
            }
            case DONE: {
                return "style=filled,fillcolor=\"#ccffcc\"";
            }
            case NOT_STARTED: {
                return "style=filled,fillcolor=white";
            }
            case RUNNING: {
                return "style=filled,fillcolor=\"#FFDD88\"";
            }
        }
        throw new Error("oops");
    }

    private static String getNiceLabel(String ds, String p) {
        return "label=\"" + ds + "\\n" + p + "\"";
    }

    public static String printAsDOT(SerializedJobStatus job) {
        SerializedJobActivityStatus sja2;
        StringBuilder sb = new StringBuilder();
        sb.append("digraph g {\n  rankdir = LR;\n\n");
        HashSet<CallSite> alreadyPrinted = new HashSet<CallSite>();
        for (String activityId : job.activities.keySet()) {
            sja2 = job.activities.get(activityId);
            for (SerializedJobActivityStatus.SerializedTargetDS targetDS : sja2.targets) {
                String nodeName = targetDS.id.replace("-", "_") + "_" + targetDS.partition.id.replace("-", "_");
                if (alreadyPrinted.contains(nodeName)) continue;
                sb.append(nodeName + " [" + StatusAsDOTPrinter.getStatusStyle(sja2) + "," + StatusAsDOTPrinter.getNiceLabel(targetDS.id, targetDS.partition.id) + "];\n");
                alreadyPrinted.add((CallSite)((Object)nodeName));
            }
        }
        for (String activityId : job.activities.keySet()) {
            sja2 = job.activities.get(activityId);
            for (SerializedJobActivityStatus.SerializedSourceDS sourceDS : sja2.sources) {
                for (SerializedJobActivityStatus.SourcePartitionStats partitionId : sourceDS.partitions) {
                    String nodeName = sourceDS.id.replace("-", "_") + "_" + partitionId.id.replace("-", "_");
                    if (alreadyPrinted.contains(nodeName)) continue;
                    sb.append(nodeName + " [style=filled, fillcolor=\"#ccccff\"," + StatusAsDOTPrinter.getNiceLabel(sourceDS.id, partitionId.id) + "];\n");
                    alreadyPrinted.add((CallSite)((Object)nodeName));
                }
            }
        }
        HashSet<CallSite> alreadyLinked = new HashSet<CallSite>();
        for (SerializedJobActivityStatus sja2 : job.activities.values()) {
            for (SerializedJobActivityStatus.SerializedTargetDS targetDS : sja2.targets) {
                for (SerializedJobActivityStatus.SerializedSourceDS sourceDS : sja2.sources) {
                    for (SerializedJobActivityStatus.SourcePartitionStats srcPartitionId : sourceDS.partitions) {
                        String tgtNodeName;
                        String srcNodeName = sourceDS.id.replace("-", "_") + "_" + srcPartitionId.id.replace("-", "_");
                        String linkName = srcNodeName + "_" + (tgtNodeName = targetDS.id.replace("-", "_") + "_" + targetDS.partition.id.replace("-", "_"));
                        if (alreadyLinked.contains(linkName)) continue;
                        sb.append(srcNodeName + " -> " + tgtNodeName + ";\n");
                        alreadyLinked.add((CallSite)((Object)linkName));
                    }
                }
            }
        }
        sb.append("}\n");
        return sb.toString();
    }
}

