/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.pipeline.PipelineabilityEvaluator;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergeabilityGraph {
    private RecipePipelineHelper.PipelineType pipelineType;
    private final List<Node> nodes = Lists.newArrayList();
    private final List<Edge> edges = Lists.newArrayList();
    private final Map<String, Integer> nodeNoById = Maps.newHashMap();
    private final Map<String, Integer> nodeNoByActivityId = Maps.newHashMap();
    private final AuthCtx authCtx;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.mergeability");

    MergeabilityGraph(AuthCtx authCtx, JobActivity rootActivity, RecipePipelineHelper.PipelineType pipelineType) {
        this.authCtx = authCtx;
        this.pipelineType = pipelineType;
        this.recFillNodes(rootActivity);
        for (Node n : this.nodes) {
            this.fillEdges(n);
        }
    }

    @VisibleForTesting
    SetMergeabilityTest getAcyclicityTest() {
        return new AcyclicityTest();
    }

    private List<String> mapToIds(Collection<Node> nodes) {
        ArrayList ret = Lists.newArrayList();
        for (Node node : nodes) {
            ret.add(node.id());
        }
        return ret;
    }

    private List<String> flatMapToIds(Collection<Set<Node>> nodes) {
        ArrayList ret = Lists.newArrayList();
        for (Set<Node> set : nodes) {
            for (Node node : set) {
                ret.add(node.id());
            }
        }
        return ret;
    }

    public List<Set<JobActivity>> merge(Set<SetPipelineabilityTest> pipelineabilityTests, Set<SetMergeabilityTest> mergeabilityTests) throws IOException, DKUSecurityException {
        HashSet allPipelineabilityTests = Sets.newHashSet();
        if (pipelineabilityTests != null) {
            allPipelineabilityTests.addAll(pipelineabilityTests);
        }
        HashSet allMergeabilityTests = Sets.newHashSet();
        if (mergeabilityTests != null) {
            allMergeabilityTests.addAll(mergeabilityTests);
        }
        allMergeabilityTests.add(new AcyclicityTest());
        ArrayList components = Lists.newArrayList();
        HashSet mergeableIds = Sets.newHashSet(this.nodeNoById.keySet());
        List<Set<Node>> mergeables = this.findMergeables(mergeableIds, allPipelineabilityTests, allMergeabilityTests);
        if (mergeables.isEmpty()) {
            logger.info((Object)"Nothing at all to merge");
        }
        for (Set<Node> component : mergeables) {
            logger.infoV("Found a component of size %d to convert to a pipeline, activities=%s", new Object[]{component.size(), Joiner.on((String)",").join(this.mapToIds(component))});
            HashSet activities = Sets.newHashSet();
            for (Node n : component) {
                mergeableIds.remove(n.id());
                activities.add(n.activity());
            }
            components.add(activities);
        }
        if (mergeableIds.isEmpty()) {
            logger.info((Object)"No activities left unmerged");
        } else {
            logger.infoV("Activities left unmerged, singleton=%s", new Object[]{Joiner.on((String)",").join((Iterable)mergeableIds)});
        }
        for (String id : mergeableIds) {
            components.add(Sets.newHashSet((Object[])new JobActivity[]{this.nodes.get(this.nodeNoById.get(id)).activity()}));
        }
        return components;
    }

    /*
     * WARNING - void declaration
     */
    private List<Set<Node>> findMergeables(Set<String> mergeableIds, Set<SetPipelineabilityTest> pipelineabilityTests, Set<SetMergeabilityTest> mergeabilityTests) throws IOException, DKUSecurityException {
        void var7_10;
        HashMap mergeableEdgesByChildId = Maps.newHashMap();
        HashMap mergeableEdgesByParentId = Maps.newHashMap();
        for (Edge edge : this.edges) {
            if (!edge.canMerge() || !mergeableIds.contains(edge.child.id()) || !mergeableIds.contains(edge.parent.id())) continue;
            if (!mergeableEdgesByChildId.containsKey(edge.child.id())) {
                mergeableEdgesByChildId.put(edge.child.id(), new ArrayList());
            }
            ((List)mergeableEdgesByChildId.get(edge.child.id())).add(edge);
            if (!mergeableEdgesByParentId.containsKey(edge.parent.id())) {
                mergeableEdgesByParentId.put(edge.parent.id(), new ArrayList());
            }
            ((List)mergeableEdgesByParentId.get(edge.parent.id())).add(edge);
        }
        ArrayList candidates = Lists.newArrayList();
        for (Node n : this.nodes) {
            if (!mergeableIds.contains(n.id()) || !n.canStart()) continue;
            candidates.add(Sets.newHashSet((Object[])new Node[]{n}));
        }
        if (candidates.isEmpty()) {
            logger.info((Object)"No activity left to merge can start a pipeline");
            return candidates;
        }
        logger.infoV("Found %d activities that can start a pipeline: %s", new Object[]{candidates.size(), Joiner.on((String)",").join(this.flatMapToIds(candidates))});
        Edge edge = this.findMerge(candidates, mergeableEdgesByChildId, pipelineabilityTests, mergeabilityTests);
        while (var7_10 != null) {
            Set<Node> childCandidate = this.findCandidate(var7_10.child, candidates);
            Set<Node> parentCandidate = this.findCandidate(var7_10.parent, candidates);
            assert (childCandidate != null) : "Child candidate cannot be null.";
            if (parentCandidate == null) {
                logger.infoV("Merge along edge from {%s} to %s", new Object[]{Joiner.on((String)",").join(this.mapToIds(childCandidate)), var7_10.parent.id()});
                childCandidate.add(var7_10.parent);
            } else {
                logger.infoV("Merge along edge from {%s} to {%s}", new Object[]{Joiner.on((String)",").join(this.mapToIds(childCandidate)), Joiner.on((String)",").join(this.mapToIds(parentCandidate))});
                childCandidate.addAll(parentCandidate);
                candidates.remove(parentCandidate);
            }
            for (Node node : childCandidate) {
                String nodeId = node.id();
                if (mergeableEdgesByChildId.containsKey(nodeId)) {
                    for (Edge edge2 : (List)mergeableEdgesByChildId.get(nodeId)) {
                        edge2.knownToNotBePossible = false;
                    }
                }
                if (!mergeableEdgesByParentId.containsKey(nodeId)) continue;
                for (Edge edge2 : (List)mergeableEdgesByParentId.get(nodeId)) {
                    edge2.knownToNotBePossible = false;
                }
            }
            Edge edge3 = this.findMerge(candidates, mergeableEdgesByChildId, pipelineabilityTests, mergeabilityTests);
        }
        return candidates;
    }

    private Set<Node> findCandidate(Node n, List<Set<Node>> candidates) {
        for (Set<Node> candidate : candidates) {
            if (!candidate.contains(n)) continue;
            return candidate;
        }
        return null;
    }

    private Edge findMerge(List<Set<Node>> candidates, Map<String, List<Edge>> mergeableEdgesByChildId, Set<SetPipelineabilityTest> pipelineabilityTests, Set<SetMergeabilityTest> mergeabilityTests) throws IOException {
        Set<JobActivity> candidateActivities;
        ArrayList candidatesActivities = Lists.newArrayList();
        for (Set<Node> candidate : candidates) {
            candidateActivities = Sets.newHashSet();
            for (Node n : candidate) {
                candidateActivities.add(n.activity());
            }
            candidatesActivities.add(candidateActivities);
        }
        for (int i = 0; i < candidates.size(); ++i) {
            Set<Node> candidate;
            candidate = candidates.get(i);
            candidateActivities = (Set)candidatesActivities.get(i);
            for (Node n : candidate) {
                if (!mergeableEdgesByChildId.containsKey(n.id())) continue;
                for (Edge e : mergeableEdgesByChildId.get(n.id())) {
                    Object p2;
                    if (e.knownToNotBePossible || candidate.contains(e.parent)) continue;
                    logger.infoV("Testing mergeable edge from %s to %s", new Object[]{e.child.id(), e.parent.id()});
                    Set<Node> parentCandidate = this.findCandidate(e.parent, candidates);
                    HashSet toMerge = Sets.newHashSet();
                    if (parentCandidate != null) {
                        toMerge.addAll(parentCandidate);
                    } else {
                        toMerge.add(e.parent);
                    }
                    HashSet toMergeActivities = Sets.newHashSet();
                    for (Object p2 : toMerge) {
                        toMergeActivities.add(((Node)p2).activity());
                    }
                    boolean canMerge = true;
                    p2 = mergeabilityTests.iterator();
                    while (p2.hasNext()) {
                        SetMergeabilityTest mergeabilityTest = (SetMergeabilityTest)p2.next();
                        String message = mergeabilityTest.canBeMerged(candidateActivities, toMergeActivities, candidatesActivities);
                        if (message == null) continue;
                        logger.info((Object)(" > " + message));
                        canMerge = false;
                        e.knownToNotBePossible = true;
                        break;
                    }
                    HashSet mergedPipelineActivities = Sets.newHashSet();
                    mergedPipelineActivities.addAll(candidateActivities);
                    mergedPipelineActivities.addAll(toMergeActivities);
                    for (SetPipelineabilityTest pipelineabilityTest : pipelineabilityTests) {
                        String message = pipelineabilityTest.canBePipelined(mergedPipelineActivities);
                        if (message == null) continue;
                        logger.info((Object)(" > " + message));
                        canMerge = false;
                        e.knownToNotBePossible = true;
                        break;
                    }
                    if (!canMerge) continue;
                    return e;
                }
            }
        }
        logger.info((Object)"No merge found");
        return null;
    }

    private void fillEdges(Node n) {
        JobActivity a = n.activity();
        for (JobActivity dep : a.dependencies) {
            Node s = this.nodes.get(this.nodeNoById.get(dep.id()));
            this.edges.add(new Edge(s, n));
        }
    }

    private void recFillNodes(JobActivity a) {
        if (a.getSubgraph() != null) {
            Node n = new Node(a, this.nodes.size());
            if (this.nodeNoById.containsKey(n.id())) {
                return;
            }
            this.nodes.add(n);
            this.nodeNoById.put(n.id(), n.no());
            this.nodeNoByActivityId.put(a.id(), n.no());
        }
        for (JobActivity dep : a.dependencies) {
            this.recFillNodes(dep);
        }
    }

    public class Node {
        private final JobActivity activity;
        private final int no;
        private Boolean canMerge;
        private Boolean canStart;

        public Node(JobActivity activity, int no) {
            this.activity = activity;
            this.no = no;
        }

        public JobActivity activity() {
            return this.activity;
        }

        public String id() {
            return this.activity.id();
        }

        public int no() {
            return this.no;
        }

        boolean canMerge() throws DKUSecurityException {
            if (this.canMerge == null) {
                this.canMerge = this.checkElement(ElementType.CAN_BE_PIPELINE_NON_TARGET_ELEMENT, MergeabilityGraph.this.pipelineType);
            }
            return this.canMerge;
        }

        boolean canStart() throws DKUSecurityException {
            if (this.canStart == null) {
                this.canStart = this.checkElement(ElementType.CAN_BE_PIPELINE_TARGET, MergeabilityGraph.this.pipelineType);
            }
            return this.canStart;
        }

        private boolean checkElement(ElementType elementType, RecipePipelineHelper.PipelineType pipelineType) throws DKUSecurityException {
            boolean isCheckKO;
            PipelineabilityEvaluator.Pipelineability p = new PipelineabilityEvaluator(pipelineType).isPipelineable(this.activity, MergeabilityGraph.this.authCtx);
            String prefix = switch (elementType) {
                case ElementType.CAN_BE_PIPELINE_TARGET -> {
                    isCheckKO = !p.start;
                    yield "start";
                }
                case ElementType.CAN_BE_PIPELINE_NON_TARGET_ELEMENT -> {
                    isCheckKO = !p.merge;
                    yield "merge";
                }
                default -> throw new IllegalStateException(String.format("Not managed element type: %s", new Object[]{elementType}));
            };
            if (isCheckKO) {
                logger.infoV("item %s not %s-pipelineable: can't include", new Object[]{this.activity.id(), prefix});
                return false;
            }
            for (FlowComputable flowComputable : this.activity.getSubgraph().getTargets()) {
                if (flowComputable.getType() == FlowComputable.FCType.DATASET) continue;
                logger.infoV("item %s, output %s not dataset: can't include", new Object[]{this.activity.id(), flowComputable.getFullId()});
                return false;
            }
            return true;
        }
    }

    protected class AcyclicityTest
    implements SetMergeabilityTest {
        private static final String WOULD_CREATE_A_CYCLE = "would create a cycle";

        protected AcyclicityTest() {
        }

        @Override
        public String canBeMerged(Set<JobActivity> activities, Set<JobActivity> added, List<Set<JobActivity>> candidatesActivities) {
            Set<Node> dependentsAc;
            Set<Node> dependentsAd;
            HashSet activitiesNodes = Sets.newHashSet();
            HashSet addedNodes = Sets.newHashSet();
            for (JobActivity a : activities) {
                activitiesNodes.add(this.getForActivity(a));
            }
            for (JobActivity a : added) {
                addedNodes.add(this.getForActivity(a));
            }
            Set<Node> dependenciesAc = this.dependenciesOf(activitiesNodes);
            if (!Sets.intersection(dependenciesAc, dependentsAd = this.dependentsOf(addedNodes)).isEmpty()) {
                return WOULD_CREATE_A_CYCLE;
            }
            Set<Node> dependenciesAd = this.dependenciesOf(addedNodes);
            if (!Sets.intersection(dependenciesAd, dependentsAc = this.dependentsOf(activitiesNodes)).isEmpty()) {
                return WOULD_CREATE_A_CYCLE;
            }
            HashMap idToCandidateNodes = Maps.newHashMap();
            for (Set<JobActivity> set : candidatesActivities) {
                HashSet candidateNodes = Sets.newHashSet();
                for (JobActivity a : set) {
                    candidateNodes.add(this.getForActivity(a));
                }
                for (Node n : candidateNodes) {
                    idToCandidateNodes.put(n.id(), candidateNodes);
                }
            }
            HashSet additionalDependentsAc = Sets.newHashSet();
            for (Node n : dependentsAc) {
                if (!idToCandidateNodes.containsKey(n.id())) continue;
                additionalDependentsAc.addAll((Collection)idToCandidateNodes.get(n.id()));
            }
            dependentsAc.addAll(additionalDependentsAc);
            HashSet hashSet = Sets.newHashSet();
            for (Node n : dependentsAd) {
                if (!idToCandidateNodes.containsKey(n.id())) continue;
                hashSet.addAll((Collection)idToCandidateNodes.get(n.id()));
            }
            dependentsAd.addAll(hashSet);
            if (!Sets.intersection(dependenciesAc, (Set)hashSet).isEmpty()) {
                return WOULD_CREATE_A_CYCLE;
            }
            if (!Sets.intersection(dependenciesAd, (Set)additionalDependentsAc).isEmpty()) {
                return WOULD_CREATE_A_CYCLE;
            }
            return null;
        }

        private Node getForActivity(JobActivity a) {
            return MergeabilityGraph.this.nodes.get(MergeabilityGraph.this.nodeNoByActivityId.get(a.id()));
        }

        private Set<Node> dependenciesOf(Set<Node> candidate) {
            HashSet dependencies = Sets.newHashSet(candidate);
            Set<Node> addition = this.getParents(dependencies);
            while (!addition.isEmpty()) {
                dependencies.addAll(addition);
                addition = this.getParents(dependencies);
            }
            dependencies.removeAll(candidate);
            return dependencies;
        }

        private Set<Node> dependentsOf(Set<Node> candidate) {
            HashSet dependents = Sets.newHashSet(candidate);
            Set<Node> addition = this.getChildren(dependents);
            while (!addition.isEmpty()) {
                dependents.addAll(addition);
                addition = this.getChildren(dependents);
            }
            dependents.removeAll(candidate);
            return dependents;
        }

        private Set<Node> getParents(Set<Node> set) {
            HashSet parents = Sets.newHashSet();
            for (Edge e : MergeabilityGraph.this.edges) {
                if (!set.contains(e.child) || set.contains(e.parent)) continue;
                parents.add(e.parent);
            }
            return parents;
        }

        private Set<Node> getChildren(Set<Node> set) {
            HashSet children = Sets.newHashSet();
            for (Edge e : MergeabilityGraph.this.edges) {
                if (!set.contains(e.parent) || set.contains(e.child)) continue;
                children.add(e.child);
            }
            return children;
        }
    }

    public class Edge {
        private final Node child;
        private final Node parent;
        private boolean knownToNotBePossible;

        Edge(Node parent, Node child) {
            this.parent = parent;
            this.child = child;
        }

        boolean canMerge() throws DKUSecurityException {
            return this.parent.canMerge() && (this.child.canMerge() || this.child.canStart());
        }
    }

    public static interface SetMergeabilityTest {
        public String canBeMerged(Set<JobActivity> var1, Set<JobActivity> var2, List<Set<JobActivity>> var3);
    }

    public static interface SetPipelineabilityTest {
        public String canBePipelined(Set<JobActivity> var1) throws IOException;
    }

    static enum ElementType {
        CAN_BE_PIPELINE_TARGET,
        CAN_BE_PIPELINE_NON_TARGET_ELEMENT;

    }
}

