/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.memimpl;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.memimpl.MemTableProcessor;
import com.dataiku.dip.security.DSSAuthCtx;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MemTableSISOWrapper
implements MemTableProcessor {
    private SingleInputSingleOutputRowProcessor siso;
    private int processedIn;
    MemoryAggregationOutput out;

    public MemTableSISOWrapper(SingleInputSingleOutputRowProcessor siso) {
        this.siso = siso;
    }

    @Override
    public void init() throws Exception {
        Object rproc;
        if (this.siso instanceof ProcessorWithResourceFiles) {
            rproc = (ProcessorWithResourceFiles)this.siso;
            rproc.setRequiredFiles(rproc.gatherRequirements());
        }
        if (this.siso instanceof ProcessorWithResolvedParams) {
            rproc = (ProcessorWithResolvedParams)this.siso;
            rproc.resolve(DSSAuthCtx.newNone(), "__DKU_ANY_PROJECT__");
        }
        if (this.siso instanceof ProcessorWithSubProcess) {
            rproc = (ProcessorWithSubProcess)this.siso;
            rproc.spawn(DSSAuthCtx.newNone(), "__DKU_ANY_PROJECT__", false, null);
        }
    }

    @Override
    public void process(MemTable table) throws Exception {
        this.out = new MemoryAggregationOutput();
        this.siso.setProcessorOutput((ProcessorOutput)this.out);
        this.siso.setFactories((ColumnFactory)table, (RowFactory)table);
        try {
            this.siso.init();
            for (MemRow memRow : table.rows) {
                this.siso.processRow((Row)memRow);
                ++this.processedIn;
            }
            this.siso.postProcess();
            table.rows.clear();
            for (Row row : this.out.rows) {
                table.rows.add((MemRow)row);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"dku.siso.wrapper").error((Object)"Failed during processing of rows, cleanup resources", (Throwable)e);
            this.siso.cancel();
            throw e;
        }
    }

    @Override
    public int processedInputRows() {
        return this.processedIn;
    }

    @Override
    public int generatedOutputRows() {
        int o = 0;
        for (int i = 0; i < this.out.rows.size(); ++i) {
            if (((MemRow)this.out.rows.get(i)).isDeleted()) continue;
            ++o;
        }
        return o;
    }

    public static class MemoryAggregationOutput
    extends SinkProcessorOutput {
        public List<Row> rows = new ArrayList<Row>();
        private long maxMemoryUsed = -1L;
        private long memoryUsed = 0L;
        private final String stepName;

        public MemoryAggregationOutput() {
            this.stepName = null;
        }

        public MemoryAggregationOutput(String stepName) {
            this.stepName = stepName;
        }

        public void emitRow(Row row) throws MemTableAppendingOutput.MemTableSizeLimitReachedException {
            this.rows.add(row);
            this.memoryUsed += ((MemRow)row).getMemoryUsed();
            if (this.maxMemoryUsed > 0L && this.memoryUsed >= this.maxMemoryUsed) {
                throw new MemTableAppendingOutput.MemTableSizeLimitReachedException(this.rows.size(), this.memoryUsed, this.stepName);
            }
        }

        public void setMaxMemoryUsed(long size) {
            this.maxMemoryUsed = size;
        }
    }
}

