/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalineage;

import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.expressions.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class DataLineageUtils {
    private DataLineageUtils() {
    }

    public static Map<String, List<String>> getComputedColumnsInputs(@Nullable List<ComputedColumn> computedColumns) {
        return Stream.ofNullable(computedColumns).flatMap(Collection::stream).filter(computedColumn -> computedColumn.mode == ComputedColumn.Mode.GREL).collect(Collectors.toMap(computedColumn -> computedColumn.name, computedColumn -> {
            Expression expression = new Expression(computedColumn.expr);
            expression.setVariablesContext(computedColumn.exprVariablesContext);
            return expression.getVariables();
        }));
    }

    public static boolean shouldMarkLineageUncertain(@Nullable List<ComputedColumn> computedColumns) {
        return Stream.ofNullable(computedColumns).flatMap(Collection::stream).anyMatch(computedColumn -> computedColumn.mode == ComputedColumn.Mode.SQL);
    }
}

