/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DelegateFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class UploadedFilesDatasetHandler
extends DelegateFSDatasetHandler {
    private static final DKULogger logger = DKULogger.getLogger(UploadedFilesDatasetHandler.class);
    private boolean forceRealDatasetAsManaged = true;

    public UploadedFilesDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    public void setForFormatTestOnly() {
        this.forceRealDatasetAsManaged = false;
    }

    @Override
    protected void buildReal() throws IOException {
        BuiltinFSDatasets.UploadedFilesConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class);
        Dataset subDs = Dataset.fromSerialized(this.dataset.serialize());
        if (StringUtils.isBlank((String)config.getConnection()) || config.uploadedConfig == null || StringUtils.isBlank((String)config.uploadFSProviderType)) {
            File folder = FileUploadService.datasetOrUploadBoxDir(this.dataset);
            subDs.setType("Filesystem");
            FilesystemDatasetConfig subDsConfig = new FilesystemDatasetConfig();
            subDsConfig.connection = null;
            subDsConfig.path = folder.getAbsolutePath();
            subDsConfig.previewFile = config.previewFile;
            subDsConfig.sheetName = config.sheetName;
            subDs.setParams(subDsConfig);
        } else {
            String providerType = config.uploadFSProviderType;
            DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(providerType);
            config.uploadedConfig.addProperty("connection", config.getConnection());
            DatasetHandler.DatasetParams subDsParams = (DatasetHandler.DatasetParams)JSON.parse((JsonElement)config.uploadedConfig, meta.paramsClass());
            subDs.setType(providerType);
            subDs.setParams(subDsParams);
        }
        subDs = Dataset.fromSerialized(subDs.serialize());
        if (this.forceRealDatasetAsManaged) {
            subDs.setManaged(true);
        }
        this.setRealDataset(subDs);
        this.setRealHandler((AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.getRealDataset()));
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        logger.info((Object)"Executing post-create on uploaded dataset");
        boolean ret = super.executeFastPostCreateOperations();
        BuiltinFSDatasets.UploadedFilesConfig config = this.getDataset().getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class);
        if (config.uploadBoxId != null) {
            LocalFSProvider datasetProvider;
            logger.info((Object)"There is an upload box");
            File uploadBox = FileUploadService.uploadBoxDir(config.uploadBoxId);
            LocalFSProvider uploadBoxProvider = LocalFSProvider.makeFSProviderOnRoot(uploadBox.getAbsolutePath());
            if (StringUtils.isNotBlank((String)config.uploadConnection) && StringUtils.isNotBlank((String)config.uploadFSProviderType)) {
                logger.info((Object)("There is a connection " + config.uploadConnection + " and fs provider type " + config.uploadFSProviderType));
                config.connection = config.uploadConnection;
                config.uploadConnection = null;
                logger.info((Object)("Creating target " + config.uploadFSProviderType + " FSProvider with config=" + JSON.log((Object)config)));
                String providerType = config.uploadFSProviderType;
                Iterator connection = ConnectionsDAO.get().getMandatoryConnection(this.authCtx, config.connection);
                new FSProviderConnectionFactory().prepareConnectionForProvider(providerType, this.authCtx, (DSSConnection)((Object)connection));
                BuiltinFSDatasets.FSDatasetMeta fsMeta = (BuiltinFSDatasets.FSDatasetMeta)DatasetHandlerFactory.getMeta(providerType);
                AbstractFSDatasetHandler.AbstractFSConfig subConfig = fsMeta.createUploadedDatasetParams(this.getDataset().getProjectKey(), this.getDataset().getName(), (DSSConnection)((Object)connection));
                String resolvedDatasetPath = VariablesUtils.expand(this.getDataset().getProjectKey(), subConfig.path);
                logger.info((Object)("Effective target " + providerType + " FSProvider with config=" + JSON.log((Object)subConfig) + " resolvedPath=" + resolvedDatasetPath));
                config.uploadedConfig = JSON.toJsonObject((Object)subConfig, (String[])new String[0]);
                this.buildReal();
                datasetProvider = this.getRealHandler().getProvider();
            } else {
                datasetProvider = LocalFSProvider.makeFSProviderOnRoot(FileUploadService.localDatasetDir(this.getDataset().getProjectKey(), this.getDataset().getName()).getAbsolutePath());
            }
            try {
                logger.info((Object)("Upload box is at " + uploadBoxProvider.getRoot()));
                FSEnumerationResult uploadedFiles = uploadBoxProvider.enumerateRecursive("/", new FSEnumerationSettings());
                if (uploadedFiles.isSuccessful() && uploadedFiles.getPaths() != null) {
                    if (datasetProvider instanceof LocalFSProvider) {
                        logger.info((Object)("Dataset stored on filesystem, moving files to final location: " + datasetProvider.getRoot()));
                        for (FSPath path : uploadedFiles.getPaths()) {
                            if (config.files != null && !config.files.contains(path.path())) {
                                logger.debug((Object)("Ignoring path " + path.path()));
                                continue;
                            }
                            File from = new File(PathUtils.concatLNT((String[])new String[]{uploadBoxProvider.getRoot(), path.path()}));
                            File to = new File(PathUtils.concatLNT((String[])new String[]{datasetProvider.getRoot(), path.path()}));
                            DKUFileUtils.mkdirsParent((File)to);
                            if (StringUtils.isNotBlank((String)config.sheetName)) {
                                FileUtils.copyFile((File)from, (File)to);
                                continue;
                            }
                            if (from.renameTo(to)) continue;
                            logger.warn((Object)("Unable to rename " + String.valueOf(from) + " into " + String.valueOf(to) + ", trying to copy instead"));
                            FileUtils.copyFile((File)from, (File)to);
                            if (from.delete()) continue;
                            logger.warn((Object)("Unable to delete (after copy) " + String.valueOf(from)));
                        }
                    } else {
                        logger.info((Object)"Dataset not stored on filesystem, copying files to final location");
                        this.getRealHandler().createManaged();
                        for (FSPath path : uploadedFiles.getPaths()) {
                            if (config.files != null && !config.files.contains(path.path())) {
                                logger.debug((Object)("Ignoring path " + path.path()));
                                continue;
                            }
                            logger.info((Object)("Copy : " + path.path()));
                            InputStream is = uploadBoxProvider.read(path.path()).rawStream();
                            try {
                                OutputStream os = datasetProvider.write(path.path());
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    if (os == null) continue;
                                    os.close();
                                }
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        if (datasetProvider instanceof HDFSProvider) {
                            new HDFSPermissionsSynchronizer().setPermissionsOnDataset_NT(this.authCtx, this.dataset.getProjectKey(), this.dataset.serialize());
                        }
                    }
                }
                String uploadBoxId = config.uploadBoxId;
                config.uploadBoxId = null;
                logger.info((Object)("After params:" + JSON.log((Object)this.getDataset().getParams())));
                if (config.files == null) {
                    FileUploadService.deleteUploadBox(uploadBoxId);
                } else if (StringUtils.isBlank((String)config.sheetName)) {
                    for (String file : config.files) {
                        FileUploadService.deleteFileFromUploadBox(uploadBoxId, file);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                uploadBoxProvider.close();
                datasetProvider.close();
            }
        }
        return ret;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.UPLOADED_FILES_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        DatasetTestHandler testHandler = this.getRealHandler().buildTestHandler();
        if (testHandler instanceof FSLikeDatasetTestHandler) {
            ((FSLikeDatasetTestHandler)testHandler).setHandlerForName(this);
        }
        return testHandler;
    }

    @Override
    public String suggestName() {
        BuiltinFSDatasets.UploadedFilesConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class);
        if (StringUtils.isNotBlank((String)config.previewFile)) {
            Object name = DatasetHandlerFactory.nameFromFileName(config.previewFile);
            if (StringUtils.isNotBlank((String)config.sheetName)) {
                name = (String)name + "_" + DatasetHandlerFactory.nameFromFileName(config.sheetName);
            }
            return name;
        }
        File folder = FileUploadService.datasetOrUploadBoxDir(this.dataset);
        logger.debug((Object)("Suggesting name from " + String.valueOf(folder)));
        if (!folder.isDirectory()) {
            return null;
        }
        for (File f : folder.listFiles()) {
            logger.debug((Object)("FILE " + String.valueOf(f)));
            if (f.isDirectory()) continue;
            return DatasetHandlerFactory.nameFromFileName(f.getName());
        }
        return null;
    }
}

