/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.GenericRecord;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IcebergValueConverter {
    private DateTimeFormatter datetimenotzFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private DateTimeFormatter datetimetzFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private DateTimeFormatter dateonlyFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private DateTimeFormatter hourPartitioningFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH");
    private Boolean booleanParser = new Boolean();
    private Date datetimetzParser = new Date();
    private DatetimeNoTz datetimenotzParser = new DatetimeNoTz();
    private DateOnly dateonlyParser = new DateOnly();
    private ZoneId utcZone = ZoneId.of("UTC");

    public String toDSSValue(Object value, Type type) {
        if (value == null) {
            return null;
        }
        Object converted = this.toDSSInternalValue(value, type);
        if (value instanceof List || value instanceof Map || value instanceof StructLike) {
            return JSON.json((Object)converted);
        }
        return converted.toString();
    }

    public Object toDSSInternalValue(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dt = (LocalDateTime)value;
            return this.datetimenotzFormatter.format(dt);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime dt = (OffsetDateTime)value;
            return this.datetimetzFormatter.format(dt);
        }
        if (value instanceof LocalDate) {
            LocalDate dt = (LocalDate)value;
            return this.dateonlyFormatter.format(dt);
        }
        if (value instanceof List) {
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object v : (List)value) {
                converted.add(this.toDSSInternalValue(v, ((Types.ListType)type).elementType()));
            }
            return converted;
        }
        if (value instanceof Map) {
            HashMap<Object, Object> converted = new HashMap<Object, Object>();
            for (Map.Entry e : ((Map)value).entrySet()) {
                Object k = this.toDSSInternalValue(e.getKey(), ((Types.MapType)type).keyType());
                Object v = this.toDSSInternalValue(e.getValue(), ((Types.MapType)type).valueType());
                converted.put(k, v);
            }
            return converted;
        }
        if (value instanceof StructLike) {
            StructLike struct = (StructLike)value;
            HashMap<String, Object> converted = new HashMap<String, Object>();
            for (int i = 0; i < struct.size(); ++i) {
                Types.NestedField field = (Types.NestedField)((Types.StructType)type).fields().get(i);
                converted.put(field.name(), this.toDSSInternalValue(struct.get(i, field.type().typeId().javaClass()), field.type()));
            }
            return converted;
        }
        if (value instanceof Integer && type.typeId() == Type.TypeID.DATE) {
            return this.toDSSInternalValue(LocalDate.ofEpochDay(((Integer)value).intValue()), type);
        }
        if (value instanceof Long && type.typeId() == Type.TypeID.TIMESTAMP) {
            Instant instant = Instant.ofEpochMilli((Long)value / 1000L);
            if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                return this.toDSSInternalValue(OffsetDateTime.ofInstant(instant, ZoneOffset.UTC), type);
            }
            return this.toDSSInternalValue(LocalDateTime.ofInstant(instant, ZoneOffset.UTC), type);
        }
        if (value instanceof Long && type.typeId() == IcebergUtils.getTimestampNanoTypeId()) {
            Instant instant = Instant.ofEpochMilli((Long)value / 1000000L);
            if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                return this.toDSSInternalValue(OffsetDateTime.ofInstant(instant, ZoneOffset.UTC), type);
            }
            return this.toDSSInternalValue(LocalDateTime.ofInstant(instant, ZoneOffset.UTC), type);
        }
        return value;
    }

    public Object toIcebergValue(String value, Type type) {
        if (value == null) {
            return null;
        }
        if (type.typeId() == IcebergUtils.getTimestampNanoTypeId()) {
            if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.datetimetzParser.msSinceEpoch(value)), this.utcZone);
            }
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.datetimenotzParser.msSinceEpoch(value)), this.utcZone);
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return this.booleanParser.parse(value);
            }
            case INTEGER: {
                Long l = this.tryParseLongWithDotZeroStrip(value);
                return l == null ? null : Integer.valueOf(l.intValue());
            }
            case LONG: {
                return this.tryParseLongWithDotZeroStrip(value);
            }
            case FLOAT: {
                Double d = DKUDoubles.tryParse((String)value);
                return d == null ? null : Float.valueOf(d.floatValue());
            }
            case DOUBLE: {
                return DKUDoubles.tryParse((String)value);
            }
            case STRING: {
                return value;
            }
            case DATE: {
                return LocalDate.ofEpochDay(this.dateonlyParser.msSinceEpoch(value) / 86400000L);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.datetimetzParser.msSinceEpoch(value)), this.utcZone);
                }
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.datetimenotzParser.msSinceEpoch(value)), this.utcZone);
            }
            case LIST: {
                JsonArray array = (JsonArray)JSON.parse((String)value, JsonArray.class);
                ArrayList<Object> ret = new ArrayList<Object>();
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement e = array.get(i);
                    String ev = e.isJsonNull() ? null : (e.isJsonPrimitive() ? e.getAsString() : e.toString());
                    ret.add(this.toIcebergValue(ev, ((Types.ListType)type).elementType()));
                }
                return ret;
            }
            case MAP: {
                Map map = (Map)JSON.parse((String)value, (TypeToken)new TypeToken<Map<Object, Object>>(){});
                HashMap<Object, Object> ret = new HashMap<Object, Object>();
                for (Map.Entry e : map.entrySet()) {
                    Object k = this.toIcebergValue(e.getKey().toString(), ((Types.MapType)type).keyType());
                    Object v = this.toIcebergValue(e.getValue().toString(), ((Types.MapType)type).valueType());
                    ret.put(k, v);
                }
                return ret;
            }
            case STRUCT: {
                JsonObject object = (JsonObject)JSON.parse((String)value, JsonObject.class);
                Types.StructType structType = (Types.StructType)type;
                GenericRecord ret = GenericRecord.create((Types.StructType)structType);
                for (Types.NestedField subField : structType.fields()) {
                    if (!object.has(subField.name())) continue;
                    JsonElement subValue = object.get(subField.name());
                    String ev = subValue.isJsonNull() ? null : (subValue.isJsonPrimitive() ? subValue.getAsString() : subValue.toString());
                    ret.setField(subField.name(), this.toIcebergValue(ev, subField.type()));
                }
                return ret;
            }
        }
        return value;
    }

    private Long tryParseLongWithDotZeroStrip(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.endsWith(".0")) {
            if (value.length() == 2) {
                return 0L;
            }
            String integralValue = value.substring(0, value.length() - 2);
            return DKULongs.tryParse((String)integralValue);
        }
        return DKULongs.tryParse((String)value);
    }

    public Object toIcebergValue(DimensionValue dimensionValue, Type type) {
        if (dimensionValue instanceof ExactValueDimensionValue) {
            return this.toIcebergValue(dimensionValue.id(), type);
        }
        if (dimensionValue instanceof TimeDimensionValue) {
            TimeDimensionValue timeDimensionValue = (TimeDimensionValue)dimensionValue;
            TimeDimension timeDimension = timeDimensionValue.getDimension();
            if (type.typeId() == IcebergUtils.getTimestampNanoTypeId()) {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return OffsetDateTime.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC);
                }
                return LocalDateTime.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC);
            }
            return switch (type.typeId()) {
                case Type.TypeID.STRING -> timeDimensionValue.getPeriodValue(timeDimension.mappedPeriod);
                case Type.TypeID.DATE -> {
                    if (timeDimension.mappedPeriod == TimeDimension.Period.HOUR) {
                        throw new IllegalArgumentException("Can't use type DATE for a hourly time partitioning");
                    }
                    yield LocalDate.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC);
                }
                case Type.TypeID.TIMESTAMP -> {
                    if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                        yield OffsetDateTime.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC);
                    }
                    yield LocalDateTime.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC);
                }
                default -> throw new IllegalArgumentException("Can't use type " + String.valueOf(type.typeId()) + " for a time partitioning");
            };
        }
        throw new IllegalArgumentException("Unexpected partitioning dimension value " + dimensionValue.getClass().getCanonicalName());
    }

    public Object toIcebergLiteralValue(DimensionValue dimensionValue, Type type) {
        if (dimensionValue instanceof ExactValueDimensionValue) {
            return this.toIcebergValue(dimensionValue.id(), type);
        }
        if (dimensionValue instanceof TimeDimensionValue) {
            TimeDimensionValue timeDimensionValue = (TimeDimensionValue)dimensionValue;
            TimeDimension timeDimension = timeDimensionValue.getDimension();
            if (type.typeId() == IcebergUtils.getTimestampNanoTypeId()) {
                return timeDimensionValue.getUTCCalendar().toInstant().toEpochMilli() * 1000000L;
            }
            return switch (type.typeId()) {
                case Type.TypeID.STRING -> timeDimensionValue.getPeriodValue(timeDimension.mappedPeriod);
                case Type.TypeID.DATE -> {
                    if (timeDimension.mappedPeriod == TimeDimension.Period.HOUR) {
                        throw new IllegalArgumentException("Can't use type DATE for a hourly time partitioning");
                    }
                    yield (int)LocalDate.ofInstant(timeDimensionValue.getUTCCalendar().toInstant(), ZoneOffset.UTC).toEpochDay();
                }
                case Type.TypeID.TIMESTAMP -> timeDimensionValue.getUTCCalendar().toInstant().toEpochMilli() * 1000L;
                default -> throw new IllegalArgumentException("Can't use type " + String.valueOf(type.typeId()) + " for a time partitioning");
            };
        }
        throw new IllegalArgumentException("Unexpected partitioning dimension value " + dimensionValue.getClass().getCanonicalName());
    }

    public String toDSSPartitionValue(Object value, Type type, Transform<?, ?> transform) {
        if (transform == null || transform.isIdentity()) {
            return this.toDSSValue(value, type);
        }
        if (transform.toString().equals("year")) {
            if (value instanceof Number) {
                int delta = ((Number)value).intValue();
                return String.valueOf(1970 + delta);
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof LocalDate) {
                return "" + ((LocalDate)value).getYear();
            }
            if (value instanceof LocalDateTime) {
                return "" + ((LocalDateTime)value).getYear();
            }
            if (value instanceof OffsetDateTime) {
                return "" + ((OffsetDateTime)value).getYear();
            }
            throw new IllegalArgumentException("Unable to convert value of type " + value.getClass().getCanonicalName() + " to year");
        }
        if (transform.toString().equals("month")) {
            if (value instanceof Number) {
                int delta = ((Number)value).intValue();
                int year = 1970 + delta / 12;
                int month = 1 + delta % 12;
                return String.format("%04d-%02d", year, month);
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof LocalDate) {
                return this.dateonlyFormatter.format((LocalDate)value).substring(0, 7);
            }
            if (value instanceof LocalDateTime) {
                return this.dateonlyFormatter.format((LocalDateTime)value).substring(0, 7);
            }
            if (value instanceof OffsetDateTime) {
                return this.dateonlyFormatter.format((OffsetDateTime)value).substring(0, 7);
            }
            throw new IllegalArgumentException("Unable to convert value of type " + value.getClass().getCanonicalName() + " to month");
        }
        if (transform.toString().equals("day")) {
            if (value instanceof Number) {
                int delta = ((Number)value).intValue();
                LocalDate date = LocalDate.ofEpochDay(delta);
                return this.dateonlyFormatter.format(date);
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof LocalDate) {
                return this.dateonlyFormatter.format((LocalDate)value);
            }
            if (value instanceof LocalDateTime) {
                return this.dateonlyFormatter.format((LocalDateTime)value);
            }
            if (value instanceof OffsetDateTime) {
                return this.dateonlyFormatter.format((OffsetDateTime)value);
            }
            throw new IllegalArgumentException("Unable to convert value of type " + value.getClass().getCanonicalName() + " to month");
        }
        if (transform.toString().equals("hour")) {
            if (value instanceof Number) {
                int delta = ((Number)value).intValue();
                LocalDateTime datetime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC).plusHours(delta);
                return this.dateonlyFormatter.format(datetime);
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof LocalDate) {
                return this.hourPartitioningFormatter.format((LocalDate)value);
            }
            if (value instanceof LocalDateTime) {
                return this.hourPartitioningFormatter.format((LocalDateTime)value);
            }
            if (value instanceof OffsetDateTime) {
                return this.hourPartitioningFormatter.format((OffsetDateTime)value);
            }
            throw new IllegalArgumentException("Unable to convert value of type " + value.getClass().getCanonicalName() + " to month");
        }
        throw new IllegalArgumentException("Unsupported transform " + transform.getClass().getCanonicalName());
    }
}

