/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.AbstractElementLoadedDesc;
import com.dataiku.dip.datasets.sample.SampleDatasetDesc;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LoadedSampleDataset
extends AbstractElementLoadedDesc {
    public final SampleDatasetDesc desc;
    public final Map<String, AvailableDataset> configMap;
    private final String activeVersion;
    private final String datasetType;

    public LoadedSampleDataset(String id, String ownerPluginId, String datasetType, SampleDatasetDesc desc, Map<String, AvailableDataset> configMap, String activeVersion) {
        super(id, ownerPluginId);
        this.datasetType = datasetType;
        this.desc = desc;
        this.configMap = configMap;
        this.activeVersion = activeVersion;
    }

    public AvailableDataset getDataset(String version) {
        return this.configMap.get(version == null ? "" : version);
    }

    public boolean doesActiveDatasetExist() {
        return this.configMap.containsKey(this.activeVersion);
    }

    public String getActiveVersion() {
        return this.activeVersion;
    }

    @Override
    public String getType() {
        return this.datasetType;
    }

    @Override
    public List<ParamDesc> getParams() {
        return Collections.emptyList();
    }

    @Override
    public String getPythonSetupFileName() {
        throw new NotImplementedException();
    }

    public int getDisplayOrderRank() {
        return this.desc.meta.displayOrderRank;
    }

    static class AvailableDataset {
        String label;
        String description;
        String path;
        List<SchemaColumn> columns = new ArrayList<SchemaColumn>();
        Integer rowCount;

        AvailableDataset() {
        }
    }
}

