/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.db.AbstractConnectionFactory;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionDebugMonitor;
import com.dataiku.dip.db.ExternalDatabaseConnectionFactory;
import com.dataiku.dip.db.SingleH2DatabaseConnectionsFactory;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.h2.tools.Server;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSDBConnectionsManagementService {
    private static final String PREFIX_TEMPLATE = "dku.dssdb.%s.connectionPool";
    private static final String PREFIX_EXTERNAL_DB = "external";
    private static final String PREFIX_INTERNAL_DB = "h2";
    private static final long LOG_CONNECTION_ACQUISITION_DURATION = 10000L;
    private static int maxPooledConnections;
    private static long connectionsEvictionTimeMS;
    private static long evictionIntervalMS;
    private static boolean useLifoPool;
    private static String tablePrefix;
    private static boolean isUsingInternalH2;
    private static SQLDialect dialect;
    private static SQLConnectionProvider.SQLConnectionData sqlConnectionData;
    private static String schema;
    private static final String TIMELINE_PREFIX = "timeline";
    private static boolean initialized;
    private DSSDBConnectionDebugMonitor connectionMonitor = new DSSDBConnectionDebugMonitor();
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    private ConnectionPool singleDBConnectionPool;
    private Map<String, ConnectionPool> multiDBConnectionPools = new HashMap<String, ConnectionPool>();
    private static DKULogger logger;

    private static synchronized void internalInit() {
        if (initialized) {
            return;
        }
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        DSSDBConnectionsManagementService.setStaticFieldsFromConf(generalSettings.internalDatabase);
        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.BACKEND) {
            if (!isUsingInternalH2) {
                logger.info((Object)"External databases mode enabled, not starting H2 servers");
            } else {
                try {
                    logger.warn((Object)"Starting H2 Servers for jobs, dss_usage and flow_state");
                    ServersMappingFile smf = new ServersMappingFile();
                    ServerMapping jobs = new ServerMapping();
                    jobs.key = SecretKeyGenerator.generate((int)16);
                    Server jobsh2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", jobs.key, ApplicationConfigurator.getFile((String)"databases/jobs").getAbsolutePath()});
                    jobsh2TCPServer.start();
                    jobs.port = jobsh2TCPServer.getPort();
                    smf.servers.put("jobs", jobs);
                    ServerMapping dssUsage = new ServerMapping();
                    dssUsage.key = SecretKeyGenerator.generate((int)16);
                    Server dssUsageh2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", dssUsage.key, ApplicationConfigurator.getFile((String)"databases/dss_usage").getAbsolutePath()});
                    dssUsageh2TCPServer.start();
                    dssUsage.port = dssUsageh2TCPServer.getPort();
                    smf.servers.put("dss_usage", dssUsage);
                    ServerMapping flowState = new ServerMapping();
                    flowState.key = SecretKeyGenerator.generate((int)16);
                    Server flowStateh2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", flowState.key, ApplicationConfigurator.getFile((String)"databases/flow_state").getAbsolutePath()});
                    flowStateh2TCPServer.start();
                    flowState.port = flowStateh2TCPServer.getPort();
                    smf.servers.put("flow_state", flowState);
                    ServerMapping hiveCatalog = new ServerMapping();
                    hiveCatalog.key = SecretKeyGenerator.generate((int)16);
                    Server hiveCatalogH2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", hiveCatalog.key, ApplicationConfigurator.getFile((String)"databases/hive-catalog").getAbsolutePath()});
                    hiveCatalogH2TCPServer.start();
                    hiveCatalog.port = hiveCatalogH2TCPServer.getPort();
                    smf.servers.put("hive-catalog", hiveCatalog);
                    ServerMapping experiments = new ServerMapping();
                    experiments.key = SecretKeyGenerator.generate((int)16);
                    Server experimentsH2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", experiments.key, ApplicationConfigurator.getFile((String)"databases/experiments").getAbsolutePath()});
                    experimentsH2TCPServer.start();
                    experiments.port = experimentsH2TCPServer.getPort();
                    smf.servers.put("experiments", experiments);
                    ServerMapping labeling = new ServerMapping();
                    labeling.key = SecretKeyGenerator.generate((int)16);
                    Server labelingH2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", labeling.key, ApplicationConfigurator.getFile((String)"databases/labelings").getAbsolutePath()});
                    labelingH2TCPServer.start();
                    labeling.port = labelingH2TCPServer.getPort();
                    smf.servers.put("labelings", labeling);
                    ServerMapping agentReview = new ServerMapping();
                    agentReview.key = SecretKeyGenerator.generate((int)16);
                    Server agentReviewH2TCPServer = Server.createTcpServer((String[])new String[]{"-trace", "-tcp", "-tcpPort", "0", "-key", agentReview.key, ApplicationConfigurator.getFile((String)"databases/agent-review").getAbsolutePath()});
                    agentReviewH2TCPServer.start();
                    agentReview.port = agentReviewH2TCPServer.getPort();
                    smf.servers.put("agent-review", agentReview);
                    JSON.prettyToFile((Object)smf, (File)ApplicationConfigurator.getFile((String)"run/dbservers.json"));
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        }
        initialized = true;
    }

    private static synchronized void setStaticFieldsFromConf(GeneralSettingsDAO.InternalDBConnectionSettings internalDatabaseConf) {
        boolean bl = isUsingInternalH2 = internalDatabaseConf.connection == null;
        if (isUsingInternalH2) {
            dialect = new H2SQLDialect();
            maxPooledConnections = internalDatabaseConf.maxPooledBuiltinConnectionsPerDatabase;
            connectionsEvictionTimeMS = internalDatabaseConf.builtinConnectionsMaxIdleTimeMS;
            evictionIntervalMS = internalDatabaseConf.builtinConnectionsValidationIntervalMS;
        } else {
            try {
                internalDatabaseConf.connection.forceLocalResolution = true;
                sqlConnectionData = ((AbstractSQLConnection)internalDatabaseConf.connection).getConnectionData_NT(DSSAuthCtx.newNone(), null);
            }
            catch (DKUSecurityException | SQLException e) {
                throw new RuntimeException("Unable to create connection", e);
            }
            dialect = sqlConnectionData.getDialect();
            schema = internalDatabaseConf.schema;
            tablePrefix = internalDatabaseConf.tableNamePrefix;
            maxPooledConnections = internalDatabaseConf.maxPooledExternalConnections;
            connectionsEvictionTimeMS = internalDatabaseConf.externalConnectionsMaxIdleTimeMS;
            evictionIntervalMS = internalDatabaseConf.externalConnectionsValidationIntervalMS;
            useLifoPool = internalDatabaseConf.useLifoPool;
        }
        if (tablePrefix == null) {
            tablePrefix = "";
        }
    }

    public DSSDBConnection acquire(AbstractDSSDBService.DSSDBRef ref) throws CodedSQLException {
        return this.acquire(ref, false);
    }

    public DSSDBConnection acquire(AbstractDSSDBService.DSSDBRef ref, boolean isReadOnly) throws CodedSQLException {
        try {
            logger.trace(() -> "Acquiring connection to DSS DB: " + ref.name);
            long startBorrowMS = System.currentTimeMillis();
            DSSDBConnection conn = this.getConnectionPool(ref).borrowObject(isReadOnly);
            long borrowDurationMS = System.currentTimeMillis() - startBorrowMS;
            DSSMetrics.registry().meter("dku.dssdb." + ref.nameForConfigKey + ".acquiredConnections").mark();
            DSSMetrics.registry().meter("dku.dssdb.total.acquiredConnections").mark();
            logger.traceV("Acquired DSSDBConnection %s in %dms", new Object[]{conn.debugId, borrowDurationMS});
            if (borrowDurationMS >= 10000L) {
                logger.warnV("Acquiring connection to DSS runtime DB %s took %dms", new Object[]{ref.name, borrowDurationMS});
            }
            return conn;
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to acquire connection to DSS DB: " + ref.name, (Throwable)e);
        }
    }

    static int getCurrentSchemaVersion(DSSDBConnection conn, SQLUtils.SQLTable dssSchemaInfoTable, String versionId, SQLDialect dialect) {
        int schemaVersion = 0;
        try (Statement st2 = conn.createStatement();){
            schemaVersion = DSSDBConnectionsManagementService.tryToGetSchemaVersion(conn, dssSchemaInfoTable, versionId, dialect);
            logger.debug((Object)("current version for " + versionId + ": " + schemaVersion));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null && (message.contains("not found") || message.contains("not exist"))) {
                logger.infoV("No schema version yet for internal database %s: %s", new Object[]{versionId, message});
            }
            logger.info((Object)("Failed to get schema version for internal database " + versionId), (Throwable)e);
        }
        return schemaVersion;
    }

    public SQLDialect getDialect() {
        DSSDBConnectionsManagementService.internalInit();
        return dialect;
    }

    public boolean isUsingInternalH2() {
        DSSDBConnectionsManagementService.internalInit();
        return isUsingInternalH2;
    }

    String getTablePrefix() {
        return tablePrefix;
    }

    String getCatalog() {
        return null;
    }

    String getSchema() {
        return schema;
    }

    private static String buildH2JdbcUrl(AbstractDSSDBService.DSSDBRef ref) {
        return DSSDBConnectionsManagementService.buildH2JdbcUrl(ref.name, ref.autoServer, ref.h2File, ref.lockTimeout, ref.nameForConfigKey);
    }

    public static String buildH2JdbcUrl(String name, boolean autoServer, File file, int lockTimeout, String nameForConfigKey) {
        String jdbcUrl;
        Object timeout;
        Object additionalOptions = ApplicationConfigurator.getProperty((String)("dku.internalDatabases." + nameForConfigKey), null);
        if (additionalOptions != null) {
            additionalOptions = ";" + (String)additionalOptions;
            logger.debugV(" Using additional options: %s", new Object[]{additionalOptions});
        } else {
            additionalOptions = "";
        }
        Object object = timeout = lockTimeout != 0 ? ";LOCK_TIMEOUT=" + lockTimeout : "";
        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.DKU) {
            jdbcUrl = "jdbc:h2:" + file.getAbsolutePath();
        } else if (autoServer) {
            ServerMapping mapping = DSSDBConnectionsManagementService.getMappingForServer(name);
            jdbcUrl = "jdbc:h2:tcp://127.0.0.1:" + mapping.port + "/" + mapping.key;
        } else {
            jdbcUrl = "jdbc:h2:" + file.getAbsolutePath();
        }
        jdbcUrl = jdbcUrl + ";TRACE_LEVEL_SYSTEM_OUT=0;TRACE_LEVEL_FILE=4" + (String)timeout + (String)additionalOptions;
        return jdbcUrl;
    }

    static boolean isProjectTimeline(String name) {
        return name.startsWith(TIMELINE_PREFIX);
    }

    private static int tryToGetSchemaVersion(DSSDBConnection conn, SQLUtils.SQLTable dssSchemaInfo, String versionId, SQLDialect dialect) throws SQLException {
        int n;
        block15: {
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            SelectQueryBuilder versionQB = new SelectQueryBuilder();
            versionQB.from(dssSchemaInfo, "t");
            versionQB.select("SCHEMA_VERSION");
            versionQB.where(ebf.col("INTERNAL_ID").eq(ebf.cst(versionId)));
            Statement st2 = conn.createStatement();
            try {
                int schemaVersion;
                st2.execute(versionQB.toSQL(dialect));
                try (ResultSet rs2 = st2.getResultSet();){
                    boolean next = rs2.next();
                    schemaVersion = !next ? 0 : rs2.getInt("SCHEMA_VERSION");
                }
                n = schemaVersion;
                if (st2 == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (st2 != null) {
                        try {
                            st2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.debug((Object)("Could not find schema info, considering not-existing: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    conn.rollback();
                    throw e;
                }
            }
            st2.close();
        }
        return n;
    }

    static String buildMultiDBMetricName(String main, String suffix) {
        return DSSDBConnectionsManagementService.buildMetricName(PREFIX_INTERNAL_DB, main, suffix);
    }

    static String buildSingleDBMetricName(String suffix) {
        return DSSDBConnectionsManagementService.buildMetricName(PREFIX_EXTERNAL_DB, null, suffix);
    }

    private static String buildMetricName(String prefix, @Nullable String main, String suffix) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(String.format(PREFIX_TEMPLATE, prefix));
        if (StringUtils.isNotBlank((String)main)) {
            elements.add(main);
        }
        elements.add(suffix);
        return Joiner.on((String)".").join(elements);
    }

    private String getNameForMetric(AbstractDSSDBService.DSSDBRef ref) {
        return DSSDBConnectionsManagementService.isProjectTimeline(ref.name) ? ref.name : ref.nameForConfigKey;
    }

    synchronized void deleteConnectionPool(AbstractDSSDBService.DSSDBRef ref) {
        assert (this.isUsingInternalH2()) : "Cannot delete a connection pool when DSS instance is using single db mode.";
        String h2URL = DSSDBConnectionsManagementService.buildH2JdbcUrl(ref);
        if (!this.multiDBConnectionPools.containsKey(h2URL)) {
            logger.errorV("Connection pool already deleted for %s", new Object[]{h2URL});
        }
        ConnectionPool connectionPool = this.multiDBConnectionPools.remove(h2URL);
        logger.debugV("Clearing idle connections (%s) from the pool for %s", new Object[]{connectionPool.getNumIdle(), h2URL});
        connectionPool.clear();
        try {
            connectionPool.close();
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Could not close the connection pool for %s", new Object[]{h2URL});
        }
        String nameForMetric = this.getNameForMetric(ref);
        DSSMetrics.registry().remove(DSSDBConnectionsManagementService.buildMultiDBMetricName(nameForMetric, "activeConnections"));
        DSSMetrics.registry().remove(DSSDBConnectionsManagementService.buildMultiDBMetricName(nameForMetric, "idleConnections"));
    }

    private synchronized ConnectionPool getConnectionPool(AbstractDSSDBService.DSSDBRef ref) {
        int m;
        int a;
        if (this.isUsingInternalH2()) {
            String h2URL = DSSDBConnectionsManagementService.buildH2JdbcUrl(ref);
            if (!this.multiDBConnectionPools.containsKey(h2URL)) {
                String nameForMetric = this.getNameForMetric(ref);
                final ConnectionPool pool = new ConnectionPool(new SingleH2DatabaseConnectionsFactory(ref.name, nameForMetric, h2URL), this.connectionMonitor);
                this.multiDBConnectionPools.put(h2URL, pool);
                DSSMetrics.registry().register(DSSDBConnectionsManagementService.buildMultiDBMetricName(nameForMetric, "activeConnections"), (Metric)new Gauge<Integer>(){

                    public Integer getValue() {
                        return pool.getNumActive();
                    }
                });
                DSSMetrics.registry().register(DSSDBConnectionsManagementService.buildMultiDBMetricName(nameForMetric, "idleConnections"), (Metric)new Gauge<Integer>(){

                    public Integer getValue() {
                        return pool.getNumIdle();
                    }
                });
            }
            return this.multiDBConnectionPools.get(h2URL);
        }
        if (this.singleDBConnectionPool == null) {
            this.singleDBConnectionPool = new ConnectionPool(new ExternalDatabaseConnectionFactory(sqlConnectionData), this.connectionMonitor);
            DSSMetrics.registry().register(DSSDBConnectionsManagementService.buildSingleDBMetricName("activeConnections"), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return DSSDBConnectionsManagementService.this.singleDBConnectionPool.getNumActive();
                }
            });
            DSSMetrics.registry().register(DSSDBConnectionsManagementService.buildSingleDBMetricName("idleConnections"), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return DSSDBConnectionsManagementService.this.singleDBConnectionPool.getNumIdle();
                }
            });
        }
        if ((a = this.singleDBConnectionPool.getNumActive()) >= (m = this.singleDBConnectionPool.getMaxActive()) || m - a < 2) {
            logger.warnV("Maximum number of simultaneous DB connections almost reached (%s/%s)", new Object[]{a, m});
        }
        return this.singleDBConnectionPool;
    }

    public static ServerMapping getMappingForServer(String name) {
        try {
            ServersMappingFile smf = (ServersMappingFile)JSON.parseFile((File)ApplicationConfigurator.getFile((String)"run/dbservers.json"), ServersMappingFile.class);
            if (smf == null) {
                throw new IllegalStateException("No server mapping");
            }
            ServerMapping mapping = smf.servers.get(name);
            if (mapping == null) {
                throw new IllegalStateException("No server mapping for " + name);
            }
            return mapping;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read server mapping", e);
        }
    }

    static {
        tablePrefix = "";
        initialized = false;
        logger = DKULogger.getLogger((String)"dku.db.internal");
    }

    static class ServersMappingFile {
        Map<String, ServerMapping> servers = new HashMap<String, ServerMapping>();

        ServersMappingFile() {
        }
    }

    public static class ServerMapping {
        public int port;
        public String key;
    }

    public static class ConnectionPool
    extends GenericObjectPool<DSSDBConnection> {
        @Nullable
        private final DSSDBConnectionDebugMonitor connectionDebugMonitor;

        public ConnectionPool(AbstractConnectionFactory factory) {
            this(factory, null);
        }

        public ConnectionPool(AbstractConnectionFactory factory, DSSDBConnectionDebugMonitor connectionDebugMonitor) {
            super((PoolableObjectFactory)factory);
            this.configureConnectionsPool();
            factory.setConnectionsPool(this);
            this.connectionDebugMonitor = connectionDebugMonitor;
        }

        private void configureConnectionsPool() {
            this.setLifo(useLifoPool);
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(true);
            this.setWhenExhaustedAction((byte)1);
            this.setMinEvictableIdleTimeMillis(connectionsEvictionTimeMS);
            this.setTimeBetweenEvictionRunsMillis(evictionIntervalMS);
            this.setMaxActive(maxPooledConnections);
        }

        public DSSDBConnection borrowObject() throws Exception {
            return this.borrowObject(false);
        }

        private DSSDBConnection borrowObject(boolean isReadOnly) throws Exception {
            logger.traceV("Borrowing a connection. Read-only: %s", new Object[]{isReadOnly});
            DSSDBConnection connection = ((DSSDBConnection)super.borrowObject()).setReadOnly(isReadOnly);
            if (this.connectionDebugMonitor != null) {
                connection.startTracking(this.connectionDebugMonitor);
            }
            return connection;
        }
    }
}

