/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.comparator;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedResourceWithTagsComparator;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelConfig;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Model;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class VertexAIModelComparator
implements DeploymentResourceComparator<Model> {
    private final VertexAIModel model;
    private final VertexAIModelConfigComparator configComparator;

    public VertexAIModelComparator(VertexAIModel model) {
        this.model = model;
        this.configComparator = new VertexAIModelConfigComparator(model.config);
    }

    @Override
    public Set<String> reportUnrecoverableOutOfSyncFields(@Nonnull Model deployedModel) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (!VertexAIUtils.areModelFullNamesEqual(this.model.getFullName(), deployedModel.getName(), true)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Model name", deployedModel.getName(), this.model.getFullName()));
        }
        outOfSyncFields.addAll(this.configComparator.reportUnrecoverableOutOfSyncFields(deployedModel));
        return outOfSyncFields;
    }

    @Override
    public Set<String> reportRecoverableOutOfSyncFields(@Nonnull Model deployedModel) {
        return this.configComparator.reportRecoverableOutOfSyncFields(deployedModel);
    }

    public static class VertexAIModelConfigComparator
    extends AbstractFullyManagedResourceWithTagsComparator {
        private final VertexAIModelConfig config;

        private VertexAIModelConfigComparator(VertexAIModelConfig config) {
            this.config = config;
        }

        @Override
        protected Map<String, String> getStoredTags() {
            return this.config.tags;
        }

        @Override
        protected String getSeparatorOfDssVersionsInTags() {
            return "-";
        }

        public Set<String> reportUnrecoverableOutOfSyncFields(@Nonnull Model deployedModel) {
            HashSet<String> outOfSyncFields = new HashSet<String>();
            outOfSyncFields.addAll(this.reportOutOfSyncDSSTags(deployedModel.getLabelsMap()));
            outOfSyncFields.addAll(DeploymentResourceComparator.reportOutOfSyncImageNameFields(this.config.imageUri, deployedModel.getContainerSpec().getImageUri()));
            Set<SimpleKeyValue> deployedEnvVar = deployedModel.getContainerSpec().getEnvList().stream().map(e -> new SimpleKeyValue(e.getName(), e.getValue())).collect(Collectors.toSet());
            if (!CollectionUtils.equalsOrBothEmpty(new HashSet<SimpleKeyValue>(this.config.environmentVariables), deployedEnvVar)) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Container environment variables", DeploymentResourceComparator.censorValues(deployedEnvVar), DeploymentResourceComparator.censorValues(this.config.environmentVariables)));
            }
            return outOfSyncFields;
        }

        Set<String> reportRecoverableOutOfSyncFields(@Nonnull Model deployedModel) {
            HashSet<String> outOfSyncFields = new HashSet<String>();
            outOfSyncFields.addAll(this.reportOutOfSyncNonDSSTags(deployedModel.getLabelsMap()));
            outOfSyncFields.addAll(this.reportMissingDSSTags(deployedModel.getLabelsMap()));
            return outOfSyncFields;
        }
    }
}

