/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsDAO;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.apideployer.monitoring.MetricUtils;
import com.dataiku.dip.deployer.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.deployer.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiDeploymentSystemMonitoringService {
    private final ApiNodeInfrasService apiNodeInfrasService;
    private final TransactionService transactionService;
    private final APIServiceDeploymentsDAO apiServiceDeploymentsDAO;
    public static final int STEP = 1;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.systemMonitoringService");

    public ApiDeploymentSystemMonitoringService(@Autowired ApiNodeInfrasService apiNodeInfrasService, @Autowired TransactionService transactionService, @Autowired APIServiceDeploymentsDAO apiServiceDeploymentsDAO) {
        this.apiNodeInfrasService = apiNodeInfrasService;
        this.transactionService = transactionService;
        this.apiServiceDeploymentsDAO = apiServiceDeploymentsDAO;
    }

    public void pullAndSaveInfraSystemMetricsIfNeeded_NT(AuthCtx user, @Nonnull String infrastructureId, int connectTimeout, int socketTimeout, String overridingConnectionName) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo = this.getInfraBasicInfo(user, infrastructureId);
        logger.traceV("Fetching system metrics from infrastructure: %s", new Object[]{infrastructureId});
        SystemMetric.TimeAndMetricsByDeployment infraSystemMetrics = this.apiNodeInfrasService.getSystemMetricsIfNeeded(user, infrastructureId, connectTimeout, socketTimeout, overridingConnectionName);
        if (!infraSystemMetrics.isEmpty()) {
            logger.traceV("Writing pulled system metrics to rrd files.", new Object[0]);
            this.writeInfraSystemMetricsToRrds_NT(infraSystemMetrics, infraBasicInfo.getInfraType());
        }
    }

    private void writeInfraSystemMetricsToRrds_NT(SystemMetric.TimeAndMetricsByDeployment timeAndMetricsByDeployment, AbstractDeploymentInfra.InfraType infraType) {
        for (SystemMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment : timeAndMetricsByDeployment.values()) {
            String deploymentId = timeAndMetricsForDeployment.deploymentId;
            File rrdFile = AbstractDeploymentsService.getDeploymentSystemMetricRrd(deploymentId);
            logger.traceV("Writing system metrics for deployment %s to file: %s", new Object[]{deploymentId, rrdFile.getAbsolutePath()});
            try {
                this.writeDeploymentSystemMetricsToRrd_NT(rrdFile, timeAndMetricsForDeployment.timeAndMetrics, infraType);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Couldn't write system metrics for deployment %s to file %s", new Object[]{deploymentId, rrdFile.getAbsolutePath()});
                continue;
            }
            logger.traceV("Wrote system metrics for deployment %s to file: %s", new Object[]{deploymentId, rrdFile.getAbsolutePath()});
        }
    }

    private void writeDeploymentSystemMetricsToRrd_NT(File rrdFile, SystemMetric.TimeAndMetrics timeAndMetrics, AbstractDeploymentInfra.InfraType infraType) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        if (!rrdFile.exists()) {
            ApiDeploymentSystemMonitoringService.createSystemMetricsRrdFile(rrdFile, infraType);
        }
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());
             RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());){
            MetricUtils.writeRrdSample(rrdDb, timeAndMetrics.timestampInSeconds, timeAndMetrics.systemMetricsByType);
        }
    }

    public void createDeploymentSystemMetricsRrd_NT(String deploymentId, AbstractDeploymentInfra.InfraType infraType) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Preparing system metrics file for deployment %s", new Object[]{deploymentId});
        File rrdFile = AbstractDeploymentsService.getDeploymentSystemMetricRrd(deploymentId);
        if (!rrdFile.exists()) {
            ApiDeploymentSystemMonitoringService.createSystemMetricsRrdFile(rrdFile, infraType);
        } else {
            logger.debugV("%s already exists, skipping.", new Object[]{rrdFile.getAbsolutePath()});
        }
    }

    public void deleteSystemMetricsRrd(String deploymentId) throws IOException {
        logger.infoV("Deleting system metrics file for deployment %s", new Object[]{deploymentId});
        File systemMetricsDir = AbstractDeploymentsService.getDeploymentSystemMetricsBaseDir(deploymentId);
        FileUtils.deleteDirectory((File)systemMetricsDir);
    }

    public static void createSystemMetricsRrdFile(File rrdFile, AbstractDeploymentInfra.InfraType infraType) throws DKUSecurityException, IOException {
        PathUtils.ensurePathStaysWithinRoot((String)rrdFile.getAbsolutePath());
        DKUFileUtils.mkdirsParent((File)rrdFile);
        RrdDef rrdDef = new RrdDef(rrdFile.getAbsolutePath());
        int heartbeatInSeconds = DKUApp.getParams().getIntParam("dku.deployer.rrdHeartbeatInSeconds", Integer.valueOf(10800));
        rrdDef.setStep(1L);
        rrdDef.setStartTime(Instant.now().minus(Duration.ofDays(1L)).getEpochSecond());
        for (SystemMetric.Type metricType : MetricUtils.INFRA_TYPE_TO_SYSTEM_METRICS.get((Object)infraType)) {
            rrdDef.addDatasource(metricType.getRrdFieldName(), DsType.GAUGE, (long)heartbeatInSeconds, 0.0, Double.MAX_VALUE);
        }
        double xff = 0.99;
        for (MetricsAggregation aggregation : MetricsAggregation.systemMetricsAggregations) {
            rrdDef.addArchive(ConsolFun.AVERAGE, xff, (int)aggregation.getIntervalInSeconds() / 1, (int)(aggregation.getDurationInSeconds() / aggregation.getIntervalInSeconds()));
        }
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());){
            try (RrdDb rrdDb = RrdDb.of((RrdDef)rrdDef);){
                logger.infoV("System metrics file created: %s", new Object[]{rrdFile.getAbsolutePath()});
            }
            catch (Exception e) {
                logger.error((Object)String.format("Can't create system metrics file: %s", rrdFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public Map<Long, Map<String, Double>> getEndpointDeploymentSystemMetrics(String deploymentId, AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo infraBasicInfo, Period period, MetricsAggregation aggregation) {
        FetchData fetchData;
        AbstractDeploymentInfra.InfraType infraType = infraBasicInfo.getInfraType();
        if (!this.apiNodeInfrasService.hasSystemMetrics(infraType)) {
            logger.warnV("System metrics collection is not available for infrastructures of type %s", new Object[]{infraType});
            return this.getEmptySystemMetrics(period, aggregation, infraType);
        }
        File rrdFile = AbstractDeploymentsService.getDeploymentSystemMetricRrd(deploymentId);
        if (!infraBasicInfo.activityMonitoringEnabled) {
            logger.warnV("Cannot fetch system metrics for deployment %s, metrics monitoring is disabled for infra %s", new Object[]{deploymentId, infraBasicInfo.getId()});
            return this.getEmptySystemMetrics(period, aggregation, infraType);
        }
        if (!rrdFile.exists()) {
            logger.warnV("The system metrics for deployment %s cannot be found", new Object[]{deploymentId});
            return this.getEmptySystemMetrics(period, aggregation, infraType);
        }
        try {
            fetchData = MetricUtils.fetchRrdData(rrdFile, aggregation, ConsolFun.AVERAGE, period);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Can't read activity metrics for deployment %s. Ignoring.", new Object[]{deploymentId});
            return this.getEmptySystemMetrics(period, aggregation, infraType);
        }
        List<String> fetchDataSources = Arrays.asList(fetchData.getDsNames());
        List missingDataSources = MetricUtils.INFRA_TYPE_TO_SYSTEM_METRICS.get((Object)infraBasicInfo.getInfraType()).stream().map(SystemMetric.Type::getRrdFieldName).filter(dsName -> !fetchDataSources.contains(dsName)).collect(Collectors.toList());
        if (!missingDataSources.isEmpty()) {
            logger.warnV("Missing data sources in RRD file %s for deployment %s: %s", new Object[]{rrdFile.getAbsolutePath(), deploymentId, missingDataSources});
            return this.getEmptySystemMetrics(period, aggregation, infraType);
        }
        HashMap<SystemMetric.Type, double[]> metricsByType = new HashMap<SystemMetric.Type, double[]>();
        for (SystemMetric.Type metricType : MetricUtils.INFRA_TYPE_TO_SYSTEM_METRICS.get((Object)infraType)) {
            metricsByType.put(metricType, fetchData.getValues(metricType.getRrdFieldName()));
        }
        long[] timestamps = fetchData.getTimestamps();
        HashMap<Long, Map<String, Double>> metrics = new HashMap<Long, Map<String, Double>>();
        for (int i = 0; i < timestamps.length; ++i) {
            HashMap<String, Double> metricsAtTimestamp = new HashMap<String, Double>();
            for (SystemMetric.Type metricType : MetricUtils.INFRA_TYPE_TO_SYSTEM_METRICS.get((Object)infraType)) {
                double value = ((double[])metricsByType.get(metricType))[i];
                metricsAtTimestamp.put(metricType.getRrdFieldName(), Double.isNaN(value) ? null : Double.valueOf(value));
            }
            metrics.put(timestamps[i] * 1000L, metricsAtTimestamp);
        }
        return metrics;
    }

    private Map<Long, Map<String, Double>> getEmptySystemMetrics(Period period, MetricsAggregation aggregation, AbstractDeploymentInfra.InfraType infraType) {
        HashMap emptyMetrics = new HashMap();
        MetricUtils.INFRA_TYPE_TO_SYSTEM_METRICS.get((Object)infraType).forEach(metricType -> emptyMetrics.put(metricType.getRrdFieldName(), null));
        return Arrays.stream(MetricUtils.getTimestampsInPeriod(period, aggregation)).boxed().collect(Collectors.toMap(Function.identity(), timestamp -> emptyMetrics));
    }

    private AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo getInfraBasicInfo(AuthCtx user, String infrastructureId) throws UnauthorizedException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AbstractAPIDeploymentInfra infra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasService.getSettingsMandatoryUnsafe(infrastructureId);
            if (!AbstractInfrasService.hasReadPermission(infra, user)) {
                throw new UnauthorizedException(String.format("User does not have read access to infra %s", infrastructureId), "infra-read-denied");
            }
            AbstractInfraBasicInfo.AbstractAPIDeploymentInfraBasicInfo abstractAPIDeploymentInfraBasicInfo = this.apiNodeInfrasService.basicInfoUnsafe(infra);
            return abstractAPIDeploymentInfraBasicInfo;
        }
    }

    public List<GraphiteLine> parseAndCheckGraphitePayload(@Nonnull String graphitePayload) {
        ArrayList<GraphiteLine> graphiteLines = new ArrayList<GraphiteLine>();
        for (String line : graphitePayload.split(System.lineSeparator())) {
            try {
                graphiteLines.add(this.parseSingleGraphiteLine(line));
            }
            catch (Exception e) {
                logger.errorV("Error parsing graphite line: %s", new Object[]{line});
            }
        }
        return graphiteLines;
    }

    @VisibleForTesting
    public GraphiteLine parseSingleGraphiteLine(@Nonnull String line) throws IOException {
        String[] fields = line.split(" ");
        if (fields.length != 3) {
            throw ErrorContext.iaef((String)"Expected 3 fields separated by spaces, got %s", (Object)line, (Object[])new Object[0]);
        }
        String metricId = fields[0];
        String[] metricIdParts = metricId.split("\\.");
        if (metricIdParts.length != 2) {
            throw ErrorContext.iaef((String)"Expected metricId to be 2 fields separated by dot, e.g deploymentId.metricType, got %s", (Object)metricId, (Object[])new Object[0]);
        }
        String metricName = metricIdParts[1];
        if (!SystemMetric.Type.byRrdFieldName.containsKey(metricName)) {
            throw ErrorContext.iaef((String)"Metric type is not valid: %", (Object)metricName, (Object[])new Object[0]);
        }
        String deploymentId = metricIdParts[0];
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.apiServiceDeploymentsDAO.exists(deploymentId)) {
                throw ErrorContext.iaef((String)"Deployment %s does not exist", (Object)deploymentId, (Object[])new Object[0]);
            }
        }
        double metricValue = Double.parseDouble(fields[1]);
        long timestamp = Long.parseLong(fields[2]);
        return new GraphiteLine(deploymentId, SystemMetric.Type.byRrdFieldName.get(metricName), metricValue, timestamp);
    }

    public static SystemMetric.TimeAndMetricsByDeployment mergeGraphiteLines(List<GraphiteLine> graphiteLines, long timestampSeconds) {
        SystemMetric.TimeAndMetricsByDeployment result = new SystemMetric.TimeAndMetricsByDeployment();
        graphiteLines.stream().collect(Collectors.groupingBy(GraphiteLine::getDeploymentId)).forEach((deploymentId, lines) -> {
            Map<SystemMetric.Type, SystemMetric> deploymentMetrics = ApiDeploymentSystemMonitoringService.computeDeploymentMetrics(lines);
            SystemMetric.TimeAndMetrics timeAndMetrics = new SystemMetric.TimeAndMetrics(timestampSeconds, deploymentMetrics);
            SystemMetric.TimeAndMetricsForDeployment timeAndMetricsForDeployment = new SystemMetric.TimeAndMetricsForDeployment((String)deploymentId, timeAndMetrics);
            result.put(deploymentId, timeAndMetricsForDeployment);
        });
        return result;
    }

    public static Map<SystemMetric.Type, SystemMetric> computeDeploymentMetrics(List<GraphiteLine> linesForDeployment) {
        Map<SystemMetric.Type, Double> deploymentMetrics = linesForDeployment.stream().collect(Collectors.groupingBy(GraphiteLine::getMetricType, Collectors.summingDouble(GraphiteLine::getMetricValue)));
        deploymentMetrics.putAll(ApiDeploymentSystemMonitoringService.getRelativeMetrics(deploymentMetrics));
        return deploymentMetrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new SystemMetric((SystemMetric.Type)entry.getKey(), (Double)entry.getValue())));
    }

    @VisibleForTesting
    public static Map<SystemMetric.Type, Double> getRelativeMetrics(Map<SystemMetric.Type, Double> deploymentMetrics) {
        HashMap<SystemMetric.Type, Double> result = new HashMap<SystemMetric.Type, Double>();
        if (deploymentMetrics.keySet().containsAll(Set.of(SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES, SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES))) {
            result.put(SystemMetric.Type.MEMORY_USAGE_RELATIVE, ApiDeploymentSystemMonitoringService.getRelativeMetric(deploymentMetrics.get(SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES), deploymentMetrics.get(SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES)));
        }
        if (deploymentMetrics.keySet().containsAll(Set.of(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES, SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES))) {
            result.put(SystemMetric.Type.CPU_USAGE_RELATIVE, ApiDeploymentSystemMonitoringService.getRelativeMetric(deploymentMetrics.get(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES), deploymentMetrics.get(SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES)));
        }
        return result;
    }

    @VisibleForTesting
    public static Double getRelativeMetric(Double absoluteMetric, Double capacityMetric) {
        if (absoluteMetric == null || capacityMetric == null) {
            return Double.NaN;
        }
        return capacityMetric == 0.0 ? Double.NaN : absoluteMetric / capacityMetric;
    }

    public static class GraphiteLine {
        @Nonnull
        private final String deploymentId;
        @Nonnull
        private final SystemMetric.Type metricType;
        private final double metricValue;
        private final long timeInSeconds;

        public GraphiteLine(@Nonnull String deploymentId, @Nonnull SystemMetric.Type metricType, double metricValue, long timeInSeconds) {
            this.deploymentId = deploymentId;
            this.metricType = metricType;
            this.metricValue = metricValue;
            this.timeInSeconds = timeInSeconds;
        }

        @Nonnull
        public String getDeploymentId() {
            return this.deploymentId;
        }

        @Nonnull
        public SystemMetric.Type getMetricType() {
            return this.metricType;
        }

        public double getMetricValue() {
            return this.metricValue;
        }

        public long getTimeInSeconds() {
            return this.timeInSeconds;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GraphiteLine that = (GraphiteLine)o;
            return Double.compare(this.getMetricValue(), that.getMetricValue()) == 0 && this.getTimeInSeconds() == that.getTimeInSeconds() && this.getDeploymentId().equals(that.getDeploymentId()) && this.getMetricType() == that.getMetricType();
        }

        public int hashCode() {
            int result = this.getDeploymentId().hashCode();
            result = 31 * result + this.getMetricType().hashCode();
            result = 31 * result + Double.hashCode(this.getMetricValue());
            result = 31 * result + Long.hashCode(this.getTimeInSeconds());
            return result;
        }
    }
}

